/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.s3.endpoint.S3BucketAcl;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3Acl {
    private static final Logger LOG = LoggerFactory.getLogger(S3Acl.class);
    public static final String GRANT_READ = "x-amz-grant-read";
    public static final String GRANT_WRITE = "x-amz-grant-write";
    public static final String GRANT_READ_CAP = "x-amz-grant-read-acp";
    public static final String GRANT_WRITE_CAP = "x-amz-grant-write-acp";
    public static final String GRANT_FULL_CONTROL = "x-amz-grant-full-control";
    public static final String CANNED_ACL_HEADER = "x-amz-acl";

    private S3Acl() {
    }

    public static boolean isGranteeTypeSupported(String typeStr) {
        ACLIdentityType type = ACLIdentityType.getTypeFromGranteeType(typeStr);
        return type == null ? false : type.isSupported();
    }

    public static boolean isHeaderTypeSupported(String typeStr) {
        ACLIdentityType type = ACLIdentityType.getTypeFromHeaderType(typeStr);
        return type == null ? false : type.isSupported();
    }

    public static List<S3BucketAcl.Grant> ozoneNativeAclToS3Acl(OzoneAcl ozoneAcl) {
        ArrayList<S3BucketAcl.Grant> grantList = new ArrayList<S3BucketAcl.Grant>();
        if (ozoneAcl.getType() != IAccessAuthorizer.ACLIdentityType.USER) {
            return grantList;
        }
        S3BucketAcl.Grantee grantee = new S3BucketAcl.Grantee();
        grantee.setDisplayName(ozoneAcl.getName());
        grantee.setId(ozoneAcl.getName());
        List acls = ozoneAcl.getAclList();
        if (acls.contains(IAccessAuthorizer.ACLType.ALL)) {
            S3BucketAcl.Grant grant = new S3BucketAcl.Grant();
            grant.setGrantee(grantee);
            grant.setPermission(ACLType.FULL_CONTROL.toString());
            grantList.add(grant);
        } else if (acls.contains(IAccessAuthorizer.ACLType.WRITE_ACL)) {
            S3BucketAcl.Grant grant = new S3BucketAcl.Grant();
            grant.setGrantee(grantee);
            grant.setPermission(ACLType.WRITE_ACP.toString());
            grantList.add(grant);
        } else if (acls.contains(IAccessAuthorizer.ACLType.READ_ACL)) {
            S3BucketAcl.Grant grant = new S3BucketAcl.Grant();
            grant.setGrantee(grantee);
            grant.setPermission(ACLType.READ_ACP.toString());
            grantList.add(grant);
        } else if (acls.contains(IAccessAuthorizer.ACLType.WRITE) && acls.contains(IAccessAuthorizer.ACLType.DELETE) && acls.contains(IAccessAuthorizer.ACLType.CREATE)) {
            S3BucketAcl.Grant grant = new S3BucketAcl.Grant();
            grant.setGrantee(grantee);
            grant.setPermission(ACLType.WRITE.toString());
            grantList.add(grant);
        } else if (acls.contains(IAccessAuthorizer.ACLType.READ) && acls.contains(IAccessAuthorizer.ACLType.LIST)) {
            S3BucketAcl.Grant grant = new S3BucketAcl.Grant();
            grant.setGrantee(grantee);
            grant.setPermission(ACLType.READ.toString());
            grantList.add(grant);
        } else {
            LOG.error("Cannot find a good mapping for Ozone ACL {} to S3", (Object)ozoneAcl.toString());
        }
        return grantList;
    }

    public static List<OzoneAcl> s3AclToOzoneNativeAclOnBucket(S3BucketAcl bucketAcl) throws OS3Exception {
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        List<S3BucketAcl.Grant> grantList = bucketAcl.getAclList().getGrantList();
        for (S3BucketAcl.Grant grant : grantList) {
            ACLIdentityType identityType = ACLIdentityType.getTypeFromGranteeType(grant.getGrantee().getXsiType());
            if (identityType != null && identityType.isSupported()) {
                String permission = grant.getPermission();
                EnumSet<IAccessAuthorizer.ACLType> acls = S3Acl.getOzoneAclOnBucketFromS3Permission(permission);
                OzoneAcl defaultOzoneAcl = OzoneAcl.of((IAccessAuthorizer.ACLIdentityType)IAccessAuthorizer.ACLIdentityType.USER, (String)grant.getGrantee().getId(), (OzoneAcl.AclScope)OzoneAcl.AclScope.DEFAULT, acls);
                OzoneAcl accessOzoneAcl = OzoneAcl.of((IAccessAuthorizer.ACLIdentityType)IAccessAuthorizer.ACLIdentityType.USER, (String)grant.getGrantee().getId(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS, acls);
                ozoneAclList.add(defaultOzoneAcl);
                ozoneAclList.add(accessOzoneAcl);
                continue;
            }
            LOG.error("Grantee type {} is not supported", (Object)grant.getGrantee().getXsiType());
            throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, grant.getGrantee().getXsiType());
        }
        return ozoneAclList;
    }

    public static EnumSet<IAccessAuthorizer.ACLType> getOzoneAclOnBucketFromS3Permission(String permission) throws OS3Exception {
        ACLType permissionType = ACLType.getType(permission);
        if (permissionType == null) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, permission);
        }
        EnumSet<IAccessAuthorizer.ACLType> acls = EnumSet.noneOf(IAccessAuthorizer.ACLType.class);
        switch (permissionType.ordinal()) {
            case 4: {
                acls.add(IAccessAuthorizer.ACLType.ALL);
                break;
            }
            case 3: {
                acls.add(IAccessAuthorizer.ACLType.WRITE_ACL);
                break;
            }
            case 2: {
                acls.add(IAccessAuthorizer.ACLType.READ_ACL);
                break;
            }
            case 1: {
                acls.add(IAccessAuthorizer.ACLType.WRITE);
                acls.add(IAccessAuthorizer.ACLType.DELETE);
                acls.add(IAccessAuthorizer.ACLType.CREATE);
                break;
            }
            case 0: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                acls.add(IAccessAuthorizer.ACLType.LIST);
                break;
            }
            default: {
                LOG.error("Failed to recognize S3 permission {}", (Object)permission);
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, permission);
            }
        }
        return acls;
    }

    public static List<OzoneAcl> s3AclToOzoneNativeAclOnVolume(S3BucketAcl bucketAcl) throws OS3Exception {
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        List<S3BucketAcl.Grant> grantList = bucketAcl.getAclList().getGrantList();
        for (S3BucketAcl.Grant grant : grantList) {
            ACLIdentityType identityType = ACLIdentityType.getTypeFromGranteeType(grant.getGrantee().getXsiType());
            if (identityType != null && identityType.isSupported()) {
                String permission = grant.getPermission();
                EnumSet<IAccessAuthorizer.ACLType> acls = S3Acl.getOzoneAclOnVolumeFromS3Permission(permission);
                OzoneAcl accessOzoneAcl = OzoneAcl.of((IAccessAuthorizer.ACLIdentityType)IAccessAuthorizer.ACLIdentityType.USER, (String)grant.getGrantee().getId(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS, acls);
                ozoneAclList.add(accessOzoneAcl);
                continue;
            }
            LOG.error("Grantee type {} is not supported", (Object)grant.getGrantee().getXsiType());
            throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, grant.getGrantee().getXsiType());
        }
        return ozoneAclList;
    }

    public static EnumSet<IAccessAuthorizer.ACLType> getOzoneAclOnVolumeFromS3Permission(String permission) throws OS3Exception {
        EnumSet<IAccessAuthorizer.ACLType> acls = EnumSet.noneOf(IAccessAuthorizer.ACLType.class);
        ACLType permissionType = ACLType.getType(permission);
        if (permissionType == null) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, permission);
        }
        switch (permissionType.ordinal()) {
            case 4: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                acls.add(IAccessAuthorizer.ACLType.WRITE);
                acls.add(IAccessAuthorizer.ACLType.READ_ACL);
                acls.add(IAccessAuthorizer.ACLType.WRITE_ACL);
                break;
            }
            case 3: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                acls.add(IAccessAuthorizer.ACLType.READ_ACL);
                acls.add(IAccessAuthorizer.ACLType.WRITE_ACL);
                break;
            }
            case 2: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                acls.add(IAccessAuthorizer.ACLType.READ_ACL);
                break;
            }
            case 1: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                acls.add(IAccessAuthorizer.ACLType.WRITE);
                break;
            }
            case 0: {
                acls.add(IAccessAuthorizer.ACLType.READ);
                break;
            }
            default: {
                LOG.error("Failed to recognize S3 permission {}", (Object)permission);
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, permission);
            }
        }
        return acls;
    }

    static enum ACLIdentityType {
        USER("CanonicalUser", true, "id"),
        GROUP("Group", false, "url"),
        USER_BY_EMAIL("AmazonCustomerByEmail", false, "emailAddress");

        private final String granteeType;
        private final boolean supported;
        private final String granteeInHeader;

        private ACLIdentityType(String val, boolean support, String headerType) {
            this.granteeType = val;
            this.supported = support;
            this.granteeInHeader = headerType;
        }

        public String getGranteeType() {
            return this.granteeType;
        }

        public String getHeaderType() {
            return this.granteeInHeader;
        }

        boolean isSupported() {
            return this.supported;
        }

        public static ACLIdentityType getTypeFromGranteeType(String typeStr) {
            for (ACLIdentityType type : ACLIdentityType.values()) {
                if (!type.getGranteeType().equals(typeStr)) continue;
                return type;
            }
            return null;
        }

        public static ACLIdentityType getTypeFromHeaderType(String typeStr) {
            for (ACLIdentityType type : ACLIdentityType.values()) {
                if (!type.getHeaderType().equals(typeStr)) continue;
                return type;
            }
            return null;
        }
    }

    static enum ACLType {
        READ("READ"),
        WRITE("WRITE"),
        READ_ACP("READ_ACP"),
        WRITE_ACP("WRITE_ACP"),
        FULL_CONTROL("FULL_CONTROL");

        private final String value;

        private ACLType(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }

        public static ACLType getType(String typeStr) {
            for (ACLType type : ACLType.values()) {
                if (!type.getValue().equals(typeStr)) continue;
                return type;
            }
            return null;
        }
    }
}

