/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.util.ProtobufUtils;

@InterfaceAudience.Private
public class OzoneBlockTokenIdentifier
extends ShortLivedTokenIdentifier {
    static final Text KIND_NAME = new Text("HDDS_BLOCK_TOKEN");
    private String blockId;
    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes;
    private long maxLength;

    public static String getTokenService(BlockID blockID) {
        return String.valueOf(blockID.getContainerBlockID());
    }

    public OzoneBlockTokenIdentifier() {
    }

    public OzoneBlockTokenIdentifier(String ownerId, BlockID blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long expiryDate, long maxLength) {
        this(ownerId, OzoneBlockTokenIdentifier.getTokenService(blockId), modes, expiryDate, maxLength);
    }

    public OzoneBlockTokenIdentifier(String ownerId, String blockId, Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> modes, long expiryDate, long maxLength) {
        super(ownerId, Instant.ofEpochMilli(expiryDate));
        this.blockId = blockId;
        this.modes = modes == null ? EnumSet.noneOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class) : EnumSet.copyOf(modes);
        this.maxLength = maxLength;
    }

    @Override
    public String getService() {
        return this.blockId;
    }

    public long getExpiryDate() {
        return this.getExpiry().toEpochMilli();
    }

    public Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAccessModes() {
        return this.modes;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public String toString() {
        return "block_token_identifier (" + super.toString() + ", blockId=" + this.blockId + ", access modes=" + this.modes + ", maxLength=" + this.maxLength + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OzoneBlockTokenIdentifier that = (OzoneBlockTokenIdentifier)((Object)obj);
        return super.equals((Object)that) && Objects.equals(this.blockId, that.blockId) && Objects.equals(this.modes, that.modes) && this.maxLength == that.maxLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxLength, this.blockId, this.modes);
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        if (!dis.markSupported()) {
            throw new IOException("Could not peek first byte.");
        }
        HddsProtos.BlockTokenSecretProto token = HddsProtos.BlockTokenSecretProto.parseFrom((InputStream)((DataInputStream)in));
        this.readFromProto(token);
    }

    @Override
    public void readFromByteArray(byte[] bytes) throws IOException {
        HddsProtos.BlockTokenSecretProto token = HddsProtos.BlockTokenSecretProto.parseFrom((byte[])bytes);
        this.readFromProto(token);
    }

    private void readFromProto(HddsProtos.BlockTokenSecretProto token) {
        this.setOwnerId(token.getOwnerId());
        this.setExpiry(Instant.ofEpochMilli(token.getExpiryDate()));
        this.setSecretKeyId(ProtobufUtils.fromProtobuf(token.getSecretKeyId()));
        this.blockId = token.getBlockId();
        this.modes = EnumSet.copyOf(token.getModesList());
        this.maxLength = token.getMaxLength();
    }

    @VisibleForTesting
    public static OzoneBlockTokenIdentifier readFieldsProtobuf(DataInput in) throws IOException {
        HddsProtos.BlockTokenSecretProto token = HddsProtos.BlockTokenSecretProto.parseFrom((InputStream)((DataInputStream)in));
        OzoneBlockTokenIdentifier tokenId = new OzoneBlockTokenIdentifier(token.getOwnerId(), token.getBlockId(), EnumSet.copyOf(token.getModesList()), token.getExpiryDate(), token.getMaxLength());
        tokenId.setSecretKeyId(ProtobufUtils.fromProtobuf(token.getSecretKeyId()));
        return tokenId;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.getBytes());
    }

    public byte[] getBytes() {
        HddsProtos.BlockTokenSecretProto.Builder builder = HddsProtos.BlockTokenSecretProto.newBuilder().setBlockId(this.blockId).setOwnerId(this.getOwnerId()).setSecretKeyId(ProtobufUtils.toProtobuf(this.getSecretKeyId())).setExpiryDate(this.getExpiryDate()).setMaxLength(this.maxLength);
        for (HddsProtos.BlockTokenSecretProto.AccessModeProto mode : this.modes) {
            builder.addModes(HddsProtos.BlockTokenSecretProto.AccessModeProto.valueOf((String)mode.name()));
        }
        return builder.build().toByteArray();
    }
}

