/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.ListPaginationOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.PrefixFilterOption;
import org.apache.hadoop.ozone.shell.bucket.InfoBucketHandler;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"lists the buckets in a volume."})
public class ListBucketHandler
extends VolumeHandler {
    @CommandLine.Mixin
    private ListPaginationOptions listOptions;
    @CommandLine.Mixin
    private PrefixFilterOption prefixFilter;
    @CommandLine.Option(names={"--has-snapshot"}, description={"Only show buckets that have at least one active snapshot."})
    private boolean filterByHasSnapshot;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        int counter;
        String volumeName = address.getVolumeName();
        ObjectStore objectStore = client.getObjectStore();
        OzoneVolume vol = objectStore.getVolume(volumeName);
        Iterator bucketIterator = vol.listBuckets(this.prefixFilter.getPrefix(), this.listOptions.getStartItem(), this.filterByHasSnapshot);
        ArrayList<InfoBucketHandler.LinkBucket> bucketList = new ArrayList<InfoBucketHandler.LinkBucket>();
        for (counter = 0; bucketIterator.hasNext() && counter < this.listOptions.getLimit(); ++counter) {
            OzoneBucket bucket = (OzoneBucket)bucketIterator.next();
            if (bucket.isLink()) {
                bucketList.add(new InfoBucketHandler.LinkBucket(bucket));
                continue;
            }
            bucketList.add((InfoBucketHandler.LinkBucket)bucket);
        }
        this.printAsJsonArray(bucketList.iterator(), this.listOptions.getLimit());
        if (this.isVerbose()) {
            this.err().printf("Found : %d buckets for volume : %s ", counter, volumeName);
        }
    }
}

