/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.ozone.OzoneConfigKeys;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HttpConfig {
    private HttpConfig() {
    }

    public static Policy getHttpPolicy(MutableConfigurationSource conf) {
        String policyStr = conf.get("ozone.http.policy", OzoneConfigKeys.OZONE_HTTP_POLICY_DEFAULT);
        Policy policy = Policy.fromString(policyStr);
        if (policy == null) {
            throw new IllegalArgumentException("Unrecognized value '" + policyStr + "' for " + "ozone.http.policy");
        }
        conf.set("ozone.http.policy", policy.name());
        return policy;
    }

    public static enum Policy {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS;

        private static final Policy[] VALUES;

        public static Policy fromString(String value) {
            for (Policy p : VALUES) {
                if (!p.name().equalsIgnoreCase(value)) continue;
                return p;
            }
            return null;
        }

        public boolean isHttpEnabled() {
            return this == HTTP_ONLY || this == HTTP_AND_HTTPS;
        }

        public boolean isHttpsEnabled() {
            return this == HTTPS_ONLY || this == HTTP_AND_HTTPS;
        }

        static {
            VALUES = Policy.values();
        }
    }
}

