/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerCheck;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.ozoneimpl.DataScanResult;
import org.apache.hadoop.ozone.container.ozoneimpl.MetadataScanResult;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueContainer
implements Container<KeyValueContainerData> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueContainer.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object dumpLock = new Object();
    private final KeyValueContainerData containerData;
    private final ConfigurationSource config;
    private Set<Long> pendingPutBlockCache;
    private boolean bCheckChunksFilePath;

    public KeyValueContainer(KeyValueContainerData containerData, ConfigurationSource ozoneConfig) {
        Objects.requireNonNull(containerData, "containerData == null");
        Objects.requireNonNull(ozoneConfig, "ozoneConfig == null");
        this.config = ozoneConfig;
        this.containerData = containerData;
        this.pendingPutBlockCache = this.containerData.isOpen() || this.containerData.isClosing() ? new HashSet<Long>() : Collections.emptySet();
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)this.config.getObject(DatanodeConfiguration.class));
        this.bCheckChunksFilePath = dnConf.getCheckEmptyContainerDir();
    }

    @VisibleForTesting
    public void setCheckChunksFilePath(boolean bCheckChunksDirFilePath) {
        this.bCheckChunksFilePath = bCheckChunksDirFilePath;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void create(VolumeSet volumeSet, VolumeChoosingPolicy volumeChoosingPolicy, String clusterId) throws StorageContainerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    protected void createContainerMetaData(File containerMetaDataPath, File chunksPath, File dbFile, String schemaVersion, ConfigurationSource configuration) throws IOException {
        KeyValueContainerUtil.createContainerMetaData(containerMetaDataPath, chunksPath, dbFile, schemaVersion, configuration);
    }

    public void populatePathFields(String clusterId, HddsVolume containerVolume) {
        long containerId = this.containerData.getContainerID();
        String hddsVolumeDir = containerVolume.getHddsRootDir().getAbsolutePath();
        File containerMetaDataPath = KeyValueContainerLocationUtil.getContainerMetaDataPath(hddsVolumeDir, clusterId, containerId);
        File chunksPath = KeyValueContainerLocationUtil.getChunksLocationPath(hddsVolumeDir, clusterId, containerId);
        this.containerData.setMetadataPath(containerMetaDataPath.getPath());
        this.containerData.setChunksPath(chunksPath.getPath());
        this.containerData.setVolume(containerVolume);
        this.containerData.setDbFile(this.getContainerDBFile());
    }

    private void writeToContainerFile(File containerFile, boolean isCreate) throws StorageContainerException {
        File tempContainerFile = null;
        try {
            tempContainerFile = this.createTempFile(containerFile);
            ContainerDataYaml.createContainerFile(this.containerData, tempContainerFile);
            if (isCreate) {
                NativeIO.renameTo((File)tempContainerFile, (File)containerFile);
            } else {
                Files.move(tempContainerFile.toPath(), containerFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            StorageVolumeUtil.onFailure(this.containerData.getVolume());
            String op = tempContainerFile == null ? "create tmp file for " : (isCreate ? "create" : "update") + " container file ";
            throw new StorageContainerException("Failed to " + op + containerFile.getAbsolutePath() + ": " + this.containerData, (Throwable)ex, ContainerProtos.Result.CONTAINER_FILES_CREATE_ERROR);
        }
        finally {
            if (tempContainerFile != null && tempContainerFile.exists() && !tempContainerFile.delete()) {
                LOG.warn("Unable to delete container temporary file: {}.", (Object)tempContainerFile.getAbsolutePath());
            }
        }
    }

    private void createContainerFile(File containerFile) throws StorageContainerException {
        this.writeToContainerFile(containerFile, true);
    }

    private void updateContainerFile(File containerFile) throws StorageContainerException {
        this.writeToContainerFile(containerFile, false);
    }

    @Override
    public void delete() throws StorageContainerException {
        try {
            File tmpDirectoryPath = KeyValueContainerUtil.getTmpDirectoryPath(this.containerData, this.containerData.getVolume()).toFile();
            FileUtils.deleteDirectory((File)tmpDirectoryPath);
        }
        catch (StorageContainerException ex) {
            throw ex;
        }
        catch (IOException ex) {
            StorageVolumeUtil.onFailure(this.containerData.getVolume());
            String errMsg = "Failed to cleanup " + this.containerData;
            LOG.error(errMsg, (Throwable)ex);
            throw new StorageContainerException(errMsg, (Throwable)ex, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
    }

    @Override
    public boolean hasBlocks() throws IOException {
        try (DBHandle db = BlockUtils.getDB(this.containerData, this.config);){
            boolean bl = !KeyValueContainerUtil.noBlocksInContainer(db.getStore(), this.containerData, this.bCheckChunksFilePath);
            return bl;
        }
    }

    @Override
    public void markContainerForClose() throws StorageContainerException {
        this.writeLock();
        try {
            if (!HddsUtils.isOpenToWriteState((ContainerProtos.ContainerDataProto.State)this.getContainerState())) {
                throw new StorageContainerException("Attempting to close a " + this.getContainerState() + " container.", ContainerProtos.Result.CONTAINER_NOT_OPEN);
            }
            this.updateContainerState(ContainerProtos.ContainerDataProto.State.CLOSING);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void markContainerUnhealthy() throws StorageContainerException {
        this.writeLock();
        ContainerProtos.ContainerDataProto.State prevState = this.containerData.getState();
        try {
            this.updateContainerState(ContainerProtos.ContainerDataProto.State.UNHEALTHY);
            this.clearPendingPutBlockCache();
        }
        finally {
            this.writeUnlock();
        }
        LOG.warn("Marked container UNHEALTHY from {}: {}", (Object)prevState, (Object)this.containerData);
    }

    @Override
    public void markContainerForDelete() {
        this.writeLock();
        ContainerProtos.ContainerDataProto.State prevState = this.containerData.getState();
        try {
            this.containerData.setState(ContainerProtos.ContainerDataProto.State.DELETED);
            this.updateContainerFile(this.getContainerFile());
        }
        catch (IOException ioe) {
            LOG.error("Failed to updateContainerFile: {}", (Object)this.containerData, (Object)ioe);
        }
        finally {
            this.writeUnlock();
        }
        LOG.warn("Marked container DELETED from {}: {}", (Object)prevState, (Object)this.containerData);
    }

    @Override
    public void quasiClose() throws StorageContainerException {
        this.closeAndFlushIfNeeded(this.containerData::quasiCloseContainer);
    }

    @Override
    public void close() throws StorageContainerException {
        try (DBHandle db = BlockUtils.getDB(this.containerData, this.config);){
            this.containerData.clearFinalizedBlock(db);
        }
        catch (IOException ex) {
            LOG.error("Error in deleting entry from Finalize Block table", (Throwable)ex);
            throw new StorageContainerException((Throwable)ex, ContainerProtos.Result.IO_EXCEPTION);
        }
        this.closeAndFlushIfNeeded(this.containerData::closeContainer);
        LOG.info("Closed container: {}", (Object)this.containerData);
    }

    @Override
    public void updateDataScanTimestamp(Instant time) throws StorageContainerException {
        this.writeLock();
        try {
            this.updateContainerData(() -> this.containerData.updateDataScanTime(time));
        }
        finally {
            this.writeUnlock();
        }
    }

    private void closeAndFlushIfNeeded(Runnable closer) throws StorageContainerException {
        this.flushAndSyncDB();
        this.writeLock();
        try {
            this.flushAndSyncDB();
            this.updateContainerData(closer);
            this.clearPendingPutBlockCache();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void updateContainerState(ContainerProtos.ContainerDataProto.State newState) throws StorageContainerException {
        this.updateContainerData(() -> this.containerData.setState(newState));
    }

    private void updateContainerData(Runnable update) throws StorageContainerException {
        Preconditions.checkState((boolean)this.hasWriteLock());
        ContainerProtos.ContainerDataProto.State oldState = this.containerData.getState();
        try {
            update.run();
            this.updateContainerFile(this.getContainerFile());
        }
        catch (StorageContainerException ex) {
            if (this.containerData.getState() != ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                this.containerData.setState(oldState);
            }
            throw ex;
        }
    }

    private void compactDB() throws StorageContainerException {
        try (DBHandle db = BlockUtils.getDB(this.containerData, this.config);){
            db.getStore().compactDB();
        }
        catch (StorageContainerException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("Error in DB compaction while closing container", (Throwable)ex);
            StorageVolumeUtil.onFailure(this.containerData.getVolume());
            throw new StorageContainerException((Throwable)ex, ContainerProtos.Result.ERROR_IN_COMPACT_DB);
        }
    }

    private void flushAndSyncDB() throws StorageContainerException {
        try (DBHandle db = BlockUtils.getDB(this.containerData, this.config);){
            db.getStore().flushLog(true);
            LOG.info("Synced container: {}", (Object)this.containerData);
        }
        catch (StorageContainerException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("Error in DB sync while closing container", (Throwable)ex);
            StorageVolumeUtil.onFailure(this.containerData.getVolume());
            throw new StorageContainerException((Throwable)ex, ContainerProtos.Result.ERROR_IN_DB_SYNC);
        }
    }

    @Override
    public KeyValueContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public ContainerProtos.ContainerDataProto.State getContainerState() {
        return this.containerData.getState();
    }

    @Override
    public ContainerProtos.ContainerType getContainerType() {
        return ContainerProtos.ContainerType.KeyValueContainer;
    }

    @Override
    public void update(Map<String, String> metadata, boolean forceUpdate) throws StorageContainerException {
        this.update(metadata, forceUpdate, this.containerData.getMetadataPath());
    }

    @Override
    public void update(Map<String, String> metadata, boolean forceUpdate, String containerMetadataPath) throws StorageContainerException {
        if (!this.containerData.isValid()) {
            throw new StorageContainerException("Invalid container data: " + this.containerData, ContainerProtos.Result.INVALID_CONTAINER_STATE);
        }
        if (!forceUpdate && !this.containerData.isOpen()) {
            throw new StorageContainerException("Updating a closed container without force option is disallowed: " + this.containerData, ContainerProtos.Result.UNSUPPORTED_REQUEST);
        }
        Map<String, String> oldMetadata = this.containerData.getMetadata();
        try {
            this.writeLock();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                this.containerData.addMetadata(entry.getKey(), entry.getValue());
            }
            File containerFile = KeyValueContainer.getContainerFile(containerMetadataPath, this.containerData.getContainerID());
            this.updateContainerFile(containerFile);
        }
        catch (StorageContainerException ex) {
            this.containerData.setMetadata(oldMetadata);
            throw ex;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void updateDeleteTransactionId(long deleteTransactionId) {
        this.containerData.updateDeleteTransactionId(deleteTransactionId);
    }

    @Override
    public void importContainerData(InputStream input, ContainerPacker<KeyValueContainerData> packer) throws IOException {
        HddsVolume hddsVolume = this.containerData.getVolume();
        String idDir = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(hddsVolume, hddsVolume.getClusterID());
        long containerId = this.containerData.getContainerID();
        Path destContainerDir = Paths.get(KeyValueContainerLocationUtil.getBaseContainerLocation(hddsVolume.getHddsRootDir().toString(), idDir, containerId), new String[0]);
        Path tmpDir = ContainerImporter.getUntarDirectory(hddsVolume);
        this.writeLock();
        try {
            byte[] descriptorContent = packer.unpackContainerData(this, input, tmpDir, destContainerDir);
            Objects.requireNonNull(descriptorContent, () -> "Missing container descriptor from the archive: " + this.getContainerData());
            KeyValueContainerData originalContainerData = (KeyValueContainerData)ContainerDataYaml.readContainer(descriptorContent);
            this.importContainerData(originalContainerData);
        }
        catch (Exception ex) {
            try {
                Path containerUntarDir = tmpDir.resolve(String.valueOf(containerId));
                if (containerUntarDir.toFile().exists()) {
                    FileUtils.deleteDirectory((File)containerUntarDir.toFile());
                }
            }
            catch (Exception deleteex) {
                LOG.error("Can not cleanup container directory under {} for container {}", new Object[]{tmpDir, containerId, deleteex});
            }
            if (ex instanceof StorageContainerException && ((StorageContainerException)((Object)ex)).getResult() == ContainerProtos.Result.CONTAINER_ALREADY_EXISTS) {
                throw ex;
            }
            try {
                if (this.containerData.hasSchema("3")) {
                    BlockUtils.removeContainerFromDB(this.containerData, this.config);
                }
                FileUtils.deleteDirectory((File)new File(this.containerData.getMetadataPath()));
                FileUtils.deleteDirectory((File)new File(this.containerData.getChunksPath()));
                FileUtils.deleteDirectory((File)new File(this.getContainerData().getContainerPath()));
            }
            catch (Exception deleteex) {
                LOG.error("Can not cleanup destination directories after a container import error (cid: {}", (Object)containerId, (Object)deleteex);
            }
            throw ex;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void importContainerData(KeyValueContainerData originalContainerData) throws IOException {
        this.containerData.setContainerDBType(originalContainerData.getContainerDBType());
        this.containerData.setSchemaVersion(originalContainerData.getSchemaVersion());
        if (this.containerData.hasSchema("3")) {
            BlockUtils.loadKVContainerDataFromFiles(this.containerData, this.config);
        }
        KeyValueContainerUtil.parseKVContainerData(this.containerData, this.config, true);
        this.containerData.setState(originalContainerData.getState());
        this.update(originalContainerData.getMetadata(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportContainerData(OutputStream destination, ContainerPacker<KeyValueContainerData> packer) throws IOException {
        this.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = this.getContainerData().getState();
            if (state != ContainerProtos.ContainerDataProto.State.CLOSED && state != ContainerProtos.ContainerDataProto.State.QUASI_CLOSED && state != ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                throw new IllegalStateException("Failed to export: Unexpected state in " + this.getContainerData());
            }
            try {
                if (!this.containerData.hasSchema("3")) {
                    this.compactDB();
                    BlockUtils.removeDB(this.containerData, this.config);
                }
            }
            finally {
                this.readLock();
                this.writeUnlock();
            }
            this.packContainerToDestination(destination, packer);
        }
        finally {
            if (this.lock.isWriteLockedByCurrentThread()) {
                this.writeUnlock();
            } else {
                this.readUnlock();
            }
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public boolean hasReadLock() {
        return this.lock.readLock().tryLock();
    }

    @Override
    public void writeLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public boolean hasWriteLock() {
        return this.lock.writeLock().isHeldByCurrentThread();
    }

    @Override
    public void readLockInterruptibly() throws InterruptedException {
        this.lock.readLock().lockInterruptibly();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.lock.writeLock().lockInterruptibly();
    }

    public boolean writeLockTryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.writeLock().tryLock(time, unit);
    }

    @Override
    public File getContainerFile() {
        return KeyValueContainer.getContainerFile(this.containerData.getMetadataPath(), this.containerData.getContainerID());
    }

    public static File getContainerFile(String metadataPath, long containerId) {
        return new File(metadataPath, containerId + ".container");
    }

    @Override
    public void updateBlockCommitSequenceId(long blockCommitSequenceId) {
        this.containerData.updateBlockCommitSequenceId(blockCommitSequenceId);
    }

    @Override
    public long getBlockCommitSequenceId() {
        return this.containerData.getBlockCommitSequenceId();
    }

    public boolean isBlockInPendingPutBlockCache(long localID) {
        return this.pendingPutBlockCache.contains(localID);
    }

    public void addToPendingPutBlockCache(long localID) throws StorageContainerException {
        try {
            this.pendingPutBlockCache.add(localID);
        }
        catch (UnsupportedOperationException e) {
            String msg = "Failed to add block " + localID + " to pendingPutBlockCache for " + this.containerData;
            LOG.error(msg, (Throwable)e);
            throw new StorageContainerException(msg, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
    }

    public void removeFromPendingPutBlockCache(long localID) {
        this.pendingPutBlockCache.remove(localID);
    }

    private void clearPendingPutBlockCache() {
        this.pendingPutBlockCache.clear();
        this.pendingPutBlockCache = Collections.emptySet();
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.ContainerReplicaProto getContainerReport() throws StorageContainerException {
        return this.containerData.buildContainerReplicaProto();
    }

    public File getContainerDBFile() {
        return KeyValueContainerLocationUtil.getContainerDBFile(this.containerData);
    }

    @Override
    public MetadataScanResult scanMetaData() throws InterruptedException {
        KeyValueContainerCheck checker = new KeyValueContainerCheck(this.config, this);
        return checker.fastCheck();
    }

    @Override
    public boolean shouldScanData() {
        boolean shouldScan;
        boolean bl = shouldScan = this.getContainerState() == ContainerProtos.ContainerDataProto.State.CLOSED || this.getContainerState() == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED || this.getContainerState() == ContainerProtos.ContainerDataProto.State.UNHEALTHY;
        if (!shouldScan && LOG.isDebugEnabled()) {
            LOG.debug("Container {} in state {} should not have its data scanned.", (Object)this.containerData.getContainerID(), (Object)this.containerData.getState());
        }
        return shouldScan;
    }

    @Override
    public DataScanResult scanData(DataTransferThrottler throttler, Canceler canceler) throws InterruptedException {
        if (!this.shouldScanData()) {
            throw new IllegalStateException("The checksum verification can not be done for container in state " + this.containerData.getState());
        }
        KeyValueContainerCheck checker = new KeyValueContainerCheck(this.config, this);
        return checker.fullCheck(throttler, canceler);
    }

    private File createTempFile(File file) throws IOException {
        return File.createTempFile("tmp_" + System.currentTimeMillis() + "_", file.getName(), file.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packContainerToDestination(OutputStream destination, ContainerPacker<KeyValueContainerData> packer) throws IOException {
        if (this.containerData.hasSchema("3")) {
            Object object = this.dumpLock;
            synchronized (object) {
                BlockUtils.dumpKVContainerDataToFiles(this.containerData, this.config);
                packer.pack(this, destination);
            }
        } else {
            packer.pack(this, destination);
        }
    }
}

