/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeStore;

public class DatanodeStoreWithIncrementalChunkList
extends AbstractDatanodeStore {
    public DatanodeStoreWithIncrementalChunkList(ConfigurationSource config, AbstractDatanodeDBDefinition dbDef, boolean openReadOnly) throws IOException {
        super(config, dbDef, openReadOnly);
    }

    @Override
    public BlockData getCompleteBlockData(BlockData blockData, BlockID blockID, String blockKey) throws IOException {
        BlockData lastChunk = null;
        if (blockData == null || DatanodeStoreWithIncrementalChunkList.isPartialChunkList(blockData)) {
            lastChunk = (BlockData)this.getLastChunkInfoTable().get((Object)blockKey);
        }
        if (blockData == null) {
            if (lastChunk == null) {
                throw new StorageContainerException("Unable to find the block. BlockID : " + blockID, ContainerProtos.Result.NO_SUCH_BLOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("blockData=(null), lastChunk={}", (Object)lastChunk.getChunks());
            }
            return lastChunk;
        }
        if (lastChunk != null) {
            this.reconcilePartialChunks(lastChunk, blockData);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("blockData={}, lastChunk=(null)", (Object)blockData.getChunks());
        }
        return blockData;
    }

    private void reconcilePartialChunks(BlockData lastChunk, BlockData blockData) {
        ContainerProtos.ChunkInfo lastChunkInBlockData;
        LOG.debug("blockData={}, lastChunk={}", (Object)blockData.getChunks(), (Object)lastChunk.getChunks());
        Preconditions.checkState((lastChunk.getChunks().size() == 1 ? 1 : 0) != 0);
        if (!blockData.getChunks().isEmpty() && (lastChunkInBlockData = (ContainerProtos.ChunkInfo)blockData.getChunks().get(blockData.getChunks().size() - 1)) != null) {
            Preconditions.checkState((lastChunkInBlockData.getOffset() + lastChunkInBlockData.getLen() == ((ContainerProtos.ChunkInfo)lastChunk.getChunks().get(0)).getOffset() ? 1 : 0) != 0, (Object)"chunk offset does not match");
        }
        ArrayList<ContainerProtos.ChunkInfo> chunkInfos = new ArrayList<ContainerProtos.ChunkInfo>(blockData.getChunks());
        chunkInfos.add((ContainerProtos.ChunkInfo)lastChunk.getChunks().get(0));
        blockData.setChunks(chunkInfos);
        blockData.setBlockCommitSequenceId(lastChunk.getBlockCommitSequenceId());
    }

    private static boolean isPartialChunkList(BlockData data) {
        return data.getMetadata().containsKey("incremental");
    }

    private static boolean isFullChunk(ContainerProtos.ChunkInfo chunkInfo) {
        for (ContainerProtos.KeyValue kv : chunkInfo.getMetadataList()) {
            if (!kv.getKey().equals("full")) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldAppendLastChunk(boolean endOfBlock, BlockData data) {
        if (endOfBlock || data.getChunks().isEmpty()) {
            return true;
        }
        return DatanodeStoreWithIncrementalChunkList.isFullChunk((ContainerProtos.ChunkInfo)data.getChunks().get(data.getChunks().size() - 1));
    }

    @Override
    public void putBlockByID(BatchOperation batch, boolean incremental, long localID, BlockData data, KeyValueContainerData containerData, boolean endOfBlock) throws IOException {
        if (!incremental || !DatanodeStoreWithIncrementalChunkList.isPartialChunkList(data)) {
            this.getBlockDataTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)data);
        } else if (DatanodeStoreWithIncrementalChunkList.shouldAppendLastChunk(endOfBlock, data)) {
            this.moveLastChunkToBlockData(batch, localID, data, containerData);
        } else {
            this.putBlockWithPartialChunks(batch, localID, data, containerData);
        }
    }

    private void moveLastChunkToBlockData(BatchOperation batch, long localID, BlockData data, KeyValueContainerData containerData) throws IOException {
        BlockData blockData;
        BlockData lastChunk;
        if (data.getChunks().isEmpty() && (lastChunk = (BlockData)this.getLastChunkInfoTable().get((Object)containerData.getBlockKey(localID))) != null) {
            this.reconcilePartialChunks(lastChunk, data);
        }
        if ((blockData = (BlockData)this.getBlockDataTable().get((Object)containerData.getBlockKey(localID))) == null) {
            blockData = data;
        } else {
            List chunkInfoList = blockData.getChunks();
            blockData.setChunks(new ArrayList(chunkInfoList));
            for (ContainerProtos.ChunkInfo chunk : data.getChunks()) {
                blockData.addChunk(chunk);
            }
            blockData.setBlockCommitSequenceId(data.getBlockCommitSequenceId());
        }
        this.getLastChunkInfoTable().deleteWithBatch(batch, (Object)containerData.getBlockKey(localID));
        this.getBlockDataTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)blockData);
    }

    private void putBlockWithPartialChunks(BatchOperation batch, long localID, BlockData data, KeyValueContainerData containerData) throws IOException {
        String blockKey = containerData.getBlockKey(localID);
        BlockData blockData = (BlockData)this.getBlockDataTable().get((Object)blockKey);
        if (data.getChunks().size() == 1) {
            this.getLastChunkInfoTable().putWithBatch(batch, (Object)blockKey, (Object)data);
            if (blockData == null) {
                blockData = new BlockData(data.getBlockID());
                blockData.addMetadata("incremental", "");
                blockData.setBlockCommitSequenceId(data.getBlockCommitSequenceId());
                this.getBlockDataTable().putWithBatch(batch, (Object)blockKey, (Object)blockData);
            }
        } else {
            int lastChunkIndex = data.getChunks().size() - 1;
            List<ContainerProtos.ChunkInfo> lastChunkInfo = Collections.singletonList((ContainerProtos.ChunkInfo)data.getChunks().get(lastChunkIndex));
            if (blockData == null) {
                ArrayList chunkInfos = new ArrayList(data.getChunks());
                chunkInfos.remove(lastChunkIndex);
                data.setChunks(chunkInfos);
                blockData = data;
                LOG.debug("block {} does not have full chunks yet. Adding the chunks to it {}", (Object)localID, (Object)blockData);
            } else {
                ArrayList<ContainerProtos.ChunkInfo> chunkInfos = new ArrayList<ContainerProtos.ChunkInfo>(blockData.getChunks());
                LOG.debug("blockData.getChunks()={}", chunkInfos);
                LOG.debug("data.getChunks()={}", (Object)data.getChunks());
                for (int i = 0; i < lastChunkIndex; ++i) {
                    chunkInfos.add((ContainerProtos.ChunkInfo)data.getChunks().get(i));
                }
                blockData.setChunks(chunkInfos);
                blockData.setBlockCommitSequenceId(data.getBlockCommitSequenceId());
            }
            this.getBlockDataTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)blockData);
            data.setChunks(lastChunkInfo);
            this.getLastChunkInfoTable().putWithBatch(batch, (Object)containerData.getBlockKey(localID), (Object)data);
        }
    }
}

