/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.util;

import java.time.Duration;

public final class DurationUtil {
    private DurationUtil() {
    }

    public static String getPrettyDuration(Duration duration) {
        long hours = duration.toHours();
        long minutes = duration.getSeconds() / 60L % 60L;
        long seconds = duration.getSeconds() % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        if (seconds >= 0L) {
            return String.format("%ds", seconds);
        }
        throw new IllegalStateException("Provided duration is incorrect: " + duration);
    }
}

