/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.admin.reconfig.AbstractReconfigureSubCommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureSubCommandUtil;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Check reconfig status"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ReconfigureStatusSubcommand
extends AbstractReconfigureSubCommand {
    @Override
    protected void executeCommand(HddsProtos.NodeType nodeType, String address) {
        try (ReconfigureProtocol reconfigProxy = ReconfigureSubCommandUtil.getSingleNodeReconfigureProxy(nodeType, address);){
            String serverName = reconfigProxy.getServerName();
            ReconfigurationTaskStatus status = reconfigProxy.getReconfigureStatus();
            System.out.printf("%s: Reconfiguring status for node [%s]: ", serverName, address);
            this.printReconfigurationStatus(status);
        }
        catch (IOException e) {
            System.out.println("An error occurred while executing the command for :" + address);
            e.printStackTrace(System.out);
        }
    }

    private void printReconfigurationStatus(ReconfigurationTaskStatus status) {
        if (!status.hasTask()) {
            System.out.println("no task was found.");
            return;
        }
        System.out.print("started at " + new Date(status.getStartTime()));
        if (!status.stopped()) {
            System.out.println(" and is still running.");
            return;
        }
        System.out.printf(" and finished at %s.%n", new Date(status.getEndTime()));
        if (status.getStatus() == null) {
            return;
        }
        for (Map.Entry result : status.getStatus().entrySet()) {
            if (!((Optional)result.getValue()).isPresent()) {
                System.out.printf("SUCCESS: Changed property %s%n\tFrom: \"%s\"%n\tTo: \"%s\"%n", ((ReconfigurationUtil.PropertyChange)result.getKey()).prop, ((ReconfigurationUtil.PropertyChange)result.getKey()).oldVal, ((ReconfigurationUtil.PropertyChange)result.getKey()).newVal);
                continue;
            }
            String errorMsg = (String)((Optional)result.getValue()).get();
            System.out.printf("FAILED: Change property %s%n\tFrom: \"%s\"%n\tTo: \"%s\"%n", ((ReconfigurationUtil.PropertyChange)result.getKey()).prop, ((ReconfigurationUtil.PropertyChange)result.getKey()).oldVal, ((ReconfigurationUtil.PropertyChange)result.getKey()).newVal);
            System.out.println("\tError: " + errorMsg + ".");
        }
    }
}

