/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Balancer metrics", context="dfs")
final class BalancerMetrics {
    private final Balancer balancer;
    @Metric(value={"If a balancer iterate is running"})
    private MutableGaugeInt iterateRunning;
    @Metric(value={"Bytes left to move to make cluster balanced"})
    private MutableGaugeLong bytesLeftToMove;
    @Metric(value={"Number of under utilized nodes"})
    private MutableGaugeInt numOfUnderUtilizedNodes;
    @Metric(value={"Number of over utilized nodes"})
    private MutableGaugeInt numOfOverUtilizedNodes;

    private BalancerMetrics(Balancer b) {
        this.balancer = b;
    }

    public static BalancerMetrics create(Balancer b) {
        BalancerMetrics m = new BalancerMetrics(b);
        return (BalancerMetrics)DefaultMetricsSystem.instance().register(m.getName(), null, (Object)m);
    }

    String getName() {
        return "Balancer-" + this.balancer.getNnc().getBlockpoolID();
    }

    @Metric(value={"Bytes that already moved in current doBalance run."})
    public long getBytesMovedInCurrentRun() {
        return this.balancer.getNnc().getBytesMoved().get();
    }

    void setIterateRunning(boolean iterateRunning) {
        this.iterateRunning.set(iterateRunning ? 1 : 0);
    }

    void setBytesLeftToMove(long bytesLeftToMove) {
        this.bytesLeftToMove.set(bytesLeftToMove);
    }

    void setNumOfUnderUtilizedNodes(int numOfUnderUtilizedNodes) {
        this.numOfUnderUtilizedNodes.set(numOfUnderUtilizedNodes);
    }

    void setNumOfOverUtilizedNodes(int numOfOverUtilizedNodes) {
        this.numOfOverUtilizedNodes.set(numOfOverUtilizedNodes);
    }
}

