/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum BufferState {
    OPEN(true, true, false),
    NO_MORE_BUFFERS(true, false, false),
    NO_MORE_PAGES(false, true, false),
    FLUSHING(false, false, false),
    FINISHED(false, false, true),
    FAILED(false, false, true);

    public static final Set<BufferState> TERMINAL_BUFFER_STATES;
    private final boolean newPagesAllowed;
    private final boolean newBuffersAllowed;
    private final boolean terminal;

    private BufferState(boolean newPagesAllowed, boolean newBuffersAllowed, boolean terminal) {
        this.newPagesAllowed = newPagesAllowed;
        this.newBuffersAllowed = newBuffersAllowed;
        this.terminal = terminal;
    }

    public boolean canAddPages() {
        return this.newPagesAllowed;
    }

    public boolean canAddBuffers() {
        return this.newBuffersAllowed;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    static {
        TERMINAL_BUFFER_STATES = (Set)Stream.of(BufferState.values()).filter(BufferState::isTerminal).collect(ImmutableSet.toImmutableSet());
    }
}

