/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.spi.memory.MemoryPoolId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.Map;
import java.util.Objects;

public class MemoryInfo {
    private final int availableProcessors;
    private final DataSize totalNodeMemory;
    private final Map<MemoryPoolId, MemoryPoolInfo> pools;

    @JsonCreator
    public MemoryInfo(@JsonProperty(value="availableProcessors") int availableProcessors, @JsonProperty(value="totalNodeMemory") DataSize totalNodeMemory, @JsonProperty(value="pools") Map<MemoryPoolId, MemoryPoolInfo> pools) {
        this.totalNodeMemory = Objects.requireNonNull(totalNodeMemory, "totalNodeMemory is null");
        this.pools = ImmutableMap.copyOf(Objects.requireNonNull(pools, "pools is null"));
        this.availableProcessors = availableProcessors;
    }

    @JsonProperty
    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    @JsonProperty
    public DataSize getTotalNodeMemory() {
        return this.totalNodeMemory;
    }

    @JsonProperty
    public Map<MemoryPoolId, MemoryPoolInfo> getPools() {
        return this.pools;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("availableProcessors", this.availableProcessors).add("totalNodeMemory", (Object)this.totalNodeMemory).add("pools", this.pools).toString();
    }
}

