/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.trino.operator.aggregation.Accumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class Aggregator {
    private final Accumulator accumulator;
    private final AggregationNode.Step step;
    private final Type intermediateType;
    private final Type finalType;
    private final int[] inputChannels;
    private final OptionalInt maskChannel;

    public Aggregator(Accumulator accumulator, AggregationNode.Step step, Type intermediateType, Type finalType, List<Integer> inputChannels, OptionalInt maskChannel) {
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
        this.step = Objects.requireNonNull(step, "step is null");
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.inputChannels = Ints.toArray((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        Preconditions.checkArgument((step.isInputRaw() || inputChannels.size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
    }

    public Type getType() {
        if (this.step.isOutputPartial()) {
            return this.intermediateType;
        }
        return this.finalType;
    }

    public void processPage(Page page) {
        if (this.step.isInputRaw()) {
            this.accumulator.addInput(page.getColumns(this.inputChannels), this.getMaskBlock(page));
        } else {
            this.accumulator.addIntermediate(page.getBlock(this.inputChannels[0]));
        }
    }

    private Optional<Block> getMaskBlock(Page page) {
        if (this.maskChannel.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(page.getBlock(this.maskChannel.getAsInt()));
    }

    public void evaluate(BlockBuilder blockBuilder) {
        if (this.step.isOutputPartial()) {
            this.accumulator.evaluateIntermediate(blockBuilder);
        } else {
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }

    public long getEstimatedSize() {
        return this.accumulator.getEstimatedSize();
    }
}

