/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class AggregatorFactory {
    private final AccumulatorFactory accumulatorFactory;
    private final AggregationNode.Step step;
    private final Type intermediateType;
    private final Type finalType;
    private final List<Integer> inputChannels;
    private final OptionalInt maskChannel;
    private final boolean spillable;

    public AggregatorFactory(AccumulatorFactory accumulatorFactory, AggregationNode.Step step, Type intermediateType, Type finalType, List<Integer> inputChannels, OptionalInt maskChannel, boolean spillable) {
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory, "accumulatorFactory is null");
        this.step = Objects.requireNonNull(step, "step is null");
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.inputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.spillable = spillable;
        Preconditions.checkArgument((step.isInputRaw() || inputChannels.size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
    }

    public Aggregator createAggregator() {
        Accumulator accumulator = this.step.isInputRaw() ? this.accumulatorFactory.createAccumulator() : this.accumulatorFactory.createIntermediateAccumulator();
        return new Aggregator(accumulator, this.step, this.intermediateType, this.finalType, this.inputChannels, this.maskChannel);
    }

    public GroupedAggregator createGroupedAggregator() {
        GroupedAccumulator accumulator = this.step.isInputRaw() ? this.accumulatorFactory.createGroupedAccumulator() : this.accumulatorFactory.createGroupedIntermediateAccumulator();
        return new GroupedAggregator(accumulator, this.step, this.intermediateType, this.finalType, this.inputChannels, this.maskChannel);
    }

    public GroupedAggregator createUnspillGroupedAggregator(AggregationNode.Step step, int inputChannel) {
        GroupedAccumulator accumulator = step.isInputRaw() ? this.accumulatorFactory.createGroupedAccumulator() : this.accumulatorFactory.createGroupedIntermediateAccumulator();
        return new GroupedAggregator(accumulator, step, this.intermediateType, this.finalType, (List<Integer>)ImmutableList.of((Object)inputChannel), this.maskChannel);
    }

    public boolean isSpillable() {
        return this.spillable;
    }
}

