/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.LambdaProvider;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CompiledAccumulatorFactory
implements AccumulatorFactory {
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final List<LambdaProvider> lambdaProviders;

    public CompiledAccumulatorFactory(Constructor<? extends Accumulator> accumulatorConstructor, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<LambdaProvider> lambdaProviders) {
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.lambdaProviders = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaProviders, "lambdaProviders is null"));
    }

    @Override
    public Accumulator createAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator() {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

