/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongAndDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.type.IntervalDayTimeType;

@AggregationFunction(value="avg")
public final class IntervalDayToSecondAverageAggregation {
    private IntervalDayToSecondAverageAggregation() {
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="interval day to second") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)value);
    }

    @CombineFunction
    public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="interval day to second")
    public static void output(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(out, Math.round(value / (double)count));
        }
    }
}

