/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.WorkProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MergePages {
    private static final int MAX_MIN_PAGE_SIZE = 0x100000;

    private MergePages() {
    }

    public static WorkProcessor<Page> mergePages(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, WorkProcessor<Page> pages, AggregatedMemoryContext memoryContext) {
        return MergePages.mergePages(types, minPageSizeInBytes, minRowCount, 0x100000, pages, memoryContext);
    }

    public static WorkProcessor<Page> mergePages(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, int maxPageSizeInBytes, WorkProcessor<Page> pages, AggregatedMemoryContext memoryContext) {
        ImmutableList typeList = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        WorkProcessor.Transformation<Page, Page> mergingTransform = typeList.isEmpty() ? new MergePositionCountPagesTransformation(minRowCount) : new MergePagesTransformation((List<Type>)typeList, minPageSizeInBytes, minRowCount, maxPageSizeInBytes, memoryContext.newLocalMemoryContext(MergePages.class.getSimpleName()));
        return pages.transform(mergingTransform);
    }

    private static class MergePositionCountPagesTransformation
    implements WorkProcessor.Transformation<Page, Page> {
        private final int minRowCount;
        private int currentRowCount;

        private MergePositionCountPagesTransformation(int minRowCount) {
            Preconditions.checkArgument((minRowCount >= 0 ? 1 : 0) != 0, (Object)"minRowCount must be greater or equal than zero");
            this.minRowCount = minRowCount;
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage == null) {
                if (this.currentRowCount == 0) {
                    return WorkProcessor.TransformationState.finished();
                }
                Page result = new Page(this.currentRowCount);
                this.currentRowCount = 0;
                return WorkProcessor.TransformationState.ofResult(result, false);
            }
            int inputPositions = inputPage.getPositionCount();
            if (inputPositions >= this.minRowCount) {
                return WorkProcessor.TransformationState.ofResult(inputPage);
            }
            this.currentRowCount += inputPositions;
            if (this.currentRowCount >= 8192) {
                this.currentRowCount -= 8192;
                return WorkProcessor.TransformationState.ofResult(new Page(8192));
            }
            return WorkProcessor.TransformationState.needsMoreData();
        }
    }

    private static class MergePagesTransformation
    implements WorkProcessor.Transformation<Page, Page> {
        private final List<Type> types;
        private final long minPageSizeInBytes;
        private final int minRowCount;
        private final LocalMemoryContext memoryContext;
        private final PageBuilder pageBuilder;
        private Page queuedPage;

        private MergePagesTransformation(List<Type> types, long minPageSizeInBytes, int minRowCount, int maxPageSizeInBytes, LocalMemoryContext memoryContext) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            Preconditions.checkArgument((minPageSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"minPageSizeInBytes must be greater or equal than zero");
            Preconditions.checkArgument((minRowCount >= 0 ? 1 : 0) != 0, (Object)"minRowCount must be greater or equal than zero");
            Preconditions.checkArgument((maxPageSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater than zero");
            Preconditions.checkArgument(((long)maxPageSizeInBytes >= minPageSizeInBytes ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater or equal than minPageSizeInBytes");
            Preconditions.checkArgument((minPageSizeInBytes <= 0x100000L ? 1 : 0) != 0, (String)"minPageSizeInBytes must be less or equal than %s", (int)0x100000);
            this.minPageSizeInBytes = minPageSizeInBytes;
            this.minRowCount = minRowCount;
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
            this.pageBuilder = PageBuilder.withMaxPageSize((int)maxPageSizeInBytes, this.types);
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            boolean inputFinished;
            if (this.queuedPage != null) {
                Page output = this.queuedPage;
                this.queuedPage = null;
                this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
                return WorkProcessor.TransformationState.ofResult(output);
            }
            boolean bl = inputFinished = inputPage == null;
            if (inputFinished) {
                if (this.pageBuilder.isEmpty()) {
                    this.memoryContext.close();
                    return WorkProcessor.TransformationState.finished();
                }
                return WorkProcessor.TransformationState.ofResult(this.flush(), false);
            }
            if (inputPage.getPositionCount() >= this.minRowCount || !MergePagesTransformation.isLoaded(inputPage) || inputPage.getSizeInBytes() >= this.minPageSizeInBytes) {
                if (this.pageBuilder.isEmpty()) {
                    return WorkProcessor.TransformationState.ofResult(inputPage);
                }
                Page output = this.pageBuilder.build();
                this.pageBuilder.reset();
                this.queuedPage = inputPage;
                this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes() + inputPage.getRetainedSizeInBytes());
                return WorkProcessor.TransformationState.ofResult(output, false);
            }
            this.appendPage(inputPage);
            if (this.pageBuilder.isFull()) {
                return WorkProcessor.TransformationState.ofResult(this.flush());
            }
            this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return WorkProcessor.TransformationState.needsMoreData();
        }

        private void appendPage(Page page) {
            this.pageBuilder.declarePositions(page.getPositionCount());
            for (int channel = 0; channel < this.types.size(); ++channel) {
                this.appendBlock(this.types.get(channel), page.getBlock(channel).getLoadedBlock(), this.pageBuilder.getBlockBuilder(channel));
            }
        }

        private void appendBlock(Type type, Block block, BlockBuilder blockBuilder) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                type.appendTo(block, position, blockBuilder);
            }
        }

        private Page flush() {
            Page output = this.pageBuilder.build();
            this.pageBuilder.reset();
            this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return output;
        }

        private static boolean isLoaded(Page page) {
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                if (block.isLoaded()) continue;
                return false;
            }
            return true;
        }
    }
}

