/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.airlift.log.Logger;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.NonceCookie;
import io.trino.server.security.oauth2.OAuth2Service;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/oauth2/callback")
public class OAuth2CallbackResource {
    private static final Logger LOG = Logger.get(OAuth2CallbackResource.class);
    public static final String CALLBACK_ENDPOINT = "/oauth2/callback";
    private final OAuth2Service service;

    @Inject
    public OAuth2CallbackResource(OAuth2Service service) {
        this.service = Objects.requireNonNull(service, "service is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"text/html"})
    public Response callback(@QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription, @QueryParam(value="error_uri") String errorUri, @CookieParam(value="__Secure-Trino-Nonce") Cookie nonce, @Context UriInfo uriInfo) {
        if (error != null) {
            return this.service.handleOAuth2Error(state, error, errorDescription, errorUri);
        }
        try {
            Objects.requireNonNull(state, "state is null");
            Objects.requireNonNull(code, "code is null");
            return this.service.finishOAuth2Challenge(state, code, uriInfo.getBaseUri().resolve(CALLBACK_ENDPOINT), NonceCookie.read(nonce));
        }
        catch (RuntimeException e) {
            LOG.debug((Throwable)e, "Authentication response could not be verified: state=%s", new Object[]{state});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cookie(new NewCookie[]{NonceCookie.delete()}).entity((Object)this.service.getInternalFailureHtml("Authentication response could not be verified")).build();
        }
    }
}

