/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NullIfCodeGenerator
implements BytecodeGenerator {
    private final RowExpression first;
    private final RowExpression second;
    private final ResolvedFunction equalsFunction;
    private final Optional<ResolvedFunction> firstCast;
    private final Optional<ResolvedFunction> secondCast;

    public NullIfCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.getArguments().size() == 2 ? 1 : 0) != 0);
        this.first = specialForm.getArguments().get(0);
        this.second = specialForm.getArguments().get(1);
        List<ResolvedFunction> functionDependencies = specialForm.getFunctionDependencies();
        Preconditions.checkArgument((functionDependencies.size() <= 3 ? 1 : 0) != 0);
        this.equalsFunction = specialForm.getOperatorDependency(OperatorType.EQUAL);
        this.firstCast = specialForm.getCastDependency(this.first.getType(), this.equalsFunction.getSignature().getArgumentTypes().get(0));
        this.secondCast = specialForm.getCastDependency(this.second.getType(), this.equalsFunction.getSignature().getArgumentTypes().get(0));
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext) {
        Scope scope = generatorContext.getScope();
        LabelNode notMatch = new LabelNode("notMatch");
        Variable firstValue = scope.createTempVariable(this.first.getType().getJavaType());
        BytecodeBlock block = new BytecodeBlock().comment("check if first arg is null").append(generatorContext.generate(this.first)).append(BytecodeUtils.ifWasNullPopAndGoto(scope, notMatch, Void.TYPE, new Class[0])).dup(this.first.getType().getJavaType()).putVariable(firstValue);
        BytecodeNode secondValue = generatorContext.generate(this.second);
        BytecodeNode equalsCall = generatorContext.generateCall(this.equalsFunction, (List<BytecodeNode>)ImmutableList.of((Object)this.firstCast.map(cast -> generatorContext.generateCall((ResolvedFunction)cast, (List<BytecodeNode>)ImmutableList.of((Object)firstValue))).orElse((BytecodeNode)firstValue), (Object)this.secondCast.map(cast -> generatorContext.generateCall((ResolvedFunction)cast, (List<BytecodeNode>)ImmutableList.of((Object)secondValue))).orElse(secondValue)));
        BytecodeBlock conditionBlock = new BytecodeBlock().append(equalsCall).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, notMatch, Void.TYPE, Boolean.TYPE));
        BytecodeBlock trueBlock = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pop(this.first.getType().getJavaType()).pushJavaDefault(this.first.getType().getJavaType());
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)conditionBlock).ifTrue((BytecodeNode)trueBlock).ifFalse((BytecodeNode)notMatch));
        return block;
    }
}

