/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.List;
import java.util.Set;

public class PruneCorrelatedJoinCorrelation
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin();

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getSubquery(), context.getLookup());
        List newCorrelation = (List)correlatedJoinNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        if (newCorrelation.size() < correlatedJoinNode.getCorrelation().size()) {
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(correlatedJoinNode.getId(), correlatedJoinNode.getInput(), correlatedJoinNode.getSubquery(), newCorrelation, correlatedJoinNode.getType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Rule.Result.empty();
    }
}

