/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.execution.QueryIdGenerator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingConnectorSession
implements ConnectorSession {
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final ConnectorSession SESSION = TestingConnectorSession.builder().build();
    private final String queryId = queryIdGenerator.createNextQueryId().toString();
    private final ConnectorIdentity identity;
    private final Optional<String> source;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> traceToken;
    private final Instant start;
    private final Map<String, PropertyMetadata<?>> properties;
    private final Map<String, Object> propertyValues;

    private TestingConnectorSession(ConnectorIdentity identity, Optional<String> source, Optional<String> traceToken, TimeZoneKey timeZoneKey, Locale locale, Instant start, List<PropertyMetadata<?>> propertyMetadatas, Map<String, Object> propertyValues) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.start = start;
        this.properties = Maps.uniqueIndex(propertyMetadatas, PropertyMetadata::getName);
        this.propertyValues = ImmutableMap.copyOf(propertyValues);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Instant getStart() {
        return this.start;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public <T> T getProperty(String name, Class<T> type) {
        PropertyMetadata<?> metadata = this.properties.get(name);
        if (metadata == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        Object value = this.propertyValues.get(name);
        if (value == null) {
            return type.cast(metadata.getDefaultValue());
        }
        return type.cast(metadata.decode(value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.getUser()).add("source", this.source.orElse(null)).add("traceToken", this.traceToken.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("start", (Object)this.start).add("properties", this.propertyValues).omitNullValues().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConnectorIdentity identity = ConnectorIdentity.ofUser((String)"user");
        private final Optional<String> source = Optional.of("test");
        private TimeZoneKey timeZoneKey = TimeZoneKey.UTC_KEY;
        private final Locale locale = Locale.ENGLISH;
        private final Optional<String> traceToken = Optional.empty();
        private Optional<Instant> start = Optional.empty();
        private List<PropertyMetadata<?>> propertyMetadatas = ImmutableList.of();
        private Map<String, Object> propertyValues = ImmutableMap.of();

        public Builder setIdentity(ConnectorIdentity identity) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            return this;
        }

        public Builder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
            return this;
        }

        public Builder setStart(Instant start) {
            this.start = Optional.of(start);
            return this;
        }

        public Builder setPropertyMetadata(List<PropertyMetadata<?>> propertyMetadatas) {
            Objects.requireNonNull(propertyMetadatas, "propertyMetadatas is null");
            this.propertyMetadatas = propertyMetadatas;
            return this;
        }

        public Builder setPropertyValues(Map<String, Object> propertyValues) {
            Objects.requireNonNull(propertyValues, "propertyValues is null");
            this.propertyValues = ImmutableMap.copyOf(propertyValues);
            return this;
        }

        public TestingConnectorSession build() {
            return new TestingConnectorSession(this.identity, this.source, this.traceToken, this.timeZoneKey, this.locale, this.start.orElse(Instant.now()), this.propertyMetadatas, this.propertyValues);
        }
    }
}

