/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.array.LongBigArray;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLong2LongMap;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import org.openjdk.jol.info.ClassLayout;

public class Long2LongOpenBigHashMap
extends AbstractLong2LongMap
implements Hash {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(Long2LongOpenBigHashMap.class).instanceSize();
    private static final boolean ASSERTS = false;
    protected LongBigArray key;
    protected LongBigArray value;
    protected long mask;
    protected boolean containsNullKey;
    protected long n;
    protected long maxFill;
    protected final long minN;
    protected long size;
    protected final float f;
    protected Long2LongMap.FastEntrySet entries;
    protected LongSet keys;
    protected LongCollection values;

    public Long2LongOpenBigHashMap(long expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.bigArraySize((long)expected, (float)f);
        this.mask = this.n - 1L;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)f);
        this.key = new LongBigArray();
        this.key.ensureCapacity(this.n + 1L);
        this.value = new LongBigArray();
        this.value.ensureCapacity(this.n + 1L);
    }

    public Long2LongOpenBigHashMap(long expected) {
        this(expected, 0.75f);
    }

    public Long2LongOpenBigHashMap() {
        this(1024L, 0.75f);
    }

    public Long2LongOpenBigHashMap(Map<? extends Long, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2LongOpenBigHashMap(Map<? extends Long, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Long2LongOpenBigHashMap(Long2LongMap m, float f) {
        this(m.size(), f);
        this.putAll((Map<? extends Long, ? extends Long>)m);
    }

    public Long2LongOpenBigHashMap(Long2LongMap m) {
        this(m, 0.75f);
    }

    public long sizeOf() {
        return INSTANCE_SIZE + this.key.sizeOf() + this.value.sizeOf();
    }

    private long realSize() {
        return this.containsNullKey ? this.size - 1L : this.size;
    }

    private void ensureCapacity(long capacity) {
        long needed = HashCommon.bigArraySize((long)capacity, (float)this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        long needed = Math.max(2L, HashCommon.bigArraySize((long)capacity, (float)this.f));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private long removeEntry(long pos) {
        long oldValue = this.value.get(pos);
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    private long removeNullEntry() {
        this.containsNullKey = false;
        long oldValue = this.value.get(this.n);
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    public void putAll(Map<? extends Long, ? extends Long> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private long find(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.n : -(this.n + 1L);
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return -(pos + 1L);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return -(pos + 1L);
        } while (k != curr);
        return pos;
    }

    private void insert(long pos, long k, long v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key.set(pos, k);
        this.value.set(pos, v);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
    }

    public long put(long k, long v) {
        long pos = this.find(k);
        if (pos < 0L) {
            this.insert(-pos - 1L, k, v);
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    private long addToValue(long pos, long incr) {
        long oldValue = this.value.get(pos);
        this.value.set(pos, oldValue + incr);
        return oldValue;
    }

    public long addTo(long k, long incr) {
        long pos;
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            LongBigArray key = this.key;
            pos = HashCommon.mix((long)k) & this.mask;
            long curr = key.get(pos);
            if (curr != 0L) {
                if (curr == k) {
                    return this.addToValue(pos, incr);
                }
                pos = pos + 1L & this.mask;
                curr = key.get(pos);
                while (curr != 0L) {
                    if (curr == k) {
                        return this.addToValue(pos, incr);
                    }
                    pos = pos + 1L & this.mask;
                    curr = key.get(pos);
                }
            }
        }
        this.key.set(pos, k);
        this.value.set(pos, this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(long pos) {
        LongBigArray key = this.key;
        while (true) {
            long curr;
            long last = pos;
            pos = pos + 1L & this.mask;
            while (true) {
                if ((curr = key.get(pos)) == 0L) {
                    key.set(last, 0L);
                    return;
                }
                long slot = HashCommon.mix((long)curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            key.set(last, curr);
            this.value.set(last, this.value.get(pos));
        }
    }

    public long remove(long k) {
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.removeEntry(pos);
    }

    public long get(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.value.get(this.n) : this.defRetValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.value.get(pos);
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.value.get(pos);
    }

    public boolean containsKey(long k) {
        if (k == 0L) {
            return this.containsNullKey;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public boolean containsValue(long v) {
        LongBigArray value = this.value;
        LongBigArray key = this.key;
        if (this.containsNullKey && value.get(this.n) == v) {
            return true;
        }
        long i = this.n;
        while (i-- != 0L) {
            if (key.get(i) == 0L || value.get(i) != v) continue;
            return true;
        }
        return false;
    }

    public long getOrDefault(long k, long defaultValue) {
        if (k == 0L) {
            return this.containsNullKey ? this.value.get(this.n) : defaultValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return defaultValue;
        }
        if (k == curr) {
            return this.value.get(pos);
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return defaultValue;
        } while (k != curr);
        return this.value.get(pos);
    }

    public long putIfAbsent(long k, long v) {
        long pos = this.find(k);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        this.insert(-pos - 1L, k, v);
        return this.defRetValue;
    }

    public boolean remove(long k, long v) {
        if (k == 0L) {
            if (this.containsNullKey && v == this.value.get(this.n)) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)k) & this.mask;
        long curr = key.get(pos);
        if (curr == 0L) {
            return false;
        }
        if (k == curr && v == this.value.get(pos)) {
            this.removeEntry(pos);
            return true;
        }
        do {
            if ((curr = key.get(pos = pos + 1L & this.mask)) != 0L) continue;
            return false;
        } while (k != curr || v != this.value.get(pos));
        this.removeEntry(pos);
        return true;
    }

    public boolean replace(long k, long oldValue, long v) {
        long pos = this.find(k);
        if (pos < 0L || oldValue != this.value.get(pos)) {
            return false;
        }
        this.value.set(pos, v);
        return true;
    }

    public long replace(long k, long v) {
        long pos = this.find(k);
        if (pos < 0L) {
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    public long computeIfAbsent(long k, LongUnaryOperator mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        long pos = this.find(k);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        long newValue = mappingFunction.applyAsLong(k);
        this.insert(-pos - 1L, k, newValue);
        return newValue;
    }

    public long computeIfAbsentNullable(long k, LongFunction<? extends Long> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        long pos = this.find(k);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        Long newValue = mappingFunction.apply(k);
        if (newValue == null) {
            return this.defRetValue;
        }
        long v = newValue;
        this.insert(-pos - 1L, k, v);
        return v;
    }

    public long computeIfPresent(long k, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long pos = this.find(k);
        if (pos < 0L) {
            return this.defRetValue;
        }
        Long newValue = remappingFunction.apply((Long)k, (Long)this.value.get(pos));
        if (newValue == null) {
            if (k == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value.set(pos, newValue.longValue());
        return newValue;
    }

    public long compute(long k, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long pos = this.find(k);
        Long newValue = remappingFunction.apply((Long)k, pos >= 0L ? Long.valueOf(this.value.get(pos)) : null);
        if (newValue == null) {
            if (pos >= 0L) {
                if (k == 0L) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos);
                }
            }
            return this.defRetValue;
        }
        long newVal = newValue;
        if (pos < 0L) {
            this.insert(-pos - 1L, k, newVal);
            return newVal;
        }
        this.value.set(pos, newVal);
        return newVal;
    }

    public long merge(long k, long v, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long pos = this.find(k);
        if (pos < 0L) {
            this.insert(-pos - 1L, k, v);
            return v;
        }
        Long newValue = remappingFunction.apply((Long)this.value.get(pos), (Long)v);
        if (newValue == null) {
            if (k == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value.set(pos, newValue.longValue());
        return newValue;
    }

    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        this.containsNullKey = false;
        this.key.fill(0L);
    }

    public int size() {
        return Math.toIntExact(this.size);
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public Long2LongMap.FastEntrySet long2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Math.toIntExact(Long2LongOpenBigHashMap.this.size);
                }

                public boolean contains(long v) {
                    return Long2LongOpenBigHashMap.this.containsValue(v);
                }

                public void clear() {
                    Long2LongOpenBigHashMap.this.clear();
                }

                public void forEach(LongConsumer consumer) {
                    if (Long2LongOpenBigHashMap.this.containsNullKey) {
                        consumer.accept(Long2LongOpenBigHashMap.this.value.get(Long2LongOpenBigHashMap.this.n));
                    }
                    long pos = Long2LongOpenBigHashMap.this.n;
                    while (pos-- != 0L) {
                        if (Long2LongOpenBigHashMap.this.key.get(pos) == 0L) continue;
                        consumer.accept(Long2LongOpenBigHashMap.this.value.get(pos));
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(long n) {
        long l = HashCommon.bigArraySize((long)n, (float)this.f);
        if (l >= this.n || this.size > HashCommon.maxFill((long)l, (float)this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        LongBigArray key = this.key;
        LongBigArray value = this.value;
        long mask = newN - 1L;
        LongBigArray newKey = new LongBigArray();
        newKey.ensureCapacity(newN + 1L);
        LongBigArray newValue = new LongBigArray();
        newValue.ensureCapacity(newN + 1L);
        long i = this.n;
        long j = this.realSize();
        while (j-- != 0L) {
            while (key.get(--i) == 0L) {
            }
            long pos = HashCommon.mix((long)key.get(i)) & mask;
            if (newKey.get(pos) != 0L) {
                pos = pos + 1L & mask;
                while (newKey.get(pos) != 0L) {
                    pos = pos + 1L & mask;
                }
            }
            newKey.set(pos, key.get(i));
            newValue.set(pos, value.get(i));
        }
        newValue.set(newN, value.get(this.n));
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)this.f);
        this.key = newKey;
        this.value = newValue;
    }

    private void checkTable() {
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Long2LongMap.Entry>
    implements Long2LongMap.FastEntrySet {
        private MapEntrySet() {
        }

        public ObjectIterator<Long2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        public ObjectIterator<Long2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Long)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Long)) {
                return false;
            }
            long k = (Long)e.getKey();
            long v = (Long)e.getValue();
            if (k == 0L) {
                return Long2LongOpenBigHashMap.this.containsNullKey && Long2LongOpenBigHashMap.this.value.get(Long2LongOpenBigHashMap.this.n) == v;
            }
            LongBigArray key = Long2LongOpenBigHashMap.this.key;
            long pos = HashCommon.mix((long)k) & Long2LongOpenBigHashMap.this.mask;
            long curr = key.get(pos);
            if (curr == 0L) {
                return false;
            }
            if (k == curr) {
                return Long2LongOpenBigHashMap.this.value.get(pos) == v;
            }
            do {
                if ((curr = key.get(pos = pos + 1L & Long2LongOpenBigHashMap.this.mask)) != 0L) continue;
                return false;
            } while (k != curr);
            return Long2LongOpenBigHashMap.this.value.get(pos) == v;
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Long)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Long)) {
                return false;
            }
            long k = (Long)e.getKey();
            long v = (Long)e.getValue();
            if (k == 0L) {
                if (Long2LongOpenBigHashMap.this.containsNullKey && Long2LongOpenBigHashMap.this.value.get(Long2LongOpenBigHashMap.this.n) == v) {
                    Long2LongOpenBigHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            LongBigArray key = Long2LongOpenBigHashMap.this.key;
            long pos = HashCommon.mix((long)k) & Long2LongOpenBigHashMap.this.mask;
            long curr = key.get(pos);
            if (curr == 0L) {
                return false;
            }
            if (curr == k) {
                if (Long2LongOpenBigHashMap.this.value.get(pos) == v) {
                    Long2LongOpenBigHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key.get(pos = pos + 1L & Long2LongOpenBigHashMap.this.mask)) != 0L) continue;
                return false;
            } while (curr != k || Long2LongOpenBigHashMap.this.value.get(pos) != v);
            Long2LongOpenBigHashMap.this.removeEntry(pos);
            return true;
        }

        public int size() {
            return Math.toIntExact(Long2LongOpenBigHashMap.this.size);
        }

        public void clear() {
            Long2LongOpenBigHashMap.this.clear();
        }

        public void forEach(Consumer<? super Long2LongMap.Entry> consumer) {
            if (Long2LongOpenBigHashMap.this.containsNullKey) {
                consumer.accept((Long2LongMap.Entry)new AbstractLong2LongMap.BasicEntry(Long2LongOpenBigHashMap.this.key.get(Long2LongOpenBigHashMap.this.n), Long2LongOpenBigHashMap.this.value.get(Long2LongOpenBigHashMap.this.n)));
            }
            long pos = Long2LongOpenBigHashMap.this.n;
            while (pos-- != 0L) {
                if (Long2LongOpenBigHashMap.this.key.get(pos) == 0L) continue;
                consumer.accept((Long2LongMap.Entry)new AbstractLong2LongMap.BasicEntry(Long2LongOpenBigHashMap.this.key.get(pos), Long2LongOpenBigHashMap.this.value.get(pos)));
            }
        }

        public void fastForEach(Consumer<? super Long2LongMap.Entry> consumer) {
            if (Long2LongOpenBigHashMap.this.containsNullKey) {
                consumer.accept((Long2LongMap.Entry)new AbstractLong2LongMap.BasicEntry(Long2LongOpenBigHashMap.this.key.get(Long2LongOpenBigHashMap.this.n), Long2LongOpenBigHashMap.this.value.get(Long2LongOpenBigHashMap.this.n)));
            }
            long pos = Long2LongOpenBigHashMap.this.n;
            while (pos-- != 0L) {
                if (Long2LongOpenBigHashMap.this.key.get(pos) == 0L) continue;
                consumer.accept((Long2LongMap.Entry)new AbstractLong2LongMap.BasicEntry(Long2LongOpenBigHashMap.this.key.get(pos), Long2LongOpenBigHashMap.this.value.get(pos)));
            }
        }
    }

    private final class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        public LongIterator iterator() {
            return new KeyIterator();
        }

        public void forEach(LongConsumer consumer) {
            if (Long2LongOpenBigHashMap.this.containsNullKey) {
                consumer.accept(Long2LongOpenBigHashMap.this.key.get(Long2LongOpenBigHashMap.this.n));
            }
            long pos = Long2LongOpenBigHashMap.this.n;
            while (pos-- != 0L) {
                long k = Long2LongOpenBigHashMap.this.key.get(pos);
                if (k == 0L) continue;
                consumer.accept(k);
            }
        }

        public int size() {
            return Math.toIntExact(Long2LongOpenBigHashMap.this.size);
        }

        public boolean contains(long k) {
            return Long2LongOpenBigHashMap.this.containsKey(k);
        }

        public boolean remove(long k) {
            long oldSize = Long2LongOpenBigHashMap.this.size;
            Long2LongOpenBigHashMap.this.remove(k);
            return Long2LongOpenBigHashMap.this.size != oldSize;
        }

        public void clear() {
            Long2LongOpenBigHashMap.this.clear();
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Long2LongOpenBigHashMap.this.value.get(this.nextEntry());
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Long2LongOpenBigHashMap.this.key.get(this.nextEntry());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Long2LongMap.Entry> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Long2LongMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1L;
        }
    }

    private class MapIterator {
        long pos;
        long last;
        long c;
        boolean mustReturnNullKey;
        LongBigArrayBigList wrapped;

        private MapIterator() {
            this.pos = Long2LongOpenBigHashMap.this.n;
            this.last = -1L;
            this.c = Long2LongOpenBigHashMap.this.size;
            this.mustReturnNullKey = Long2LongOpenBigHashMap.this.containsNullKey;
        }

        public boolean hasNext() {
            return this.c != 0L;
        }

        public long nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Long2LongOpenBigHashMap.this.n;
                return Long2LongOpenBigHashMap.this.n;
            }
            LongBigArray key = Long2LongOpenBigHashMap.this.key;
            do {
                if (--this.pos >= 0L) continue;
                this.last = Long.MIN_VALUE;
                long k = this.wrapped.getLong(-this.pos - 1L);
                long p = HashCommon.mix((long)k) & Long2LongOpenBigHashMap.this.mask;
                while (k != key.get(p)) {
                    p = p + 1L & Long2LongOpenBigHashMap.this.mask;
                }
                return p;
            } while (key.get(this.pos) == 0L);
            this.last = this.pos;
            return this.pos;
        }

        private void shiftKeys(long pos) {
            LongBigArray key = Long2LongOpenBigHashMap.this.key;
            while (true) {
                long curr;
                long last = pos;
                pos = pos + 1L & Long2LongOpenBigHashMap.this.mask;
                while (true) {
                    if ((curr = key.get(pos)) == 0L) {
                        key.set(last, 0L);
                        return;
                    }
                    long slot = HashCommon.mix((long)curr) & Long2LongOpenBigHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1L & Long2LongOpenBigHashMap.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new LongBigArrayBigList(2L);
                    }
                    this.wrapped.add(key.get(pos));
                }
                key.set(last, curr);
                Long2LongOpenBigHashMap.this.value.set(last, Long2LongOpenBigHashMap.this.value.get(pos));
            }
        }

        public void remove() {
            if (this.last == -1L) {
                throw new IllegalStateException();
            }
            if (this.last == Long2LongOpenBigHashMap.this.n) {
                Long2LongOpenBigHashMap.this.containsNullKey = false;
            } else if (this.pos >= 0L) {
                this.shiftKeys(this.last);
            } else {
                Long2LongOpenBigHashMap.this.remove(this.wrapped.getLong(-this.pos - 1L));
                this.last = -1L;
                return;
            }
            --Long2LongOpenBigHashMap.this.size;
            this.last = -1L;
        }

        public long skip(long n) {
            long i = n;
            while (i-- != 0L && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1L;
        }
    }

    final class MapEntry
    implements Long2LongMap.Entry,
    Map.Entry<Long, Long> {
        long index;

        MapEntry(long index) {
            this.index = index;
        }

        MapEntry() {
        }

        public long getLongKey() {
            return Long2LongOpenBigHashMap.this.key.get(this.index);
        }

        public long getLongValue() {
            return Long2LongOpenBigHashMap.this.value.get(this.index);
        }

        @Override
        public long setValue(long v) {
            long oldValue = Long2LongOpenBigHashMap.this.value.get(this.index);
            Long2LongOpenBigHashMap.this.value.set(this.index, v);
            return oldValue;
        }

        @Override
        @Deprecated
        public Long getKey() {
            return Long2LongOpenBigHashMap.this.key.get(this.index);
        }

        @Override
        @Deprecated
        public Long getValue() {
            return Long2LongOpenBigHashMap.this.value.get(this.index);
        }

        @Override
        @Deprecated
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2LongOpenBigHashMap.this.key.get(this.index) == ((Long)e.getKey()).longValue() && Long2LongOpenBigHashMap.this.value.get(this.index) == ((Long)e.getValue()).longValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int((long)Long2LongOpenBigHashMap.this.key.get(this.index)) ^ HashCommon.long2int((long)Long2LongOpenBigHashMap.this.value.get(this.index));
        }

        public String toString() {
            return Long2LongOpenBigHashMap.this.key.get(this.index) + "=>" + Long2LongOpenBigHashMap.this.value.get(this.index);
        }
    }
}

