/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;

public class ObjectVisitor
extends JsonObjectFormatVisitor.Base
implements JsonSchemaProducer,
Visitor {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory;
    private VisitorContext visitorContext;

    @Deprecated
    public ObjectVisitor(SerializerProvider provider, ObjectSchema schema) {
        this(provider, schema, new WrapperFactory());
    }

    public ObjectVisitor(SerializerProvider provider, ObjectSchema schema, WrapperFactory wrapperFactory) {
        this.provider = provider;
        this.schema = schema;
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    @Deprecated
    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    @Deprecated
    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    public void optionalProperty(BeanProperty prop) throws JsonMappingException {
        this.schema.putOptionalProperty(prop, this.propertySchema(prop));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.schema.putOptionalProperty(name, this.propertySchema(handler, propertyTypeHint));
    }

    public void property(BeanProperty prop) throws JsonMappingException {
        this.schema.putProperty(prop, this.propertySchema(prop));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        this.schema.putProperty(name, this.propertySchema(handler, propertyTypeHint));
    }

    protected JsonSchema propertySchema(BeanProperty prop) throws JsonMappingException {
        if (prop == null) {
            throw new IllegalArgumentException("Null property");
        }
        String seenSchemaUri = this.visitorContext.getSeenSchemaUri(prop.getType());
        if (seenSchemaUri != null) {
            return new ReferenceSchema(seenSchemaUri);
        }
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
        JsonSerializer<Object> ser = this.getSer(prop);
        if (ser != null) {
            JavaType type = prop.getType();
            if (type == null) {
                throw new IllegalStateException("Missing type for property '" + prop.getName() + "'");
            }
            ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
        }
        return visitor.finalSchema();
    }

    protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        String seenSchemaUri;
        if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(propertyTypeHint)) != null) {
            return new ReferenceSchema(seenSchemaUri);
        }
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, propertyTypeHint);
        return visitor.finalSchema();
    }

    protected JsonSerializer<Object> getSer(BeanProperty prop) throws JsonMappingException {
        JsonSerializer ser = null;
        if (prop instanceof BeanPropertyWriter) {
            ser = ((BeanPropertyWriter)prop).getSerializer();
        }
        if (ser == null) {
            ser = this.getProvider().findValueSerializer(prop.getType(), prop);
        }
        return ser;
    }

    @Override
    public Visitor setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }
}

