/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import com.google.common.collect.Range;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ScanOutcome;
import org.apache.bookkeeper.mledger.impl.PositionImpl;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedCursor {
    public String getName();

    public long getLastActive();

    public void updateLastActive();

    public Map<String, Long> getProperties();

    public Map<String, String> getCursorProperties();

    public CompletableFuture<Void> putCursorProperty(String var1, String var2);

    public CompletableFuture<Void> setCursorProperties(Map<String, String> var1);

    public CompletableFuture<Void> removeCursorProperty(String var1);

    public boolean putProperty(String var1, Long var2);

    public boolean removeProperty(String var1);

    public List<Entry> readEntries(int var1) throws InterruptedException, ManagedLedgerException;

    public void asyncReadEntries(int var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, PositionImpl var4);

    public void asyncReadEntries(int var1, long var2, AsyncCallbacks.ReadEntriesCallback var4, Object var5, PositionImpl var6);

    default public void asyncReadEntriesWithSkip(int numberOfEntriesToRead, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        this.asyncReadEntries(numberOfEntriesToRead, maxSizeBytes, callback, ctx, maxPosition);
    }

    public Entry getNthEntry(int var1, IndividualDeletedEntries var2) throws InterruptedException, ManagedLedgerException;

    public void asyncGetNthEntry(int var1, IndividualDeletedEntries var2, AsyncCallbacks.ReadEntryCallback var3, Object var4);

    public List<Entry> readEntriesOrWait(int var1) throws InterruptedException, ManagedLedgerException;

    public List<Entry> readEntriesOrWait(int var1, long var2) throws InterruptedException, ManagedLedgerException;

    public void asyncReadEntriesOrWait(int var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, PositionImpl var4);

    public void asyncReadEntriesOrWait(int var1, long var2, AsyncCallbacks.ReadEntriesCallback var4, Object var5, PositionImpl var6);

    default public void asyncReadEntriesWithSkipOrWait(int maxEntries, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        this.asyncReadEntriesOrWait(maxEntries, callback, ctx, maxPosition);
    }

    default public void asyncReadEntriesWithSkipOrWait(int maxEntries, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        this.asyncReadEntriesOrWait(maxEntries, maxSizeBytes, callback, ctx, maxPosition);
    }

    public boolean cancelPendingReadRequest();

    public boolean hasMoreEntries();

    public long getNumberOfEntries();

    public long getNumberOfEntriesInBacklog(boolean var1);

    public void markDelete(Position var1) throws InterruptedException, ManagedLedgerException;

    public void markDelete(Position var1, Map<String, Long> var2) throws InterruptedException, ManagedLedgerException;

    public void asyncMarkDelete(Position var1, AsyncCallbacks.MarkDeleteCallback var2, Object var3);

    public void asyncMarkDelete(Position var1, Map<String, Long> var2, AsyncCallbacks.MarkDeleteCallback var3, Object var4);

    public void delete(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(Position var1, AsyncCallbacks.DeleteCallback var2, Object var3);

    public void delete(Iterable<Position> var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(Iterable<Position> var1, AsyncCallbacks.DeleteCallback var2, Object var3);

    public Position getReadPosition();

    public Position getMarkDeletedPosition();

    public Position getPersistentMarkDeletedPosition();

    public void rewind();

    default public void rewind(boolean readCompacted) {
        this.rewind();
    }

    default public void seek(Position newReadPosition) {
        this.seek(newReadPosition, false);
    }

    public void seek(Position var1, boolean var2);

    public void clearBacklog() throws InterruptedException, ManagedLedgerException;

    public void asyncClearBacklog(AsyncCallbacks.ClearBacklogCallback var1, Object var2);

    public void skipEntries(int var1, IndividualDeletedEntries var2) throws InterruptedException, ManagedLedgerException;

    public void asyncSkipEntries(int var1, IndividualDeletedEntries var2, AsyncCallbacks.SkipEntriesCallback var3, Object var4);

    public Position findNewestMatching(Predicate<Entry> var1) throws InterruptedException, ManagedLedgerException;

    default public CompletableFuture<ScanOutcome> scan(Optional<Position> startingPosition, Predicate<Entry> condition, int batchSize, long maxEntries, long timeOutMs) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException());
    }

    public Position findNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2) throws InterruptedException, ManagedLedgerException;

    public void asyncFindNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2, AsyncCallbacks.FindEntryCallback var3, Object var4);

    public void asyncFindNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2, AsyncCallbacks.FindEntryCallback var3, Object var4, boolean var5);

    default public void asyncFindNewestMatching(FindPositionConstraint constraint, Predicate<Entry> condition, PositionImpl startPosition, PositionImpl endPosition, AsyncCallbacks.FindEntryCallback callback, Object ctx, boolean isFindFromLedger) {
        this.asyncFindNewestMatching(constraint, condition, callback, ctx, isFindFromLedger);
    }

    public void resetCursor(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncResetCursor(Position var1, boolean var2, AsyncCallbacks.ResetCursorCallback var3);

    public List<Entry> replayEntries(Set<? extends Position> var1) throws InterruptedException, ManagedLedgerException;

    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3);

    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, boolean var4);

    public void close() throws InterruptedException, ManagedLedgerException;

    public void asyncClose(AsyncCallbacks.CloseCallback var1, Object var2);

    public Position getFirstPosition();

    public void setActive();

    public void setInactive();

    public void setAlwaysInactive();

    public boolean isActive();

    public boolean isDurable();

    public long getNumberOfEntriesSinceFirstNotAckedMessage();

    public int getTotalNonContiguousDeletedMessagesRange();

    public int getNonContiguousDeletedMessagesRangeSerializedSize();

    public long getEstimatedSizeSinceMarkDeletePosition();

    default public void skipNonRecoverableLedger(long ledgerId) {
    }

    public double getThrottleMarkDelete();

    public void setThrottleMarkDelete(double var1);

    public ManagedLedger getManagedLedger();

    public Range<PositionImpl> getLastIndividualDeletedRange();

    public void trimDeletedEntries(List<Entry> var1);

    public long[] getDeletedBatchIndexesAsLongArray(PositionImpl var1);

    public ManagedCursorMXBean getStats();

    public boolean checkAndUpdateReadPositionChanged();

    public boolean isClosed();

    public static enum FindPositionConstraint {
        SearchActiveEntries,
        SearchAllAvailableEntries;

    }

    public static enum IndividualDeletedEntries {
        Include,
        Exclude;

    }
}

