/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Node;
import java.util.List;
import java.util.Optional;

public final class ConnectorBucketNodeMap {
    private final int bucketCount;
    private final Optional<List<Node>> bucketToNode;

    public static ConnectorBucketNodeMap createBucketNodeMap(int bucketCount) {
        return new ConnectorBucketNodeMap(bucketCount, Optional.empty());
    }

    public static ConnectorBucketNodeMap createBucketNodeMap(List<Node> bucketToNode) {
        return new ConnectorBucketNodeMap(bucketToNode.size(), Optional.of(bucketToNode));
    }

    private ConnectorBucketNodeMap(int bucketCount, Optional<List<Node>> bucketToNode) {
        if (bucketCount <= 0) {
            throw new IllegalArgumentException("bucketCount must be positive");
        }
        if (bucketToNode.isPresent() && bucketToNode.get().size() != bucketCount) {
            throw new IllegalArgumentException(String.format("Mismatched bucket count in bucketToNode (%s) and bucketCount (%s)", bucketToNode.get().size(), bucketCount));
        }
        this.bucketCount = bucketCount;
        this.bucketToNode = bucketToNode.map(List::copyOf);
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public boolean hasFixedMapping() {
        return this.bucketToNode.isPresent();
    }

    public List<Node> getFixedMapping() {
        return this.bucketToNode.orElseThrow(() -> new IllegalArgumentException("No fixed bucket to node mapping"));
    }
}

