/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelInitializer;
import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import io.grpc.netty.shaded.io.netty.channel.group.ChannelGroup;
import io.grpc.netty.shaded.io.netty.channel.group.DefaultChannelGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxEventLoopGroup;

class ServerChannelLoadBalancer
extends ChannelInitializer<Channel> {
    private final VertxEventLoopGroup workers;
    private final ConcurrentMap<EventLoop, WorkerList> workerMap = new ConcurrentHashMap<EventLoop, WorkerList>();
    private final ChannelGroup channelGroup;
    private volatile boolean hasHandlers;

    ServerChannelLoadBalancer(EventExecutor executor) {
        this.workers = new VertxEventLoopGroup();
        this.channelGroup = new DefaultChannelGroup(executor, true);
    }

    public VertxEventLoopGroup workers() {
        return this.workers;
    }

    public boolean hasHandlers() {
        return this.hasHandlers;
    }

    protected void initChannel(Channel ch) {
        Handler<Channel> handler = this.chooseInitializer(ch.eventLoop());
        if (handler == null) {
            ch.close();
        } else {
            this.channelGroup.add((Object)ch);
            handler.handle(ch);
        }
    }

    private Handler<Channel> chooseInitializer(EventLoop worker) {
        WorkerList handlers = (WorkerList)this.workerMap.get(worker);
        return handlers == null ? null : handlers.chooseHandler();
    }

    public synchronized void addWorker(EventLoop eventLoop, Handler<Channel> handler) {
        this.workers.addWorker(eventLoop);
        WorkerList handlers = new WorkerList();
        WorkerList prev = this.workerMap.putIfAbsent(eventLoop, handlers);
        if (prev != null) {
            handlers = prev;
        }
        handlers.addWorker(handler);
        this.hasHandlers = true;
    }

    public synchronized boolean removeWorker(EventLoop worker, Handler<Channel> handler) {
        WorkerList handlers = (WorkerList)this.workerMap.get(worker);
        if (handlers == null || !handlers.removeWorker(handler)) {
            return false;
        }
        if (handlers.isEmpty()) {
            this.workerMap.remove(worker);
        }
        if (this.workerMap.isEmpty()) {
            this.hasHandlers = false;
        }
        this.workers.removeWorker(worker);
        return true;
    }

    public void close() {
        this.channelGroup.close();
    }

    private static final class WorkerList {
        private int pos;
        private final List<Handler<Channel>> list = new CopyOnWriteArrayList<Handler<Channel>>();

        private WorkerList() {
        }

        Handler<Channel> chooseHandler() {
            Handler<Channel> handler = this.list.get(this.pos);
            ++this.pos;
            this.checkPos();
            return handler;
        }

        void addWorker(Handler<Channel> handler) {
            this.list.add(handler);
        }

        boolean removeWorker(Handler<Channel> handler) {
            if (this.list.remove(handler)) {
                this.checkPos();
                return true;
            }
            return false;
        }

        boolean isEmpty() {
            return this.list.isEmpty();
        }

        void checkPos() {
            if (this.pos == this.list.size()) {
                this.pos = 0;
            }
        }
    }
}

