/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.client.api.LedgerEntry;

public class LedgerEntryImpl
implements LedgerEntry {
    private static final Recycler<LedgerEntryImpl> RECYCLER = new Recycler<LedgerEntryImpl>(){

        protected LedgerEntryImpl newObject(Recycler.Handle<LedgerEntryImpl> handle) {
            return new LedgerEntryImpl(handle);
        }
    };
    private final Recycler.Handle<LedgerEntryImpl> recycleHandle;
    private long ledgerId;
    private long entryId;
    private long length;
    private ByteBuf entryBuf;

    public static LedgerEntryImpl create(long ledgerId, long entryId) {
        LedgerEntryImpl entry = (LedgerEntryImpl)RECYCLER.get();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        return entry;
    }

    public static LedgerEntryImpl create(long ledgerId, long entryId, long length, ByteBuf buf) {
        LedgerEntryImpl entry = (LedgerEntryImpl)RECYCLER.get();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.length = length;
        entry.entryBuf = buf;
        return entry;
    }

    public static LedgerEntryImpl duplicate(LedgerEntry entry) {
        return LedgerEntryImpl.create(entry.getLedgerId(), entry.getEntryId(), entry.getLength(), entry.getEntryBuffer().retainedSlice());
    }

    private LedgerEntryImpl(Recycler.Handle<LedgerEntryImpl> handle) {
        this.recycleHandle = handle;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setEntryBuf(ByteBuf buf) {
        ReferenceCountUtil.release((Object)this.entryBuf);
        this.entryBuf = buf;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public byte[] getEntryBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.entryBuf, (int)this.entryBuf.readerIndex(), (int)this.entryBuf.readableBytes(), (boolean)false);
    }

    @Override
    public ByteBuf getEntryBuffer() {
        return this.entryBuf;
    }

    @Override
    public ByteBuffer getEntryNioBuffer() {
        return this.entryBuf.nioBuffer();
    }

    @Override
    public LedgerEntryImpl duplicate() {
        return LedgerEntryImpl.duplicate(this);
    }

    @Override
    public void close() {
        this.recycle();
    }

    private void recycle() {
        this.ledgerId = -1L;
        this.entryId = -1L;
        this.length = -1L;
        ReferenceCountUtil.release((Object)this.entryBuf);
        this.entryBuf = null;
        this.recycleHandle.recycle((Object)this);
    }
}

