/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSheddingTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadSheddingTask.class);
    private final AtomicReference<LoadManager> loadManager;
    private final ScheduledExecutorService loadManagerExecutor;
    private final ServiceConfiguration config;
    private volatile boolean isCancel = false;
    private volatile ScheduledFuture<?> future;
    private final ManagedLedgerFactory factory;

    public LoadSheddingTask(AtomicReference<LoadManager> loadManager, ScheduledExecutorService loadManagerExecutor, ServiceConfiguration config, ManagedLedgerFactory factory) {
        this.loadManager = loadManager;
        this.loadManagerExecutor = loadManagerExecutor;
        this.config = config;
        this.factory = factory;
    }

    @Override
    public void run() {
        if (this.isCancel) {
            return;
        }
        try {
            if (this.factory instanceof ManagedLedgerFactoryImpl && !((ManagedLedgerFactoryImpl)this.factory).isMetadataServiceAvailable()) {
                return;
            }
            this.loadManager.get().doLoadShedding();
        }
        catch (Exception e) {
            LOG.warn("Error during the load shedding", (Throwable)e);
        }
        finally {
            this.start();
        }
    }

    public void start() {
        if (!this.isCancel && this.loadManagerExecutor != null && this.config != null) {
            this.future = this.loadManagerExecutor.schedule(this, (long)this.config.getLoadBalancerSheddingIntervalMinutes(), TimeUnit.MINUTES);
        }
    }

    public void cancel() {
        this.isCancel = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
    }
}

