/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class RoundExpression<T>
extends AbstractFunctionExpression<T, Number> {
    private final FunctionParameterTypePredicate<Number> _typeValidator = FunctionParameterTypePredicate.builder().allowNumbers().build();

    public RoundExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireMinParameters(1, args, this);
        FunctionParametersValidator.requireMaxParameters(2, args, this);
    }

    @Override
    public Number apply(T value) {
        Number number = this.evaluateChild(0, value, this._typeValidator);
        int scale = this.getOptionalConstantParameter(1, Integer.class, "Function '%s' requires argument %d to be an integer").orElse(2);
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : BigDecimal.valueOf(number.doubleValue());
        bigDecimal = bigDecimal.setScale(scale, RoundingMode.HALF_UP);
        return (Number)NumberConverter.narrow(bigDecimal);
    }
}

