/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.exception.StoreException;
import org.apache.rocketmq.store.queue.AbstractConsumeQueueStore;
import org.apache.rocketmq.store.queue.BatchConsumeQueue;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.FileQueueLifeCycle;

public class ConsumeQueueStore
extends AbstractConsumeQueueStore {
    private final FlushConsumeQueueService flushConsumeQueueService = new FlushConsumeQueueService();
    private final CorrectLogicOffsetService correctLogicOffsetService = new CorrectLogicOffsetService();
    private final CleanConsumeQueueService cleanConsumeQueueService = new CleanConsumeQueueService();
    private long dispatchFromPhyOffset;
    private long dispatchFromStoreTimestamp;

    public ConsumeQueueStore(DefaultMessageStore messageStore) {
        super(messageStore);
    }

    @Override
    public void start() {
        this.flushConsumeQueueService.start();
        this.messageStore.getScheduledCleanQueueExecutorService().scheduleWithFixedDelay(this::cleanQueueFilesPeriodically, 60000L, this.messageStoreConfig.getCleanResourceInterval(), TimeUnit.MILLISECONDS);
        log.info("Default ConsumeQueueStore start!");
    }

    private void cleanQueueFilesPeriodically() {
        this.correctLogicOffsetService.run();
        this.cleanConsumeQueueService.run();
    }

    @Override
    public boolean load() {
        boolean cqLoadResult = this.loadConsumeQueues(StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), CQType.SimpleCQ);
        boolean bcqLoadResult = this.loadConsumeQueues(StorePathConfigHelper.getStorePathBatchConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), CQType.BatchCQ);
        return cqLoadResult && bcqLoadResult;
    }

    @Override
    public void recover(boolean concurrently) {
        log.info("Start to recover consume queue concurrently={}", (Object)concurrently);
        if (concurrently) {
            this.recoverConcurrently();
        } else {
            for (ConcurrentMap maps : this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface logic : maps.values()) {
                    this.recover(logic);
                }
            }
        }
        this.dispatchFromPhyOffset = this.getMaxPhyOffsetInConsumeQueue();
        this.dispatchFromStoreTimestamp = this.messageStore.getStoreCheckpoint().getMinTimestamp();
    }

    @Override
    public long getDispatchFromPhyOffset() {
        return this.getMaxPhyOffsetInConsumeQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverConcurrently() {
        int count = 0;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            count += maps.values().size();
        }
        CountDownLatch countDownLatch = new CountDownLatch(count);
        LinkedBlockingQueue<Runnable> recoverQueue = new LinkedBlockingQueue<Runnable>();
        ExecutorService executor = this.buildExecutorService(recoverQueue, "RecoverConsumeQueueThread_");
        ArrayList<FutureTask<Boolean>> result = new ArrayList<FutureTask<Boolean>>(count);
        try {
            for (ConcurrentMap concurrentMap : this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface logic : concurrentMap.values()) {
                    FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
                        boolean ret = true;
                        try {
                            logic.recover();
                        }
                        catch (Throwable e) {
                            ret = false;
                            log.error("Exception occurs while recover consume queue concurrently, topic={}, queueId={}", new Object[]{logic.getTopic(), logic.getQueueId(), e});
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                        return ret;
                    });
                    result.add(futureTask);
                    executor.submit(futureTask);
                }
            }
            countDownLatch.await();
            for (FutureTask futureTask : result) {
                if (futureTask == null || !futureTask.isDone() || ((Boolean)futureTask.get()).booleanValue()) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("Exception occurs while recover consume queue concurrently", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
        return true;
    }

    @Override
    public boolean shutdown() {
        try {
            this.flush();
            this.flushConsumeQueueService.shutdown();
        }
        catch (StoreException e) {
            log.error("Failed to flush all consume queues", (Throwable)e);
            return false;
        }
        return true;
    }

    public void correctMinOffset(ConsumeQueueInterface consumeQueue, long minCommitLogOffset) {
        consumeQueue.correctMinOffset(minCommitLogOffset);
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest dispatchRequest) {
        ConsumeQueueInterface cq = this.findOrCreateConsumeQueue(dispatchRequest.getTopic(), dispatchRequest.getQueueId());
        this.putMessagePositionInfoWrapper(cq, dispatchRequest);
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) {
        ConsumeQueueInterface logic = this.findOrCreateConsumeQueue(topic, queueId);
        if (logic != null) {
            long resultOffset = logic.getOffsetInQueueByTime(timestamp, boundaryType);
            resultOffset = Math.max(resultOffset, logic.getMinOffsetInQueue());
            resultOffset = Math.min(resultOffset, logic.getMaxOffsetInQueue());
            return resultOffset;
        }
        return 0L;
    }

    private FileQueueLifeCycle getLifeCycle(String topic, int queueId) {
        return this.findOrCreateConsumeQueue(topic, queueId);
    }

    public boolean load(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.load();
    }

    private boolean loadConsumeQueues(String storePath, CQType cqType) {
        File dirLogic = new File(storePath);
        File[] fileTopicList = dirLogic.listFiles();
        if (fileTopicList != null) {
            for (File fileTopic : fileTopicList) {
                String topic = fileTopic.getName();
                File[] fileQueueIdList = fileTopic.listFiles();
                if (fileQueueIdList == null) continue;
                for (File fileQueueId : fileQueueIdList) {
                    int queueId;
                    try {
                        queueId = Integer.parseInt(fileQueueId.getName());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    this.queueTypeShouldBe(topic, cqType);
                    ConsumeQueueInterface logic = this.createConsumeQueueByType(cqType, topic, queueId, storePath);
                    this.putConsumeQueue(topic, queueId, logic);
                    if (this.load(logic)) continue;
                    return false;
                }
            }
        }
        log.info("load {} all over, OK", (Object)cqType);
        return true;
    }

    private ConsumeQueueInterface createConsumeQueueByType(CQType cqType, String topic, int queueId, String storePath) {
        if (Objects.equals(CQType.SimpleCQ, cqType)) {
            return new ConsumeQueue(topic, queueId, storePath, this.messageStoreConfig.getMappedFileSizeConsumeQueue(), this.messageStore, this);
        }
        if (Objects.equals(CQType.BatchCQ, cqType)) {
            return new BatchConsumeQueue(topic, queueId, storePath, this.messageStoreConfig.getMapperFileSizeBatchConsumeQueue(), this.messageStore);
        }
        throw new RuntimeException(String.format("queue type %s is not supported.", cqType.toString()));
    }

    private void queueTypeShouldBe(String topic, CQType cqTypeExpected) {
        Optional<TopicConfig> topicConfig = this.messageStore.getTopicConfig(topic);
        CQType cqTypeActual = QueueTypeUtils.getCQType(topicConfig);
        if (!Objects.equals(cqTypeExpected, cqTypeActual)) {
            throw new RuntimeException(String.format("The queue type of topic: %s should be %s, but is %s", topic, cqTypeExpected, cqTypeActual));
        }
    }

    private ExecutorService buildExecutorService(BlockingQueue<Runnable> blockingQueue, String threadNamePrefix) {
        return ThreadUtils.newThreadPoolExecutor((int)this.messageStore.getBrokerConfig().getRecoverThreadPoolNums(), (int)this.messageStore.getBrokerConfig().getRecoverThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, blockingQueue, (ThreadFactory)new ThreadFactoryImpl(threadNamePrefix));
    }

    public void recover(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.recover();
    }

    @Override
    public long getMaxPhyOffsetInConsumeQueue() {
        long maxPhysicOffset = -1L;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                if (logic.getMaxPhysicOffset() <= maxPhysicOffset) continue;
                maxPhysicOffset = logic.getMaxPhysicOffset();
            }
        }
        return maxPhysicOffset;
    }

    @Override
    public long getMinOffsetInQueue(String topic, int queueId) {
        ConsumeQueueInterface logic = this.findOrCreateConsumeQueue(topic, queueId);
        if (logic != null) {
            return logic.getMinOffsetInQueue();
        }
        return -1L;
    }

    public void checkSelf(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.checkSelf();
    }

    @Override
    public void checkSelf() {
        for (Map.Entry topicEntry : this.consumeQueueTable.entrySet()) {
            for (Map.Entry cqEntry : ((ConcurrentMap)topicEntry.getValue()).entrySet()) {
                this.checkSelf((ConsumeQueueInterface)cqEntry.getValue());
            }
        }
    }

    public boolean flush(ConsumeQueueInterface consumeQueue, int flushLeastPages) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.flush(flushLeastPages);
    }

    @Override
    public void flush() throws StoreException {
        for (Map.Entry topicEntry : this.consumeQueueTable.entrySet()) {
            for (Map.Entry cqEntry : ((ConcurrentMap)topicEntry.getValue()).entrySet()) {
                this.flush((ConsumeQueueInterface)cqEntry.getValue(), 0);
            }
        }
    }

    @Override
    public void destroy(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.destroy();
    }

    public int deleteExpiredFile(ConsumeQueueInterface consumeQueue, long minCommitLogPos) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.deleteExpiredFile(minCommitLogPos);
    }

    public void truncateDirtyLogicFiles(ConsumeQueueInterface consumeQueue, long phyOffset) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.truncateDirtyLogicFiles(phyOffset);
    }

    public void swapMap(ConsumeQueueInterface consumeQueue, int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.swapMap(reserveNum, forceSwapIntervalMs, normalSwapIntervalMs);
    }

    public void cleanSwappedMap(ConsumeQueueInterface consumeQueue, long forceCleanSwapIntervalMs) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        fileQueueLifeCycle.cleanSwappedMap(forceCleanSwapIntervalMs);
    }

    public boolean isFirstFileAvailable(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.isFirstFileAvailable();
    }

    public boolean isFirstFileExist(ConsumeQueueInterface consumeQueue) {
        FileQueueLifeCycle fileQueueLifeCycle = this.getLifeCycle(consumeQueue.getTopic(), consumeQueue.getQueueId());
        return fileQueueLifeCycle.isFirstFileExist();
    }

    @Override
    public ConsumeQueueInterface findOrCreateConsumeQueue(String topic, int queueId) {
        ConsumeQueueInterface logic;
        ConcurrentMap<Integer, BatchConsumeQueue> map = (ConcurrentHashMap<Integer, BatchConsumeQueue>)this.consumeQueueTable.get(topic);
        if (null == map) {
            ConcurrentHashMap<Integer, BatchConsumeQueue> newMap = new ConcurrentHashMap<Integer, BatchConsumeQueue>(128);
            ConcurrentMap oldMap = this.consumeQueueTable.putIfAbsent(topic, newMap);
            map = oldMap != null ? oldMap : newMap;
        }
        if ((logic = (ConsumeQueueInterface)map.get(queueId)) != null) {
            return logic;
        }
        Optional<TopicConfig> topicConfig = this.messageStore.getTopicConfig(topic);
        ConsumeQueueInterface newLogic = Objects.equals(CQType.BatchCQ, QueueTypeUtils.getCQType(topicConfig)) ? new BatchConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathBatchConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), this.messageStoreConfig.getMapperFileSizeBatchConsumeQueue(), this.messageStore) : new ConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir()), this.messageStoreConfig.getMappedFileSizeConsumeQueue(), this.messageStore, this);
        ConsumeQueueInterface oldLogic = map.putIfAbsent(queueId, (BatchConsumeQueue)newLogic);
        logic = oldLogic != null ? oldLogic : newLogic;
        return logic;
    }

    @Override
    public ConsumeQueueInterface getConsumeQueue(String topic, int queueId) {
        ConcurrentMap map = (ConcurrentMap)this.getConsumeQueueTable().get(topic);
        if (map == null) {
            return null;
        }
        return (ConsumeQueueInterface)map.get(queueId);
    }

    public void setBatchTopicQueueTable(ConcurrentMap<String, Long> batchTopicQueueTable) {
        this.queueOffsetOperator.setBatchTopicQueueTable(batchTopicQueueTable);
    }

    public void updateQueueOffset(String topic, int queueId, long offset) {
        String topicQueueKey = topic + "-" + queueId;
        this.queueOffsetOperator.updateQueueOffset(topicQueueKey, offset);
    }

    private void putConsumeQueue(String topic, int queueId, ConsumeQueueInterface consumeQueue) {
        ConcurrentHashMap<Integer, ConsumeQueueInterface> map = (ConcurrentHashMap<Integer, ConsumeQueueInterface>)this.consumeQueueTable.get(topic);
        if (null == map) {
            map = new ConcurrentHashMap<Integer, ConsumeQueueInterface>();
            map.put(queueId, consumeQueue);
            this.consumeQueueTable.put(topic, map);
        } else {
            map.put(queueId, consumeQueue);
        }
    }

    @Override
    public void recoverOffsetTable(long minPhyOffset) {
        ConcurrentHashMap<String, Long> cqOffsetTable = new ConcurrentHashMap<String, Long>(1024);
        ConcurrentHashMap<String, Long> bcqOffsetTable = new ConcurrentHashMap<String, Long>(1024);
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                String key = logic.getTopic() + "-" + logic.getQueueId();
                long maxOffsetInQueue = logic.getMaxOffsetInQueue();
                if (Objects.equals(CQType.BatchCQ, logic.getCQType())) {
                    bcqOffsetTable.put(key, maxOffsetInQueue);
                } else {
                    cqOffsetTable.put(key, maxOffsetInQueue);
                }
                this.correctMinOffset(logic, minPhyOffset);
            }
        }
        if (this.messageStoreConfig.isDuplicationEnable() || this.messageStore.getBrokerConfig().isEnableControllerMode()) {
            this.compensateForHA(cqOffsetTable);
        }
        this.setTopicQueueTable(cqOffsetTable);
        this.setBatchTopicQueueTable(bcqOffsetTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compensateForHA(ConcurrentMap<String, Long> cqOffsetTable) {
        SelectMappedBufferResult lastBuffer = null;
        long startReadOffset = this.messageStore.getCommitLog().getConfirmOffset() == -1L ? 0L : this.messageStore.getCommitLog().getConfirmOffset();
        log.info("Correct unsubmitted offset...StartReadOffset = {}", (Object)startReadOffset);
        while ((lastBuffer = this.messageStore.selectOneMessageByOffset(startReadOffset)) != null) {
            try {
                if (lastBuffer.getStartOffset() > startReadOffset) {
                    startReadOffset = lastBuffer.getStartOffset();
                    continue;
                }
                ByteBuffer bb = lastBuffer.getByteBuffer();
                int magicCode = bb.getInt(bb.position() + 4);
                if (magicCode == -875286124) {
                    startReadOffset += (long)bb.getInt(bb.position());
                    continue;
                }
                if (magicCode != -626843481) {
                    throw new RuntimeException("Unknown magicCode: " + magicCode);
                }
                lastBuffer.getByteBuffer().mark();
                DispatchRequest dispatchRequest = this.messageStore.getCommitLog().checkMessageAndReturnSize(lastBuffer.getByteBuffer(), true, this.messageStoreConfig.isDuplicationEnable(), true);
                if (!dispatchRequest.isSuccess()) break;
                lastBuffer.getByteBuffer().reset();
                MessageExt msg = MessageDecoder.decode((ByteBuffer)lastBuffer.getByteBuffer(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                if (msg == null) break;
                String key = msg.getTopic() + "-" + msg.getQueueId();
                cqOffsetTable.put(key, msg.getQueueOffset() + 1L);
                log.info("Correcting. Key:{}, start read Offset: {}", (Object)key, (Object)(startReadOffset += (long)msg.getStoreSize()));
            }
            finally {
                if (lastBuffer == null) continue;
                lastBuffer.release();
            }
        }
    }

    @Override
    public void destroy(boolean loadAfterDestroy) {
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                this.destroy(logic);
            }
        }
    }

    @Override
    public void cleanExpired(long minCommitLogOffset) {
        Iterator it = this.consumeQueueTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            String topic = (String)next.getKey();
            if (TopicValidator.isSystemTopic((String)topic)) continue;
            ConcurrentMap queueTable = (ConcurrentMap)next.getValue();
            Iterator itQT = queueTable.entrySet().iterator();
            while (itQT.hasNext()) {
                Map.Entry nextQT = itQT.next();
                long maxCLOffsetInConsumeQueue = ((ConsumeQueueInterface)nextQT.getValue()).getLastOffset();
                if (maxCLOffsetInConsumeQueue == -1L) {
                    log.warn("maybe ConsumeQueue was created just now. topic={} queueId={} maxPhysicOffset={} minLogicOffset={}.", new Object[]{((ConsumeQueueInterface)nextQT.getValue()).getTopic(), ((ConsumeQueueInterface)nextQT.getValue()).getQueueId(), ((ConsumeQueueInterface)nextQT.getValue()).getMaxPhysicOffset(), ((ConsumeQueueInterface)nextQT.getValue()).getMinLogicOffset()});
                    continue;
                }
                if (maxCLOffsetInConsumeQueue >= minCommitLogOffset) continue;
                log.info("cleanExpiredConsumerQueue: {} {} consumer queue destroyed, minCommitLogOffset: {} maxCLOffsetInConsumeQueue: {}", new Object[]{topic, nextQT.getKey(), minCommitLogOffset, maxCLOffsetInConsumeQueue});
                this.removeTopicQueueTable(((ConsumeQueueInterface)nextQT.getValue()).getTopic(), ((ConsumeQueueInterface)nextQT.getValue()).getQueueId());
                this.destroy((ConsumeQueueInterface)nextQT.getValue());
                itQT.remove();
            }
            if (!queueTable.isEmpty()) continue;
            log.info("cleanExpiredConsumerQueue: {},topic destroyed", (Object)topic);
            it.remove();
        }
    }

    @Override
    public void truncateDirty(long offsetToTruncate) {
        long maxPhyOffsetOfConsumeQueue = this.getMaxPhyOffsetInConsumeQueue();
        if (maxPhyOffsetOfConsumeQueue >= offsetToTruncate) {
            log.warn("maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)offsetToTruncate);
            for (ConcurrentMap maps : this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface logic : maps.values()) {
                    this.truncateDirtyLogicFiles(logic, offsetToTruncate);
                }
            }
        }
    }

    @Override
    public long getTotalSize() {
        long totalSize = 0L;
        for (ConcurrentMap maps : this.consumeQueueTable.values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                totalSize += logic.getTotalSize();
            }
        }
        return totalSize;
    }

    @Override
    public boolean isMappedFileMatchedRecover(long phyOffset, long storeTimestamp, boolean recoverNormally) {
        if (recoverNormally) {
            return phyOffset <= this.dispatchFromPhyOffset;
        }
        return storeTimestamp <= this.dispatchFromStoreTimestamp;
    }

    public class CleanConsumeQueueService {
        protected long lastPhysicalMinOffset = 0L;

        public void run() {
            try {
                this.deleteExpiredFiles();
            }
            catch (Throwable e) {
                AbstractConsumeQueueStore.log.warn(this.getServiceName() + " service has exception. ", e);
            }
        }

        protected void deleteExpiredFiles() {
            int deleteLogicsFilesInterval = ConsumeQueueStore.this.messageStoreConfig.getDeleteConsumeQueueFilesInterval();
            long minOffset = ConsumeQueueStore.this.messageStore.getCommitLog().getMinOffset();
            if (minOffset > this.lastPhysicalMinOffset) {
                this.lastPhysicalMinOffset = minOffset;
                for (ConcurrentMap maps : ConsumeQueueStore.this.consumeQueueTable.values()) {
                    for (ConsumeQueueInterface logic : maps.values()) {
                        int deleteCount = ConsumeQueueStore.this.deleteExpiredFile(logic, minOffset);
                        if (deleteCount <= 0 || deleteLogicsFilesInterval <= 0) continue;
                        try {
                            Thread.sleep(deleteLogicsFilesInterval);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                ConsumeQueueStore.this.messageStore.getIndexService().deleteExpiredFile(minOffset);
            }
        }

        public String getServiceName() {
            return ConsumeQueueStore.this.messageStore.getBrokerConfig().getIdentifier() + CleanConsumeQueueService.class.getSimpleName();
        }
    }

    class CorrectLogicOffsetService {
        private long lastForceCorrectTime = -1L;

        CorrectLogicOffsetService() {
        }

        public void run() {
            try {
                this.correctLogicMinOffset();
            }
            catch (Throwable e) {
                AbstractConsumeQueueStore.log.warn(this.getServiceName() + " service has exception. ", e);
            }
        }

        private boolean needCorrect(ConsumeQueueInterface logic, long minPhyOffset, long lastForeCorrectTimeCurRun) {
            if (logic == null) {
                return false;
            }
            if (ConsumeQueueStore.this.isFirstFileExist(logic) && !ConsumeQueueStore.this.isFirstFileAvailable(logic)) {
                AbstractConsumeQueueStore.log.error("CorrectLogicOffsetService.needCorrect. first file not available, trigger correct. topic:{}, queue:{}, maxPhyOffset in queue:{}, minPhyOffset in commit log:{}, minOffset in queue:{}, maxOffset in queue:{}, cqType:{}", new Object[]{logic.getTopic(), logic.getQueueId(), logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getCQType()});
                return true;
            }
            if (logic.getMaxPhysicOffset() == -1L || minPhyOffset == -1L) {
                return false;
            }
            if (logic.getMaxPhysicOffset() < minPhyOffset) {
                if (logic.getMinOffsetInQueue() < logic.getMaxOffsetInQueue()) {
                    AbstractConsumeQueueStore.log.error("CorrectLogicOffsetService.needCorrect. logic max phy offset: {} is less than min phy offset: {}, but min offset: {} is less than max offset: {}. topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (logic.getMinOffsetInQueue() == logic.getMaxOffsetInQueue()) {
                    return false;
                }
                AbstractConsumeQueueStore.log.error("CorrectLogicOffsetService.needCorrect. It should not happen, logic max phy offset: {} is less than min phy offset: {}, but min offset: {} is larger than max offset: {}. topic:{}, queue:{}, cqType:{}", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                return false;
            }
            int forceCorrectInterval = ConsumeQueueStore.this.messageStoreConfig.getCorrectLogicMinOffsetForceInterval();
            if (System.currentTimeMillis() - lastForeCorrectTimeCurRun > (long)forceCorrectInterval) {
                this.lastForceCorrectTime = System.currentTimeMillis();
                CqUnit cqUnit = logic.getEarliestUnit();
                if (cqUnit == null) {
                    if (logic.getMinOffsetInQueue() == logic.getMaxOffsetInQueue()) {
                        return false;
                    }
                    AbstractConsumeQueueStore.log.error("CorrectLogicOffsetService.needCorrect. cqUnit is null, logic max phy offset: {} is greater than min phy offset: {}, but min offset: {} is not equal to max offset: {}. topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (cqUnit.getPos() < minPhyOffset) {
                    AbstractConsumeQueueStore.log.error("CorrectLogicOffsetService.needCorrect. logic max phy offset: {} is greater than min phy offset: {}, but minPhyPos in cq is: {}. min offset in queue: {}, max offset in queue: {}, topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, cqUnit.getPos(), logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (cqUnit.getPos() >= minPhyOffset) {
                    return false;
                }
            }
            return false;
        }

        private void correctLogicMinOffset() {
            long lastForeCorrectTimeCurRun = this.lastForceCorrectTime;
            long minPhyOffset = ConsumeQueueStore.this.messageStore.getMinPhyOffset();
            for (ConcurrentMap maps : ConsumeQueueStore.this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface logic : maps.values()) {
                    if (Objects.equals(CQType.SimpleCQ, logic.getCQType()) || !this.needCorrect(logic, minPhyOffset, lastForeCorrectTimeCurRun)) continue;
                    this.doCorrect(logic, minPhyOffset);
                }
            }
        }

        private void doCorrect(ConsumeQueueInterface logic, long minPhyOffset) {
            ConsumeQueueStore.this.deleteExpiredFile(logic, minPhyOffset);
            int sleepIntervalWhenCorrectMinOffset = ConsumeQueueStore.this.messageStoreConfig.getCorrectLogicMinOffsetSleepInterval();
            if (sleepIntervalWhenCorrectMinOffset > 0) {
                try {
                    Thread.sleep(sleepIntervalWhenCorrectMinOffset);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public String getServiceName() {
            if (ConsumeQueueStore.this.messageStore.getBrokerConfig().isInBrokerContainer()) {
                return ConsumeQueueStore.this.messageStore.getBrokerConfig().getIdentifier() + CorrectLogicOffsetService.class.getSimpleName();
            }
            return CorrectLogicOffsetService.class.getSimpleName();
        }
    }

    public class FlushConsumeQueueService
    extends ServiceThread {
        private static final int RETRY_TIMES_OVER = 3;
        private long lastFlushTimestamp = 0L;

        private void doFlush(int retryTimes) {
            int flushConsumeQueueLeastPages = ConsumeQueueStore.this.messageStoreConfig.getFlushConsumeQueueLeastPages();
            if (retryTimes == 3) {
                flushConsumeQueueLeastPages = 0;
            }
            long logicsMsgTimestamp = 0L;
            int flushConsumeQueueThoroughInterval = ConsumeQueueStore.this.messageStoreConfig.getFlushConsumeQueueThoroughInterval();
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis >= this.lastFlushTimestamp + (long)flushConsumeQueueThoroughInterval) {
                this.lastFlushTimestamp = currentTimeMillis;
                flushConsumeQueueLeastPages = 0;
                logicsMsgTimestamp = ConsumeQueueStore.this.messageStore.getStoreCheckpoint().getLogicsMsgTimestamp();
            }
            for (ConcurrentMap maps : ConsumeQueueStore.this.consumeQueueTable.values()) {
                for (ConsumeQueueInterface cq : maps.values()) {
                    boolean result = false;
                    for (int i = 0; i < retryTimes && !result; ++i) {
                        result = ConsumeQueueStore.this.flush(cq, flushConsumeQueueLeastPages);
                    }
                }
            }
            if (ConsumeQueueStore.this.messageStoreConfig.isEnableCompaction()) {
                ConsumeQueueStore.this.messageStore.getCompactionStore().flush(flushConsumeQueueLeastPages);
            }
            if (0 == flushConsumeQueueLeastPages) {
                if (logicsMsgTimestamp > 0L) {
                    ConsumeQueueStore.this.messageStore.getStoreCheckpoint().setLogicsMsgTimestamp(logicsMsgTimestamp);
                }
                ConsumeQueueStore.this.messageStore.getStoreCheckpoint().flush();
            }
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    int interval = ConsumeQueueStore.this.messageStoreConfig.getFlushIntervalConsumeQueue();
                    this.waitForRunning(interval);
                    this.doFlush(1);
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            this.doFlush(3);
            log.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (ConsumeQueueStore.this.messageStore.getBrokerConfig().isInBrokerContainer()) {
                return ConsumeQueueStore.this.messageStore.getBrokerIdentity().getIdentifier() + FlushConsumeQueueService.class.getSimpleName();
            }
            return FlushConsumeQueueService.class.getSimpleName();
        }

        public long getJoinTime() {
            return 60000L;
        }
    }
}

