/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v8;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.v8.Bits;
import ch.ethz.globis.phtree.v8.Node;
import ch.ethz.globis.phtree.v8.PhTree8;
import org.zoodb.index.critbit.CritBit64;

public class NodeIteratorFullNoGC<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private final int DIM;
    private boolean isPostHC;
    private boolean isPostNI;
    private boolean isSubHC;
    private int postLen;
    private long next = -1L;
    private long nextPost = -1L;
    private long nextSub = -1L;
    private Node<T> nextSubNode;
    private Node<T> node;
    private int currentOffsetPostKey;
    private int currentOffsetPostVal;
    private int currentOffsetSub;
    private CritBit64.CBIterator<PhTree8.NodeEntry<T>> niIterator;
    private int nMaxPost;
    private int nMaxSub;
    private int nPostsFound = 0;
    private int posSubLHC = -1;
    private int postEntryLen;
    private final long[] valTemplate;
    private PhFilter checker;
    private final PhEntry<T> nextPost1;
    private final PhEntry<T> nextPost2;
    private boolean isNextPost1free;
    private final long MAX_POS;

    public NodeIteratorFullNoGC(int DIM, long[] valTemplate) {
        this.DIM = DIM;
        this.MAX_POS = (1L << DIM) - 1L;
        this.valTemplate = valTemplate;
        this.nextPost1 = new PhEntry<Object>(new long[DIM], null);
        this.nextPost2 = new PhEntry<Object>(new long[DIM], null);
    }

    private void reinit(Node<T> node, PhFilter checker) {
        this.next = -1L;
        this.nextSubNode = null;
        this.currentOffsetPostKey = 0;
        this.currentOffsetPostVal = 0;
        this.currentOffsetSub = 0;
        this.nPostsFound = 0;
        this.posSubLHC = -1;
        this.checker = checker;
        this.node = node;
        this.isPostHC = node.isPostHC();
        this.isPostNI = node.isPostNI();
        this.isSubHC = node.isSubHC();
        this.postLen = node.getPostLen();
        this.nMaxPost = node.getPostCount();
        this.nMaxSub = node.getSubCount();
        this.nextPost = this.nMaxPost > 0 ? -1L : Long.MAX_VALUE;
        this.nextSub = this.nMaxSub > 0 ? -1L : Long.MAX_VALUE;
        this.currentOffsetSub = node.getBitPos_SubNodeIndex(this.DIM);
        if (this.isPostNI) {
            this.postEntryLen = -1;
            if (this.niIterator == null) {
                this.niIterator = new CritBit64.CBIterator();
            }
            this.niIterator.reset(node.ind());
        } else {
            this.currentOffsetPostKey = node.getBitPos_PostIndex(this.DIM);
            if (this.isPostHC) {
                this.postEntryLen = this.DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + (1 << this.DIM) * 1;
            } else {
                this.postEntryLen = Node.PIK_WIDTH(this.DIM) + this.DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + Node.PIK_WIDTH(this.DIM);
            }
        }
    }

    boolean increment() {
        this.next = this.getNext(this.isNextPost1free ? this.nextPost1 : this.nextPost2);
        return this.next != Long.MAX_VALUE;
    }

    long getCurrentPos() {
        return this.isPostNI ? this.next : this.nextSub;
    }

    PhEntry<T> getCurrentPost() {
        return this.isNextPost1free ? this.nextPost2 : this.nextPost1;
    }

    boolean isNextSub() {
        return this.isPostNI ? this.nextSubNode != null : this.next == this.nextSub;
    }

    private boolean readValue(long pos, int offsPostKey, PhEntry<T> result) {
        long[] key = result.getKey();
        System.arraycopy(this.valTemplate, 0, key, 0, this.DIM);
        PhTreeHelper.applyHcPos(pos, this.postLen, key);
        result.setValue(this.node.getPostPOB(offsPostKey, pos, key));
        if (this.checker != null && !this.checker.isValid(key)) {
            return false;
        }
        this.isNextPost1free = !this.isNextPost1free;
        return true;
    }

    private boolean readValue(long pos, PhTree8.NodeEntry<T> e, PhEntry<T> result) {
        long mask = this.postLen < 63 ? -1L << this.postLen + 1 : 0L;
        long[] eKey = e.getKey();
        PhTreeHelper.applyHcPos(pos, this.postLen, eKey);
        for (int i = 0; i < eKey.length; ++i) {
            int n = i;
            eKey[n] = eKey[n] | this.valTemplate[i] & mask;
        }
        if (this.checker != null && !this.checker.isValid(eKey)) {
            return false;
        }
        System.arraycopy(eKey, 0, result.getKey(), 0, this.DIM);
        result.setValue(e.getValue());
        this.nextSubNode = null;
        this.isNextPost1free = !this.isNextPost1free;
        return true;
    }

    private boolean readSub(long pos, Node<T> sub) {
        PhTreeHelper.applyHcPos(pos, this.postLen, this.valTemplate);
        sub.getInfix(this.valTemplate);
        return this.checker == null || this.checker.isValid(sub.getPostLen() + 1, this.valTemplate);
    }

    private long getNext(PhEntry<T> result) {
        if (this.node.isPostNI()) {
            this.niFindNext(result);
            return this.next;
        }
        if (this.nextPost != Long.MAX_VALUE && this.nextPost == this.next) {
            if (this.isPostHC) {
                this.getNextPostAHC(result);
            } else {
                this.getNextPostLHC(result);
            }
        }
        if (this.nextSub != Long.MAX_VALUE && this.nextSub == this.next) {
            if (this.isSubHC) {
                this.getNextSubAHC();
            } else {
                this.getNextSubLHC();
            }
        }
        return this.nextSub < this.nextPost ? this.nextSub : this.nextPost;
    }

    private void getNextPostAHC(PhEntry<T> result) {
        block2: {
            int offs;
            boolean bit;
            long currentPos = this.nextPost;
            do {
                if (++currentPos > this.MAX_POS) {
                    this.nextPost = Long.MAX_VALUE;
                    break block2;
                }
                bit = Bits.getBit(this.node.ba, this.currentOffsetPostKey);
                ++this.currentOffsetPostKey;
            } while (!bit || !this.readValue(currentPos, offs = (int)((long)this.currentOffsetPostVal + currentPos * (long)this.postEntryLen), result));
            this.nextPost = currentPos;
        }
    }

    private void getNextPostLHC(PhEntry<T> result) {
        block2: {
            int offs;
            long currentPos;
            do {
                if (++this.nPostsFound > this.nMaxPost) {
                    this.nextPost = Long.MAX_VALUE;
                    break block2;
                }
                offs = this.currentOffsetPostKey;
                currentPos = Bits.readArray(this.node.ba, offs, Node.PIK_WIDTH(this.DIM));
                this.currentOffsetPostKey += this.postEntryLen;
            } while (!this.readValue(currentPos, offs + Node.PIK_WIDTH(this.DIM), result));
            this.nextPost = currentPos;
        }
    }

    private void getNextSubAHC() {
        block1: {
            Node<T> sub;
            int currentPos = (int)this.nextSub;
            do {
                if ((long)(++currentPos) <= this.MAX_POS) continue;
                this.nextSub = Long.MAX_VALUE;
                break block1;
            } while ((sub = this.node.subNRef(currentPos)) == null || !this.readSub(currentPos, sub));
            this.nextSub = currentPos;
            this.nextSubNode = sub;
        }
    }

    private void getNextSubLHC() {
        block2: {
            Node<T> sub;
            long currentPos;
            do {
                if (this.posSubLHC + 1 >= this.nMaxSub) {
                    this.nextSub = Long.MAX_VALUE;
                    break block2;
                }
                currentPos = Bits.readArray(this.node.ba, this.currentOffsetSub, Node.SIK_WIDTH(this.DIM));
                this.currentOffsetSub += Node.SIK_WIDTH(this.DIM);
                ++this.posSubLHC;
            } while (!this.readSub(currentPos, sub = this.node.subNRef(this.posSubLHC)));
            this.nextSub = currentPos;
            this.nextSubNode = sub;
        }
    }

    private void niFindNext(PhEntry<T> result) {
        while (this.niIterator.hasNext()) {
            CritBit64.Entry<PhTree8.NodeEntry<T>> e = this.niIterator.nextEntry();
            this.next = e.key();
            this.nextSubNode = e.value().node;
            if (this.nextSubNode == null ? !this.readValue(e.key(), e.value(), result) : !this.readSub(e.key(), this.nextSubNode)) continue;
            return;
        }
        this.next = Long.MAX_VALUE;
    }

    public Node<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public Node<T> node() {
        return this.node;
    }

    void init(Node<T> node, PhFilter checker) {
        this.reinit(node, checker);
    }
}

