/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.streams;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class InAxDoubleArray
implements Collector<double[], double[], double[]> {
    @Override
    public BiConsumer<double[], double[]> accumulator() {
        return (minMax, v) -> {
            for (double d : v) {
                minMax[0] = Math.min(d, minMax[0]);
                minMax[1] = Math.max(d, minMax[1]);
            }
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }

    @Override
    public BinaryOperator<double[]> combiner() {
        return (a, b) -> new double[]{Math.min(a[0], b[0]), Math.max(a[1], b[1])};
    }

    @Override
    public Function<double[], double[]> finisher() {
        return a -> a;
    }

    @Override
    public Supplier<double[]> supplier() {
        return () -> new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
    }
}

