/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.meter.AbstractPeriodMeter;
import org.apache.servicecomb.foundation.metrics.meter.LatencyDistributionMeter;
import org.apache.servicecomb.foundation.metrics.meter.SimpleTimer;

public abstract class AbstractInvocationMeter
extends AbstractPeriodMeter {
    private final SimpleTimer totalTimer;
    private final SimpleTimer prepareTimer;
    private final SimpleTimer handlersRequestTimer;
    private final SimpleTimer handlersResponseTimer;
    private final LatencyDistributionMeter latencyDistributionMeter;

    public AbstractInvocationMeter(Id id) {
        this.id = id;
        this.latencyDistributionMeter = this.createLatencyDistribution("latencyDistribution");
        this.totalTimer = this.createStageTimer("total");
        this.prepareTimer = this.createStageTimer("prepare");
        this.handlersRequestTimer = this.createStageTimer("handlers_request");
        this.handlersResponseTimer = this.createStageTimer("handlers_response");
    }

    protected LatencyDistributionMeter createLatencyDistribution(String tagValue) {
        String config = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.metrics.invocation.latencyDistribution", null).get();
        return new LatencyDistributionMeter(this.id.withTag("type", tagValue), config);
    }

    protected SimpleTimer createStageTimer(String stageValue) {
        return this.createTimer(this.id.withTag("type", "stage").withTag("stage", stageValue));
    }

    protected SimpleTimer createTimer(String tagKey, String tagValue) {
        return this.createTimer(this.id.withTag(tagKey, tagValue));
    }

    protected SimpleTimer createTimer(Id timerId) {
        return new SimpleTimer(timerId);
    }

    public void onInvocationFinish(InvocationFinishEvent event) {
        InvocationStageTrace stageTrace = event.getInvocation().getInvocationStageTrace();
        this.latencyDistributionMeter.record((long)stageTrace.calcTotalTime());
        this.totalTimer.record((long)stageTrace.calcTotalTime());
        this.handlersRequestTimer.record((long)stageTrace.calcHandlersRequestTime());
        this.handlersResponseTimer.record((long)stageTrace.calcHandlersResponseTime());
        this.prepareTimer.record((long)stageTrace.calcInvocationPrepareTime());
    }

    public void calcMeasurements(long msNow, long secondInterval) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>(3);
        this.calcMeasurements(measurements, msNow, secondInterval);
        this.allMeasurements = measurements;
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        this.latencyDistributionMeter.calcMeasurements(measurements, msNow, secondInterval);
        this.totalTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.handlersRequestTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.handlersResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.prepareTimer.calcMeasurements(measurements, msNow, secondInterval);
    }

    public boolean hasExpired() {
        return super.hasExpired();
    }
}

