/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.image.DataType;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.HyperRectangleWriter;
import org.apache.sis.io.stream.UpdatableWrite;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.geotiff.base.Compression;
import org.apache.sis.storage.geotiff.base.Predictor;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.writer.HorizontalPredictor;
import org.apache.sis.storage.geotiff.writer.PixelChannel;
import org.apache.sis.storage.geotiff.writer.TagValue;
import org.apache.sis.storage.geotiff.writer.ZIP;

public final class TileMatrix {
    public UpdatableWrite<?> nextIFD;
    private final RenderedImage image;
    private final DataType type;
    private final int numPlanes;
    private final int numXTiles;
    private final int numYTiles;
    private final int numTiles;
    public final int tileWidth;
    public final int tileHeight;
    private final int tileSize;
    public final int[] lengths;
    public final long[] offsets;
    public TagValue offsetsTag;
    public TagValue lengthsTag;
    private final Compression compression;
    private final int compressionLevel;
    private final Predictor predictor;

    public TileMatrix(RenderedImage image, int numPlanes, int[] bitsPerSample, Compression compression, int compressionLevel, Predictor predictor) {
        this.numPlanes = numPlanes;
        this.image = image;
        this.compression = compression;
        this.compressionLevel = compressionLevel;
        this.predictor = predictor;
        this.type = DataType.forBands((RenderedImage)image);
        this.tileWidth = image.getTileWidth();
        this.tileHeight = image.getTileHeight();
        int pixelSize = bitsPerSample != null ? JDK18.ceilDiv((int)Arrays.stream(bitsPerSample).sum(), (int)8) : 1;
        this.tileSize = this.tileWidth * this.tileHeight * pixelSize;
        this.numXTiles = image.getNumXTiles();
        this.numYTiles = image.getNumYTiles();
        this.numTiles = Math.multiplyExact(this.numXTiles, this.numYTiles);
        int numArrays = Math.multiplyExact(numPlanes, this.numTiles);
        this.offsets = new long[numArrays];
        this.lengths = new int[numArrays];
        Arrays.fill(this.lengths, this.tileSize);
    }

    public boolean useStrips() {
        return this.numXTiles == 1;
    }

    public void writeOffsetsAndLengths(ChannelDataOutput output) throws IOException {
        this.offsetsTag.rewrite(output);
        for (int value : this.lengths) {
            if (value == this.tileSize) continue;
            this.lengthsTag.rewrite(output);
            break;
        }
    }

    private static DataStoreException unsupported(short key, Enum<?> value) {
        return new DataStoreException(Resources.forLocale(null).getString(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRasters(ChannelDataOutput output) throws DataStoreException, IOException {
        ChannelDataOutput compOutput = null;
        Channel compressor = null;
        SampleModel sampleModel = null;
        boolean direct = false;
        ByteOrder dataByteOrder = null;
        ByteOrder fileByteOrder = output.buffer.order();
        int minTileX = this.image.getMinTileX();
        int minTileY = this.image.getMinTileY();
        for (int tileIndex = 0; tileIndex < this.numTiles; ++tileIndex) {
            int tileX = tileIndex % this.numXTiles;
            int tileY = tileIndex / this.numXTiles;
            Raster tile = this.image.getTile(tileX += minTileX, tileY += minTileY);
            HyperRectangleWriter.Builder builder = new HyperRectangleWriter.Builder();
            HyperRectangleWriter rect = builder.create(tile, this.tileWidth, this.tileHeight);
            if (builder.numBanks() != this.numPlanes) {
                throw new InternalDataStoreException(tile.getSampleModel().toString());
            }
            if (!Objects.equals(sampleModel, sampleModel = tile.getSampleModel())) {
                boolean bl = direct = this.type.equals((Object)DataType.BYTE) && rect.suggestDirect(output);
                if (compressor != null) {
                    compressor.close();
                    compressor = null;
                }
                direct &= (dataByteOrder = builder.byteOrder(fileByteOrder)) == null;
                if (this.compressionLevel != 0) {
                    long length = Math.multiplyExact(builder.length(), this.type.bytes());
                    switch (this.compression) {
                        case DEFLATE: {
                            compressor = new ZIP(output, length, this.compressionLevel);
                            break;
                        }
                        default: {
                            throw TileMatrix.unsupported((short)27, this.compression);
                        }
                    }
                    switch (this.predictor) {
                        default: {
                            throw TileMatrix.unsupported((short)30, this.predictor);
                        }
                        case NONE: {
                            break;
                        }
                        case HORIZONTAL_DIFFERENCING: {
                            compressor = HorizontalPredictor.create((PixelChannel)compressor, this.type, builder.pixelStride(), builder.scanlineStride());
                            direct = false;
                        }
                    }
                    ByteBuffer buffer = direct ? ByteBuffer.allocate(0) : ((PixelChannel)compressor).createBuffer();
                    compOutput = new ChannelDataOutput(output.filename, (WritableByteChannel)compressor, buffer.order(fileByteOrder));
                } else {
                    compOutput = output;
                    assert (this.predictor == Predictor.NONE) : this.predictor;
                }
            }
            DataBuffer buffer = tile.getDataBuffer();
            int[] bufferOffsets = buffer.getOffsets();
            for (int j = 0; j < this.numPlanes; ++j) {
                int b = builder.bankIndex(j);
                int offset = builder.bankOffset(j, bufferOffsets[b]);
                long position = output.getStreamPosition();
                try {
                    if (dataByteOrder != null) {
                        compOutput.buffer.order(dataByteOrder);
                    }
                    switch (this.type.toDataBufferType()) {
                        default: {
                            throw new AssertionError(this.type);
                        }
                        case 0: {
                            rect.write(compOutput, ((DataBufferByte)buffer).getData(b), offset, direct);
                            break;
                        }
                        case 1: {
                            rect.write(compOutput, ((DataBufferUShort)buffer).getData(b), offset);
                            break;
                        }
                        case 2: {
                            rect.write(compOutput, ((DataBufferShort)buffer).getData(b), offset);
                            break;
                        }
                        case 3: {
                            rect.write(compOutput, ((DataBufferInt)buffer).getData(b), offset);
                            break;
                        }
                        case 4: {
                            rect.write(compOutput, ((DataBufferFloat)buffer).getData(b), offset);
                            break;
                        }
                        case 5: {
                            rect.write(compOutput, ((DataBufferDouble)buffer).getData(b), offset);
                        }
                    }
                    if (compressor != null) {
                        ((PixelChannel)compressor).finish(compOutput);
                    }
                }
                finally {
                    if (dataByteOrder != null) {
                        compOutput.buffer.order(fileByteOrder);
                    }
                }
                int planeIndex = tileIndex + j * this.numTiles;
                this.offsets[planeIndex] = position;
                this.lengths[planeIndex] = Math.toIntExact(Math.subtractExact(output.getStreamPosition(), position));
            }
        }
        if (compressor != null) {
            compressor.close();
        }
    }
}

