/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalLong;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public abstract class UpdatableWrite<V>
implements CheckedContainer<V> {
    public final long position;

    private UpdatableWrite(ChannelDataOutput output) {
        this.position = output.getStreamPosition();
    }

    private UpdatableWrite(long position) {
        this.position = position;
    }

    public static UpdatableWrite<Void> of(ChannelDataOutput output) {
        return new OfVoid(output);
    }

    public static UpdatableWrite<Short> of(ChannelDataOutput output, short value) throws IOException {
        OfShort dw = new OfShort(output, value);
        dw.write(output);
        return dw;
    }

    public static UpdatableWrite<Integer> of(ChannelDataOutput output, int value) throws IOException {
        OfInt dw = new OfInt(output, value);
        dw.write(output);
        return dw;
    }

    public static UpdatableWrite<Long> of(ChannelDataOutput output, long value) throws IOException {
        OfLong dw = new OfLong(output, value);
        dw.write(output);
        return dw;
    }

    public static <V extends Number> UpdatableWrite<V> ofZeroAt(long position, Class<V> type) {
        if (type == Integer.class) {
            return new OfInt(position);
        }
        if (type == Short.class) {
            return new OfShort(position);
        }
        if (type == Long.class) {
            return new OfLong(position);
        }
        throw new IllegalArgumentException(Errors.format((short)59, (Object)"type", type));
    }

    abstract int sizeInBytes();

    abstract boolean changed();

    public abstract V get();

    public abstract void set(V var1);

    public abstract OptionalLong getAsLong();

    public abstract void setAsLong(long var1);

    static long validate(int size, long value) {
        if ((value & ((1L << size) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new ArithmeticException(Errors.format((short)91, (Object)size));
        }
        return value;
    }

    abstract void put(ByteBuffer var1, int var2);

    abstract void write(ChannelDataOutput var1) throws IOException;

    public final boolean tryUpdateBuffer(ChannelDataOutput output) {
        if (this.changed()) {
            long p = Math.subtractExact(this.position, output.bufferOffset);
            if (p < 0L || p > (long)(output.buffer.position() - this.sizeInBytes())) {
                return false;
            }
            this.put(output.buffer, (int)p);
        }
        return true;
    }

    public final void update(ChannelDataOutput output) throws IOException {
        if (this.changed()) {
            output.seek(this.position);
            this.write(output);
        }
    }

    private static final class OfVoid
    extends UpdatableWrite<Void> {
        OfVoid(ChannelDataOutput output) {
            super(output);
        }

        public Class<Void> getElementType() {
            return Void.class;
        }

        @Override
        public int sizeInBytes() {
            return 0;
        }

        @Override
        public boolean changed() {
            return false;
        }

        @Override
        public Void get() {
            return null;
        }

        @Override
        public OptionalLong getAsLong() {
            return OptionalLong.empty();
        }

        @Override
        public void set(Void v) {
        }

        @Override
        public void setAsLong(long v) {
        }

        @Override
        void put(ByteBuffer output, int index) {
        }

        @Override
        void write(ChannelDataOutput output) {
        }
    }

    private static final class OfShort
    extends UpdatableWrite<Short> {
        private short current;
        private short defined;

        OfShort(ChannelDataOutput output, short value) {
            super(output);
            this.current = value;
            this.defined = value;
        }

        OfShort(long position) {
            super(position);
        }

        public Class<Short> getElementType() {
            return Short.class;
        }

        @Override
        public int sizeInBytes() {
            return 2;
        }

        @Override
        public boolean changed() {
            return this.defined != this.current;
        }

        @Override
        public Short get() {
            return this.defined;
        }

        @Override
        public OptionalLong getAsLong() {
            return OptionalLong.of(Short.toUnsignedLong(this.defined));
        }

        @Override
        public void set(Short v) {
            this.defined = v;
        }

        @Override
        public void setAsLong(long v) {
            this.defined = (short)OfShort.validate(16, v);
        }

        @Override
        void put(ByteBuffer output, int index) {
            this.current = this.defined;
            output.putShort(index, this.current);
        }

        @Override
        void write(ChannelDataOutput output) throws IOException {
            this.current = this.defined;
            output.writeShort(this.current);
        }
    }

    private static final class OfInt
    extends UpdatableWrite<Integer> {
        private int current;
        private int defined;

        OfInt(ChannelDataOutput output, int value) {
            super(output);
            this.current = value;
            this.defined = value;
        }

        OfInt(long position) {
            super(position);
        }

        public Class<Integer> getElementType() {
            return Integer.class;
        }

        @Override
        public int sizeInBytes() {
            return 4;
        }

        @Override
        public boolean changed() {
            return this.defined != this.current;
        }

        @Override
        public Integer get() {
            return this.defined;
        }

        @Override
        public OptionalLong getAsLong() {
            return OptionalLong.of(Integer.toUnsignedLong(this.defined));
        }

        @Override
        public void set(Integer v) {
            this.defined = v;
        }

        @Override
        public void setAsLong(long v) {
            this.defined = (int)OfInt.validate(32, v);
        }

        @Override
        void put(ByteBuffer output, int index) {
            this.current = this.defined;
            output.putInt(index, this.current);
        }

        @Override
        void write(ChannelDataOutput output) throws IOException {
            this.current = this.defined;
            output.writeInt(this.current);
        }
    }

    private static final class OfLong
    extends UpdatableWrite<Long> {
        private long current;
        private long defined;

        OfLong(ChannelDataOutput output, long value) {
            super(output);
            this.current = value;
            this.defined = value;
        }

        OfLong(long position) {
            super(position);
        }

        public Class<Long> getElementType() {
            return Long.class;
        }

        @Override
        public int sizeInBytes() {
            return 8;
        }

        @Override
        public boolean changed() {
            return this.defined != this.current;
        }

        @Override
        public Long get() {
            return this.defined;
        }

        @Override
        public OptionalLong getAsLong() {
            return OptionalLong.of(this.defined);
        }

        @Override
        public void set(Long v) {
            this.defined = v;
        }

        @Override
        public void setAsLong(long v) {
            this.defined = v;
        }

        @Override
        void put(ByteBuffer output, int index) {
            this.current = this.defined;
            output.putLong(index, this.current);
        }

        @Override
        void write(ChannelDataOutput output) throws IOException {
            this.current = this.defined;
            output.writeLong(this.current);
        }
    }
}

