/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

public class TimeDependentBWP
extends BursaWolfParameters {
    private static final long serialVersionUID = 8404372938646871943L;
    public double dtX;
    public double dtY;
    public double dtZ;
    public double drX;
    public double drY;
    public double drZ;
    public double ddS;
    private final Temporal timeReference;

    public TimeDependentBWP(GeodeticDatum targetDatum, Extent domainOfValidity, Temporal timeReference) {
        super(targetDatum, domainOfValidity);
        this.timeReference = Objects.requireNonNull(timeReference);
    }

    @Override
    void verify(PrimeMeridian pm) throws IllegalArgumentException {
        super.verify(pm);
        ArgumentChecks.ensureFinite((String)"dtX", (double)this.dtX);
        ArgumentChecks.ensureFinite((String)"dtY", (double)this.dtY);
        ArgumentChecks.ensureFinite((String)"dtZ", (double)this.dtZ);
        ArgumentChecks.ensureFinite((String)"drX", (double)this.drX);
        ArgumentChecks.ensureFinite((String)"drY", (double)this.drY);
        ArgumentChecks.ensureFinite((String)"drZ", (double)this.drZ);
    }

    public Temporal getTimeReference() {
        return this.timeReference;
    }

    @Override
    final DoubleDouble period(Temporal time) {
        Duration d;
        if (time != null && !(d = Duration.between(this.timeReference, time)).isZero()) {
            return DoubleDouble.of((Duration)d).divide(31556925445000000L);
        }
        return null;
    }

    @Override
    final DoubleDouble param(int index, DoubleDouble factor) {
        DoubleDouble p = super.param(index, factor);
        if (factor != null) {
            double d;
            switch (index) {
                case 0: {
                    d = this.dtX;
                    break;
                }
                case 1: {
                    d = this.dtY;
                    break;
                }
                case 2: {
                    d = this.dtZ;
                    break;
                }
                case 3: {
                    d = this.drX;
                    break;
                }
                case 4: {
                    d = this.drY;
                    break;
                }
                case 5: {
                    d = this.drZ;
                    break;
                }
                case 6: {
                    d = this.ddS;
                    break;
                }
                default: {
                    throw new AssertionError(index);
                }
            }
            p = p.add(factor.multiply(d, true));
        }
        return p;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.tX, this.tY, this.tZ, this.rX, this.rY, this.rZ, this.dS, this.dtX, this.dtY, this.dtZ, this.drX, this.drY, this.drZ, this.ddS};
    }

    @Override
    public void setValues(double ... elements) {
        if (elements.length >= 8) {
            switch (elements.length) {
                default: {
                    this.ddS = elements[13];
                }
                case 13: {
                    this.drZ = elements[12];
                }
                case 12: {
                    this.drY = elements[11];
                }
                case 11: {
                    this.drX = elements[10];
                }
                case 10: {
                    this.dtZ = elements[9];
                }
                case 9: {
                    this.dtY = elements[8];
                }
                case 8: 
            }
            this.dtX = elements[7];
        }
        super.setValues(elements);
    }

    @Override
    public boolean isIdentity() {
        return super.isIdentity() && this.dtX == 0.0 && this.dtY == 0.0 && this.dtZ == 0.0;
    }

    @Override
    public boolean isTranslation() {
        return super.isTranslation() && this.drX == 0.0 && this.drY == 0.0 && this.drZ == 0.0;
    }

    @Override
    public void reverseRotation() {
        super.reverseRotation();
        this.drX = -this.drX;
        this.drY = -this.drY;
        this.drZ = -this.drZ;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.timeReference == ((TimeDependentBWP)object).timeReference;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.timeReference.hashCode();
    }
}

