/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.panama;

import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.panama.Resources;

public enum LibraryStatus {
    LOADED(0),
    UNLOADED(6),
    LIBRARY_NOT_FOUND(5),
    FUNCTION_NOT_FOUND(4),
    UNAUTHORIZED(7),
    FATAL_ERROR(3);

    private final short message;

    private LibraryStatus(short message) {
        this.message = message;
    }

    public void report(String library, Exception cause) throws DataStoreException {
        if (this.message != 0 || cause != null) {
            String text = Resources.format(this.message, library);
            if (cause != null) {
                throw new DataStoreException(text, (Throwable)cause);
            }
            throw new DataStoreClosedException(text);
        }
    }
}

