/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.shared.Merger;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.acquisition.DefaultAcquisitionInformation;
import org.apache.sis.metadata.iso.acquisition.DefaultEvent;
import org.apache.sis.metadata.iso.acquisition.DefaultInstrument;
import org.apache.sis.metadata.iso.acquisition.DefaultOperation;
import org.apache.sis.metadata.iso.acquisition.DefaultPlatform;
import org.apache.sis.metadata.iso.acquisition.DefaultRequirement;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.citation.DefaultSeries;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultFeatureCatalogueDescription;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.distribution.DefaultFormat;
import org.apache.sis.metadata.iso.extent.DefaultBoundingPolygon;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.extent.NotSpatioTemporalException;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.identification.DefaultResolution;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.lineage.DefaultProcessStep;
import org.apache.sis.metadata.iso.lineage.DefaultProcessing;
import org.apache.sis.metadata.iso.lineage.DefaultSource;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.metadata.iso.maintenance.DefaultScopeDescription;
import org.apache.sis.metadata.iso.maintenance.LegacyFeatureType;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGCP;
import org.apache.sis.metadata.iso.spatial.DefaultGCPCollection;
import org.apache.sis.metadata.iso.spatial.DefaultGeorectified;
import org.apache.sis.metadata.iso.spatial.DefaultGeoreferenceable;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.pending.jdk.JDK21;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.LegalSymbols;
import org.apache.sis.storage.base.ResourceLineage;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.temporal.TimeMethods;
import org.apache.sis.util.AbstractInternationalString;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.acquisition.Context;
import org.opengis.metadata.acquisition.OperationType;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Processing;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.GCPCollection;
import org.opengis.metadata.spatial.GeolocationInformation;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;

public class MetadataBuilder {
    private PartyType partyType = PartyType.UNKNOWN;
    private GridType gridType = GridType.UNSPECIFIED;
    private boolean electromagnetic;
    private final Map<Object, Object> sharedValues = new HashMap<Object, Object>();
    private byte standardISO;
    private DefaultMetadata metadata;
    private DefaultDataIdentification identification;
    private DefaultCitation citation;
    private DefaultResponsibleParty responsibility;
    private AbstractParty party;
    private DefaultLegalConstraints constraints;
    private DefaultExtent extent;
    private DefaultAcquisitionInformation acquisition;
    private DefaultPlatform platform;
    private DefaultFeatureCatalogueDescription featureDescription;
    private DefaultCoverageDescription coverageDescription;
    private DefaultAttributeGroup attributeGroup;
    private DefaultSampleDimension sampleDimension;
    private DefaultGridSpatialRepresentation gridRepresentation;
    private DefaultGCPCollection groundControlPoints;
    private DefaultDistribution distribution;
    private Format format;
    private DefaultLineage lineage;
    private DefaultProcessStep processStep;
    private DefaultProcessing processing;

    public MetadataBuilder() {
    }

    public MetadataBuilder(Metadata edit) {
        this.metadata = DefaultMetadata.castOrCopy((Metadata)edit);
        this.useParentElements();
    }

    private DefaultMetadata metadata() {
        if (this.metadata == null) {
            this.metadata = new DefaultMetadata();
        }
        return this.metadata;
    }

    private DefaultDataIdentification identification() {
        if (this.identification == null) {
            this.identification = new DefaultDataIdentification();
        }
        return this.identification;
    }

    private DefaultCitation citation() {
        if (this.citation == null) {
            this.citation = new DefaultCitation();
        }
        return this.citation;
    }

    private DefaultSeries series() {
        DefaultCitation citation = this.citation();
        DefaultSeries series = DefaultSeries.castOrCopy((Series)citation.getSeries());
        if (series == null) {
            series = new DefaultSeries();
            citation.setSeries((Series)series);
        }
        return series;
    }

    private DefaultResponsibleParty responsibility() {
        if (this.responsibility == null) {
            this.responsibility = new DefaultResponsibleParty();
        }
        return this.responsibility;
    }

    private AbstractParty party() {
        if (this.party == null) {
            switch (this.partyType.ordinal()) {
                case 2: {
                    this.party = new AbstractParty();
                    break;
                }
                case 0: {
                    this.party = new DefaultIndividual();
                    break;
                }
                case 1: {
                    this.party = new DefaultOrganisation();
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.partyType);
                }
            }
        }
        return this.party;
    }

    private DefaultLegalConstraints constraints() {
        if (this.constraints == null) {
            this.constraints = new DefaultLegalConstraints();
        }
        return this.constraints;
    }

    private DefaultExtent extent() {
        if (this.extent == null) {
            this.extent = new DefaultExtent();
        }
        return this.extent;
    }

    private DefaultAcquisitionInformation acquisition() {
        if (this.acquisition == null) {
            this.acquisition = new DefaultAcquisitionInformation();
        }
        return this.acquisition;
    }

    private DefaultPlatform platform() {
        if (this.platform == null) {
            this.platform = new DefaultPlatform();
        }
        return this.platform;
    }

    private DefaultFeatureCatalogueDescription featureDescription() {
        if (this.featureDescription == null) {
            this.featureDescription = new DefaultFeatureCatalogueDescription();
            this.featureDescription.setIncludedWithDataset(true);
        }
        return this.featureDescription;
    }

    private DefaultCoverageDescription coverageDescription() {
        if (this.coverageDescription == null) {
            this.coverageDescription = this.electromagnetic ? new DefaultImageDescription() : new DefaultCoverageDescription();
        }
        return this.coverageDescription;
    }

    private DefaultAttributeGroup attributeGroup() {
        if (this.attributeGroup == null) {
            this.attributeGroup = new DefaultAttributeGroup();
        }
        return this.attributeGroup;
    }

    private DefaultSampleDimension sampleDimension() {
        if (this.sampleDimension == null) {
            this.sampleDimension = this.electromagnetic ? new DefaultBand() : new DefaultSampleDimension();
        }
        return this.sampleDimension;
    }

    private DefaultGridSpatialRepresentation gridRepresentation() {
        if (this.gridRepresentation == null) {
            switch (this.gridType.ordinal()) {
                case 0: {
                    this.gridRepresentation = new DefaultGeorectified();
                    break;
                }
                case 1: {
                    this.gridRepresentation = new DefaultGeoreferenceable();
                    break;
                }
                default: {
                    this.gridRepresentation = new DefaultGridSpatialRepresentation();
                }
            }
        }
        return this.gridRepresentation;
    }

    private DefaultGCPCollection groundControlPoints() {
        if (this.groundControlPoints == null) {
            this.groundControlPoints = new DefaultGCPCollection();
        }
        return this.groundControlPoints;
    }

    private DefaultDistribution distribution() {
        if (this.distribution == null) {
            this.distribution = new DefaultDistribution();
        }
        return this.distribution;
    }

    private DefaultFormat format() {
        DefaultFormat df = DefaultFormat.castOrCopy((Format)this.format);
        if (df == null) {
            df = new DefaultFormat();
        }
        this.format = df;
        return df;
    }

    private DefaultLineage lineage() {
        if (this.lineage == null) {
            this.lineage = new DefaultLineage();
        }
        return this.lineage;
    }

    private DefaultProcessStep processStep() {
        if (this.processStep == null) {
            this.processStep = new DefaultProcessStep();
        }
        return this.processStep;
    }

    private DefaultProcessing processing() {
        if (this.processing == null) {
            this.processing = new DefaultProcessing();
        }
        return this.processing;
    }

    private static <E> void addIfNotPresent(Collection<E> collection, E element) {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    public final void newParty(PartyType type) {
        if (this.party != null) {
            MetadataBuilder.addIfNotPresent(this.responsibility().getParties(), this.party);
            this.party = null;
        }
        this.partyType = Objects.requireNonNull(type);
    }

    public final void newIdentification() {
        this.newParty(PartyType.UNKNOWN);
        if (this.responsibility != null) {
            MetadataBuilder.addIfNotPresent(this.citation().getCitedResponsibleParties(), this.responsibility);
            this.responsibility = null;
        }
        if (this.citation != null) {
            this.identification().setCitation((Citation)this.citation);
            this.citation = null;
        }
        if (this.extent != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getExtents(), this.extent);
            this.extent = null;
        }
        if (this.format != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getResourceFormats(), this.format);
            this.format = null;
        }
        if (this.constraints != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getResourceConstraints(), this.constraints);
            this.constraints = null;
        }
        if (this.identification != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getIdentificationInfo(), this.identification);
            this.identification = null;
        }
    }

    public final void newAcquisition() {
        if (this.platform != null) {
            MetadataBuilder.addIfNotPresent(this.acquisition().getPlatforms(), this.platform);
        }
        if (this.acquisition != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getAcquisitionInformation(), this.acquisition);
            this.acquisition = null;
        }
    }

    public final void newDistribution() {
        if (this.distribution != null) {
            this.metadata().setDistributionInfo((Distribution)this.distribution);
            this.distribution = null;
        }
    }

    public final void newFeatureTypes() {
        if (this.featureDescription != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getContentInfo(), this.featureDescription);
            this.featureDescription = null;
        }
    }

    public final void newCoverage(boolean electromagnetic) {
        this.newSampleDimension();
        if (this.attributeGroup != null) {
            MetadataBuilder.addIfNotPresent(this.coverageDescription().getAttributeGroups(), this.attributeGroup);
            this.attributeGroup = null;
        }
        if (this.coverageDescription != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getContentInfo(), this.coverageDescription);
            this.coverageDescription = null;
        }
        this.electromagnetic = electromagnetic;
    }

    public final void newSampleDimension() {
        if (this.sampleDimension != null) {
            MetadataBuilder.addIfNotPresent(this.attributeGroup().getAttributes(), this.sampleDimension);
            this.sampleDimension = null;
        }
    }

    public final void newGridRepresentation(GridType type) {
        if (this.gridRepresentation != null) {
            int n = this.gridRepresentation.getAxisDimensionProperties().size();
            if (n != 0) {
                this.gridRepresentation.setNumberOfDimensions(this.shared(n));
            }
            if (this.groundControlPoints != null && this.gridRepresentation instanceof DefaultGeoreferenceable) {
                MetadataBuilder.addIfNotPresent(((DefaultGeoreferenceable)this.gridRepresentation).getGeolocationInformation(), this.groundControlPoints);
                this.groundControlPoints = null;
            }
            MetadataBuilder.addIfNotPresent(this.metadata.getSpatialRepresentationInfo(), this.gridRepresentation);
            this.gridRepresentation = null;
        }
        this.gridType = Objects.requireNonNull(type);
    }

    public final void newLineage() {
        if (this.processing != null) {
            this.processStep().setProcessingInformation((Processing)this.processing);
            this.processing = null;
        }
        if (this.processStep != null) {
            MetadataBuilder.addIfNotPresent(this.lineage().getProcessSteps(), this.processStep);
            this.processStep = null;
        }
        if (this.lineage != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getResourceLineages(), this.lineage);
            this.lineage = null;
        }
    }

    public final void addDefaultMetadata(AbstractResource resource, StoreListeners listeners) throws DataStoreException {
        if (this.getTitle() == null) {
            resource.getIdentifier().ifPresent(name -> this.addTitle((CharSequence)((Object)new Sentence((GenericName)name))));
        }
        resource.getEnvelope().ifPresent(envelope -> this.addExtent((Envelope)envelope, listeners));
    }

    public final void addDefaultMetadata(AbstractFeatureSet resource, StoreListeners listeners) throws DataStoreException {
        this.addDefaultMetadata((AbstractResource)resource, listeners);
        this.addFeatureType(resource.getType(), resource.getFeatureCount().orElse(-1L));
    }

    public final void addDefaultMetadata(AbstractGridCoverageResource resource, StoreListeners listeners) throws DataStoreException {
        this.addDefaultMetadata((AbstractResource)resource, listeners);
        this.addSpatialRepresentation(null, resource.getGridGeometry(), false);
        for (SampleDimension band : resource.getSampleDimensions()) {
            this.addNewBand(band);
        }
    }

    private Citation sharedCitation(InternationalString title) {
        if (title == null) {
            return null;
        }
        return (Citation)this.sharedValues.computeIfAbsent(title, k -> new DefaultCitation((CharSequence)k));
    }

    private Identifier sharedIdentifier(CharSequence authority, String code) {
        DefaultIdentifier id = new DefaultIdentifier(this.sharedCitation(MetadataBuilder.trim(authority)), code);
        return (Identifier)this.sharedValues.getOrDefault(id, id);
    }

    public final void addIdentifier(Identifier id, Scope scope) {
        if (id != null) {
            id = (Identifier)this.sharedValues.getOrDefault(id, id);
            if (scope != Scope.RESOURCE) {
                this.metadata().setMetadataIdentifier(id);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addIfNotPresent(this.citation().getIdentifiers(), id);
            }
        }
    }

    public final void addIdentifier(GenericName id, Scope scope) {
        if (id != null) {
            this.addIdentifier((Identifier)(id instanceof Identifier ? (Identifier)id : new NamedIdentifier(id)), scope);
        }
    }

    public final void addIdentifier(CharSequence authority, String code, Scope scope) {
        if ((code = Strings.trimOrNull((String)code)) != null) {
            Identifier id = this.sharedIdentifier(authority, code);
            if (scope != Scope.RESOURCE) {
                this.metadata().setMetadataIdentifier(id);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addIfNotPresent(this.citation().getIdentifiers(), id);
            }
        }
    }

    public boolean setPredefinedFormat(String abbreviation, StoreListeners listeners, boolean fallback) {
        if (abbreviation != null && abbreviation.length() != 0) {
            if (this.format == null) {
                try {
                    this.format = (Format)MetadataSource.getProvided().lookup(Format.class, abbreviation);
                    this.format = DefaultFormat.castOrCopy((Format)this.format);
                    return true;
                }
                catch (MetadataStoreException e) {
                    if (listeners != null) {
                        listeners.warning(Level.FINE, null, (Exception)((Object)e));
                    }
                    Logging.recoverableException((Logger)StoreUtilities.LOGGER, null, null, (Throwable)e);
                }
            }
            if (fallback) {
                this.addFormatName(abbreviation);
                return true;
            }
        }
        return false;
    }

    public final void addLanguage(Locale language, Charset encoding, Scope scope) {
        if (language != null) {
            if (scope != Scope.RESOURCE) {
                this.metadata().getLocalesAndCharsets().put(language, encoding);
            }
            if (scope != Scope.METADATA) {
                this.identification().getLocalesAndCharsets().put(language, encoding);
            }
        }
    }

    public final void addResourceScope(ScopeCode scope, CharSequence name) {
        if (scope != null || name != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getMetadataScopes(), new DefaultMetadataScope(scope, name));
        }
    }

    public final void addCitationDate(Temporal date, DateType type, Scope scope) {
        if (date != null) {
            DefaultCitationDate cd = new DefaultCitationDate(date, type);
            if (scope != Scope.RESOURCE) {
                MetadataBuilder.addEarliest(this.metadata().getDateInfo(), cd, type);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addEarliest(this.citation().getDates(), cd, type);
            }
        }
    }

    private static void addEarliest(Collection<CitationDate> dates, DefaultCitationDate date, DateType type) {
        Iterator<CitationDate> it = dates.iterator();
        while (it.hasNext()) {
            TimeMethods.Test method;
            CitationDate existing = it.next();
            if (!type.equals((Object)existing.getDateType()) || !(existing instanceof DefaultCitationDate)) continue;
            TimeMethods.Test test = method = type.name().startsWith("LATE_") ? TimeMethods.Test.BEFORE : TimeMethods.Test.AFTER;
            if (TimeMethods.compareLenient((TimeMethods.Test)method, (Temporal)((DefaultCitationDate)existing).getReferenceDate(), (Temporal)date.getReferenceDate())) {
                it.remove();
                break;
            }
            return;
        }
        dates.add((CitationDate)date);
    }

    private static InternationalString trim(CharSequence value) {
        if ((value = CharSequences.trimWhitespaces((CharSequence)value)) != null && value.length() != 0) {
            return Types.toInternationalString((CharSequence)value);
        }
        return null;
    }

    private static InternationalString append(InternationalString previous, InternationalString toAdd) {
        String a;
        if (previous == null) {
            return toAdd;
        }
        String p = previous.toString();
        if (p.contains(a = toAdd.toString())) {
            return previous;
        }
        return Types.toInternationalString((CharSequence)(p + System.lineSeparator() + a));
    }

    private static boolean equals(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.toString().equals(s2.toString());
    }

    public final InternationalString getTitle() {
        return this.citation != null ? this.citation.getTitle() : null;
    }

    public final void setTitle(CharSequence title) {
        InternationalString i18n = MetadataBuilder.trim(title);
        if (i18n != null) {
            this.citation().setTitle(i18n);
        }
    }

    public final void addTitle(CharSequence title) {
        InternationalString i18n = MetadataBuilder.trim(title);
        if (i18n != null) {
            DefaultCitation citation = this.citation();
            InternationalString current = citation.getTitle();
            if (current == null) {
                citation.setTitle(i18n);
            } else if (!MetadataBuilder.equals((CharSequence)current, (CharSequence)i18n)) {
                for (Identifier id : citation.getIdentifiers()) {
                    if (!CharSequences.equalsFiltered((CharSequence)title, (CharSequence)id.getCode(), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) continue;
                    return;
                }
                MetadataBuilder.addIfNotPresent(citation.getAlternateTitles(), i18n);
            }
        }
    }

    public final void addTitleOrIdentifier(String code, Scope scope) {
        if (scope != Scope.METADATA && this.getTitle() == null) {
            this.addTitle(code);
            if (scope == Scope.RESOURCE) {
                return;
            }
            scope = Scope.METADATA;
        }
        this.addIdentifier(null, code, scope);
    }

    public final void addEdition(CharSequence version) {
        InternationalString i18n = MetadataBuilder.trim(version);
        if (i18n != null) {
            DefaultCitation citation = this.citation();
            citation.setEdition(MetadataBuilder.append(citation.getEdition(), i18n));
        }
    }

    public final void addSeries(CharSequence name) {
        InternationalString i18n = MetadataBuilder.trim(name);
        if (i18n != null) {
            DefaultSeries series = this.series();
            series.setName(MetadataBuilder.append(series.getName(), i18n));
        }
    }

    public final void addPage(CharSequence page) {
        if (page != null) {
            DefaultSeries series = this.series();
            series.setPage(page.toString());
        }
    }

    public final void addPage(int page, int total) {
        if (page > 0) {
            this.addPage((CharSequence)Vocabulary.formatInternational((short)(total > 0 ? (short)255 : 254), (Object[])new Object[]{page, total}));
        }
    }

    public final void addPresentationForm(PresentationForm form) {
        if (form != null) {
            this.citation().getPresentationForms().add(form);
        }
    }

    public final void addAbstract(CharSequence description) {
        InternationalString i18n = MetadataBuilder.trim(description);
        if (i18n != null) {
            DefaultDataIdentification identification = this.identification();
            identification.setAbstract(MetadataBuilder.append(identification.getAbstract(), i18n));
        }
    }

    public final void addPurpose(CharSequence intention) {
        InternationalString i18n = MetadataBuilder.trim(intention);
        if (i18n != null) {
            DefaultDataIdentification identification = this.identification();
            identification.setPurpose(MetadataBuilder.append(identification.getPurpose(), i18n));
        }
    }

    public final void addOtherCitationDetails(CharSequence details) {
        InternationalString i18n = MetadataBuilder.trim(details);
        if (i18n != null) {
            DefaultCitation citation = this.citation();
            citation.setOtherCitationDetails(MetadataBuilder.append(citation.getOtherCitationDetails(), i18n));
        }
    }

    public final void addSupplementalInformation(CharSequence info) {
        InternationalString i18n = MetadataBuilder.trim(info);
        if (i18n != null) {
            DefaultDataIdentification identification = this.identification();
            identification.setSupplementalInformation(MetadataBuilder.append(identification.getSupplementalInformation(), i18n));
        }
    }

    public final void addTopicCategory(TopicCategory topic) {
        if (topic != null) {
            this.identification().getTopicCategories().add(topic);
        }
    }

    public final void addKeywords(Iterable<? extends CharSequence> keywords, KeywordType type, CharSequence thesaurusName) {
        if (keywords != null) {
            DefaultKeywords group = null;
            Collection list = null;
            for (CharSequence charSequence : keywords) {
                InternationalString i18n = MetadataBuilder.trim(charSequence);
                if (i18n == null) continue;
                if (list == null) {
                    group = new DefaultKeywords();
                    group.setType(type);
                    group.setThesaurusName(this.sharedCitation(MetadataBuilder.trim(thesaurusName)));
                    list = group.getKeywords();
                }
                list.add(i18n);
            }
            if (group != null) {
                MetadataBuilder.addIfNotPresent(this.identification().getDescriptiveKeywords(), group);
            }
        }
    }

    public final void addAuthor(CharSequence name) {
        InternationalString i18n = MetadataBuilder.trim(name);
        if (i18n != null) {
            InternationalString current;
            if (this.party != null && (current = this.party.getName()) != null) {
                if (MetadataBuilder.equals((CharSequence)current, name)) {
                    return;
                }
                this.newParty(this.partyType);
            }
            this.party().setName(i18n);
        }
    }

    public final void addCitedResponsibleParty(ResponsibleParty party, Role role) {
        if (party != null) {
            if (role != null && !role.equals((Object)party.getRole())) {
                party = new DefaultResponsibleParty(party);
                ((DefaultResponsibility)party).setRole(role);
            }
            MetadataBuilder.addIfNotPresent(this.citation().getCitedResponsibleParties(), party);
        }
    }

    public final void addPointOfContact(ResponsibleParty contact, Scope scope) {
        if (contact != null) {
            if (scope != Scope.RESOURCE) {
                MetadataBuilder.addIfNotPresent(this.metadata().getContacts(), contact);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addIfNotPresent(this.identification().getPointOfContacts(), contact);
            }
        }
    }

    public final void addDistributor(ResponsibleParty distributor) {
        if (distributor != null) {
            MetadataBuilder.addIfNotPresent(this.distribution().getDistributors(), new DefaultDistributor(distributor));
        }
    }

    public final void addCredits(CharSequence credit) {
        String c;
        if (credit != null && !(c = CharSequences.trimWhitespaces((CharSequence)credit).toString()).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.identification().getCredits(), c);
        }
    }

    public final void parseLegalNotice(Locale locale, String notice) {
        if (notice != null) {
            LegalSymbols.parse(locale, notice, this.constraints());
        }
    }

    public final void addAccessConstraint(Restriction restriction) {
        if (restriction != null) {
            this.constraints().getAccessConstraints().add(restriction);
        }
    }

    public final void addUseLimitation(CharSequence limitation) {
        InternationalString i18n = MetadataBuilder.trim(limitation);
        if (i18n != null) {
            MetadataBuilder.addIfNotPresent(this.constraints().getUseLimitations(), i18n);
        }
    }

    public final void addReferenceSystem(ReferenceSystem crs) {
        if (crs != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getReferenceSystemInfo(), crs);
        }
    }

    public final void addBoundingPolygon(Geometry bounds) {
        if (bounds != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), new DefaultBoundingPolygon(bounds));
        }
    }

    public final void addExtent(Citation authority, String identifier) {
        if (authority != null || identifier != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), new DefaultGeographicDescription(authority, identifier));
        }
    }

    public final void addExtent(Envelope envelope, StoreListeners listeners) {
        if (envelope != null) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            this.addReferenceSystem((ReferenceSystem)crs);
            if (!(envelope instanceof AbstractEnvelope && ((AbstractEnvelope)envelope).isAllNaN() || crs == null)) {
                try {
                    this.extent().addElements(envelope);
                }
                catch (TransformException e) {
                    boolean ignorable = e instanceof NotSpatioTemporalException;
                    if (listeners != null) {
                        if (ignorable) {
                            listeners.warning(Level.FINE, null, (Exception)((Object)e));
                        } else {
                            listeners.warning((Exception)((Object)e));
                        }
                    }
                    Logging.recoverableException((Logger)StoreUtilities.LOGGER, null, null, (Throwable)e);
                }
            }
        }
    }

    public final void addExtent(double[] coordinates, int index) {
        DefaultGeographicBoundingBox bbox;
        if (coordinates != null && !(bbox = new DefaultGeographicBoundingBox(coordinates[index], coordinates[++index], coordinates[++index], coordinates[++index])).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), bbox);
        }
    }

    public final void addVerticalExtent(double minimumValue, double maximumValue, VerticalCRS verticalCRS) {
        if (!Double.isNaN(minimumValue) || !Double.isNaN(maximumValue) || verticalCRS != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getVerticalElements(), new DefaultVerticalExtent(minimumValue, maximumValue, verticalCRS));
        }
    }

    public final void addTemporalExtent(Temporal startTime, Temporal endTime) {
        if (startTime != null || endTime != null) {
            DefaultTemporalExtent t = new DefaultTemporalExtent(startTime, endTime);
            MetadataBuilder.addIfNotPresent(this.extent().getTemporalElements(), t);
        }
    }

    public final GenericName addFeatureType(DefaultFeatureType type, long occurrences) {
        if (type == null) {
            return null;
        }
        GenericName name = type.getName();
        this.addFeatureType(name, occurrences);
        return name;
    }

    public final void addFeatureType(GenericName name, long occurrences) {
        if (name != null && occurrences != 0L) {
            DefaultFeatureTypeInfo info = new DefaultFeatureTypeInfo(name);
            if (occurrences > 0L) {
                info.setFeatureInstanceCount(this.shared((int)Math.min(occurrences, Integer.MAX_VALUE)));
            }
            MetadataBuilder.addIfNotPresent(this.featureDescription().getFeatureTypeInfo(), info);
        }
    }

    public final void addSpatialRepresentation(SpatialRepresentationType type) {
        if (type != null) {
            this.identification().getSpatialRepresentationTypes().add(type);
        }
    }

    public final boolean addSpatialRepresentation(String description, GridGeometry grid, boolean addResolution) {
        GridType type;
        if (grid == null) {
            if (description == null) {
                return false;
            }
            type = GridType.UNSPECIFIED;
        } else {
            type = grid.isConversionLinear(new int[]{0, 1}) ? GridType.GEORECTIFIED : GridType.GEOREFERENCEABLE;
        }
        this.addSpatialRepresentation(SpatialRepresentationType.GRID);
        this.newGridRepresentation(type);
        this.setGridToCRS(description);
        if (grid != null) {
            this.setGeoreferencingAvailability(grid.isDefined(8), false, false);
            CoordinateSystem cs = null;
            if (grid.isDefined(1)) {
                CoordinateReferenceSystem crs = grid.getCoordinateReferenceSystem();
                cs = crs.getCoordinateSystem();
                this.addReferenceSystem((ReferenceSystem)crs);
            }
            if (grid.isDefined(4)) {
                GridExtent gex = grid.getExtent();
                int dimension = gex.getDimension();
                for (int i = 0; i < dimension; ++i) {
                    Optional axisType = gex.getAxisType(i);
                    if (axisType.isPresent()) {
                        this.setAxisName(i, (DimensionNameType)axisType.get());
                    }
                    this.setAxisSize(i, gex.getSize(i));
                }
            }
            if (addResolution && grid.isDefined(16)) {
                double[] resolution = grid.getResolution(false);
                for (int i = 0; i < resolution.length; ++i) {
                    this.setAxisResolution(i, resolution[i], cs != null ? cs.getAxis(i).getUnit() : null);
                }
                this.addSpatioTemporalResolution(resolution, cs);
            }
        }
        return true;
    }

    public final void addSpatioTemporalResolution(double[] resolution, CoordinateSystem cs) {
        if (resolution != null && cs != null) {
            try {
                int dimension = Math.min(resolution.length, cs.getDimension());
                for (int i = 0; i < dimension; ++i) {
                    BiConsumer<DefaultResolution, Double> setter;
                    Unit targetUnit;
                    CoordinateSystemAxis axis = cs.getAxis(i);
                    Unit unit = axis.getUnit();
                    if (Units.isLinear((Unit)unit)) {
                        targetUnit = Units.METRE;
                        setter = AxisDirections.isVertical((AxisDirection)axis.getDirection()) ? DefaultResolution::setVertical : DefaultResolution::setDistance;
                    } else if (Units.isAngular((Unit)unit)) {
                        targetUnit = Units.DEGREE;
                        setter = DefaultResolution::setAngularDistance;
                    } else {
                        if (!Units.isTemporal((Unit)unit) || !AxisDirections.isTemporal((AxisDirection)axis.getDirection())) continue;
                        targetUnit = Units.DAY;
                        setter = null;
                    }
                    double distance = unit.getConverterToAny(targetUnit).convert(resolution[i]);
                    if (setter == null) {
                        this.addTemporalResolution(distance);
                        continue;
                    }
                    if (!(distance > 0.0) || distance == Double.POSITIVE_INFINITY) continue;
                    DefaultResolution r = new DefaultResolution();
                    setter.accept(r, this.shared(distance));
                    MetadataBuilder.addIfNotPresent(this.identification().getSpatialResolutions(), r);
                }
            }
            catch (IncommensurableException e) {
                Logging.unexpectedException((Logger)StoreUtilities.LOGGER, MetadataBuilder.class, (String)"addSpatioTemporalResolution", (Throwable)e);
            }
        }
    }

    public final void addLinearResolution(double distance) {
        if (distance > 0.0 && distance != Double.POSITIVE_INFINITY) {
            DefaultResolution r = new DefaultResolution();
            r.setDistance(this.shared(distance));
            MetadataBuilder.addIfNotPresent(this.identification().getSpatialResolutions(), r);
        }
    }

    public final void addTemporalResolution(double duration) {
        if (duration > 0.0 && duration != Double.POSITIVE_INFINITY) {
            MetadataBuilder.addIfNotPresent(this.identification().getTemporalResolutions(), Duration.ofNanos(Math.round(duration * 8.64E13)));
        }
    }

    public final void setCellGeometry(CellGeometry value) {
        if (value != null) {
            this.gridRepresentation().setCellGeometry(value);
        }
    }

    public final void setPointInPixel(PixelOrientation value) {
        DefaultGridSpatialRepresentation gridRepresentation;
        if (value != null && (gridRepresentation = this.gridRepresentation()) instanceof DefaultGeorectified) {
            ((DefaultGeorectified)gridRepresentation).setPointInPixel(value);
        }
    }

    public final void setGeoreferencingAvailability(boolean transformationParameterAvailability, boolean controlPointAvailability, boolean orientationParameterAvailability) {
        DefaultGridSpatialRepresentation gridRepresentation = this.gridRepresentation();
        gridRepresentation.setTransformationParameterAvailable(transformationParameterAvailability);
        if (gridRepresentation instanceof DefaultGeorectified) {
            ((DefaultGeorectified)gridRepresentation).setCheckPointAvailable(controlPointAvailability);
        } else if (gridRepresentation instanceof DefaultGeoreferenceable) {
            ((DefaultGeoreferenceable)gridRepresentation).setControlPointAvailable(controlPointAvailability);
            ((DefaultGeoreferenceable)gridRepresentation).setOrientationParameterAvailable(orientationParameterAvailability);
        }
    }

    public final void addGeolocation(GeolocationInformation info) {
        DefaultGridSpatialRepresentation gridRepresentation;
        if (info != null && (gridRepresentation = this.gridRepresentation()) instanceof DefaultGeoreferenceable) {
            MetadataBuilder.addIfNotPresent(((DefaultGeoreferenceable)gridRepresentation).getGeolocationInformation(), info);
        }
    }

    public final void addControlPoints(DirectPosition geographicCoordinates, Element accuracyReport) {
        if (geographicCoordinates != null) {
            Collection points;
            DefaultGridSpatialRepresentation gridRepresentation = this.gridRepresentation();
            if (gridRepresentation instanceof DefaultGeorectified) {
                points = ((DefaultGeorectified)gridRepresentation).getCheckPoints();
            } else if (gridRepresentation instanceof DefaultGeoreferenceable) {
                points = this.groundControlPoints().getGCPs();
            } else {
                return;
            }
            DefaultGCP gcp = new DefaultGCP();
            gcp.setGeographicCoordinates(geographicCoordinates);
            if (accuracyReport != null) {
                MetadataBuilder.addIfNotPresent(gcp.getAccuracyReports(), accuracyReport);
            }
            MetadataBuilder.addIfNotPresent(points, gcp);
        }
    }

    public final void setGridToCRS(CharSequence value) {
        DefaultGridSpatialRepresentation r;
        InternationalString i18n = MetadataBuilder.trim(value);
        if (i18n != null && (r = this.gridRepresentation()) instanceof DefaultGeorectified) {
            ((DefaultGeorectified)r).setTransformationDimensionDescription(i18n);
        }
    }

    private DefaultDimension axis(int index) {
        List axes = this.gridRepresentation().getAxisDimensionProperties();
        for (int i = axes.size(); i <= index; ++i) {
            axes.add(new DefaultDimension());
        }
        return (DefaultDimension)axes.get(index);
    }

    public final void setAxisName(int dimension, DimensionNameType name) {
        this.axis(dimension).setDimensionName(name);
    }

    public final void setAxisSize(int dimension, long length) {
        if (length >= 0L) {
            this.axis(dimension).setDimensionSize(this.shared(length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length));
        }
    }

    public final void setAxisResolution(int dimension, double resolution, Unit<?> unit) {
        if (resolution > 0.0 && resolution != Double.POSITIVE_INFINITY) {
            if (Units.isLinear(unit)) {
                resolution = unit.asType(Length.class).getConverterTo(Units.METRE).convert(resolution);
            }
            this.axis(dimension).setResolution(this.shared(resolution));
        }
    }

    public final void addContentType(CoverageContentType type) {
        if (type != null) {
            this.attributeGroup().getContentTypes().add(type);
        }
    }

    public final void addNewBand(SampleDimension band) {
        if (band != null) {
            this.newSampleDimension();
            this.setBandIdentifier(band.getName());
            band.getMeasurementRange().ifPresent(range -> {
                this.addMinimumSampleValue(range.getMinDouble());
                this.addMaximumSampleValue(range.getMaxDouble());
            });
            band.getTransferFunctionFormula().ifPresent(tr -> {
                this.setTransferFunction(tr.getScale(), tr.getOffset());
                this.sampleDimension().setTransferFunctionType(tr.getType());
            });
            band.getUnits().ifPresent(unit -> this.setSampleUnits((Unit<?>)unit));
        }
    }

    public final void setBandIdentifier(GenericName sequenceIdentifier) {
        if (sequenceIdentifier != null) {
            MemberName name = sequenceIdentifier instanceof MemberName ? (MemberName)sequenceIdentifier : Names.createMemberName(null, null, (CharSequence)sequenceIdentifier.tip().toString(), Integer.class);
            this.sampleDimension().setSequenceIdentifier(name);
        }
    }

    public final void setBandIdentifier(int sequenceIdentifier) {
        if (sequenceIdentifier > 0) {
            this.sampleDimension().setSequenceIdentifier(Names.createMemberName(null, null, (int)sequenceIdentifier));
        }
    }

    public final void addBandName(CharSequence authority, String name) {
        if ((name = Strings.trimOrNull((String)name)) != null) {
            MetadataBuilder.addIfNotPresent(this.sampleDimension().getNames(), this.sharedIdentifier(authority, name));
        }
    }

    public final void addBandDescription(CharSequence description) {
        InternationalString i18n = MetadataBuilder.trim(description);
        if (i18n != null) {
            DefaultSampleDimension sampleDimension = this.sampleDimension();
            sampleDimension.setDescription(MetadataBuilder.append(sampleDimension.getDescription(), i18n));
        }
    }

    public void addSampleValueDescription(CharSequence name, CharSequence definition) {
        InternationalString i18n = MetadataBuilder.trim(name);
        InternationalString def = MetadataBuilder.trim(definition);
        if (i18n != null && def != null) {
            DefaultRangeElementDescription element = new DefaultRangeElementDescription();
            element.setName(i18n);
            element.setDefinition(def);
            MetadataBuilder.addIfNotPresent(this.coverageDescription().getRangeElementDescriptions(), element);
        }
    }

    public final void addMinimumSampleValue(double value) {
        DefaultSampleDimension sampleDimension;
        Double current;
        if (!Double.isNaN(value) && ((current = (sampleDimension = this.sampleDimension()).getMinValue()) == null || value < current)) {
            sampleDimension.setMinValue(this.shared(value));
        }
    }

    public final void addMaximumSampleValue(double value) {
        DefaultSampleDimension sampleDimension;
        Double current;
        if (!Double.isNaN(value) && ((current = (sampleDimension = this.sampleDimension()).getMaxValue()) == null || value > current)) {
            sampleDimension.setMaxValue(this.shared(value));
        }
    }

    public final boolean hasSampleValueRange() {
        return this.sampleDimension != null && (this.sampleDimension.getMinValue() != null || this.sampleDimension.getMaxValue() != null);
    }

    public final void setSampleUnits(Unit<?> unit) {
        if (unit != null) {
            this.sampleDimension().setUnits(unit);
        }
    }

    public final void setTransferFunction(double scale, double offset) {
        if (!Double.isNaN(scale) || !Double.isNaN(offset)) {
            DefaultSampleDimension sd = this.sampleDimension();
            if (!Double.isNaN(scale)) {
                sd.setScaleFactor(Double.valueOf(scale));
            }
            if (!Double.isNaN(offset)) {
                sd.setOffset(Double.valueOf(offset));
            }
            sd.setTransferFunctionType(TransferFunctionType.LINEAR);
        }
    }

    public final void setBitPerSample(int bits) {
        this.sampleDimension().setBitsPerValue(Integer.valueOf(bits));
    }

    public final void setProcessingLevelCode(CharSequence authority, String processingLevel) {
        if ((processingLevel = Strings.trimOrNull((String)processingLevel)) != null) {
            this.coverageDescription().setProcessingLevelCode(this.sharedIdentifier(authority, processingLevel));
        }
    }

    public final void setCloudCoverPercentage(double value) {
        if (!Double.isNaN(value)) {
            ((DefaultImageDescription)this.coverageDescription()).setCloudCoverPercentage(this.shared(value));
        }
    }

    public final void setIlluminationAzimuthAngle(double value) {
        if (!Double.isNaN(value)) {
            ((DefaultImageDescription)this.coverageDescription()).setIlluminationAzimuthAngle(this.shared(value));
        }
    }

    public final void setIlluminationElevationAngle(double value) {
        if (!Double.isNaN(value)) {
            ((DefaultImageDescription)this.coverageDescription()).setIlluminationElevationAngle(this.shared(value));
        }
    }

    public final void addPlatform(CharSequence authority, String identifier) {
        if ((identifier = Strings.trimOrNull((String)identifier)) != null) {
            Identifier current;
            if (this.platform != null && (current = this.platform.getIdentifier()) != null) {
                if (identifier.equals(current.getCode())) {
                    return;
                }
                this.acquisition().getPlatforms().add(this.platform);
                this.platform = null;
            }
            this.platform().setIdentifier(this.sharedIdentifier(authority, identifier));
        }
    }

    public final void addInstrument(CharSequence authority, String identifier) {
        if ((identifier = Strings.trimOrNull((String)identifier)) != null) {
            DefaultInstrument instrument = new DefaultInstrument();
            instrument.setIdentifier(this.sharedIdentifier(authority, identifier));
            MetadataBuilder.addIfNotPresent(this.platform().getInstruments(), instrument);
        }
    }

    public final void addAcquisitionTime(Temporal time) {
        if (time != null) {
            DefaultEvent event = new DefaultEvent();
            event.setContext(Context.ACQUISITION);
            event.setDateOfOccurrence(time);
            DefaultOperation op = new DefaultOperation();
            op.setSignificantEvents(Collections.singleton(event));
            op.setType(OperationType.REAL);
            op.setStatus(Progress.COMPLETED);
            MetadataBuilder.addIfNotPresent(this.acquisition().getOperations(), op);
        }
    }

    public final void addAcquisitionTime(Instant startTime, Instant endTime) {
        Instant time;
        if (startTime == null) {
            if (endTime == null) {
                return;
            }
            time = endTime;
        } else {
            time = endTime == null ? startTime : Instant.ofEpochMilli((startTime.toEpochMilli() >> 1) + (endTime.toEpochMilli() >> 1));
        }
        this.addAcquisitionTime(time);
    }

    public final void addAcquisitionOperation(CharSequence program, String identifier) {
        if ((identifier = Strings.trimOrNull((String)identifier)) != null) {
            DefaultOperation r = new DefaultOperation();
            r.setIdentifier(this.sharedIdentifier(program, identifier));
            MetadataBuilder.addIfNotPresent(this.acquisition().getOperations(), r);
        }
    }

    public final void addAcquisitionRequirement(CharSequence authority, String identifier) {
        if ((identifier = Strings.trimOrNull((String)identifier)) != null) {
            DefaultRequirement r = new DefaultRequirement();
            r.setIdentifier(this.sharedIdentifier(authority, identifier));
            MetadataBuilder.addIfNotPresent(this.acquisition().getAcquisitionRequirements(), r);
        }
    }

    public final void addLineage(CharSequence statement) {
        InternationalString i18n = MetadataBuilder.trim(statement);
        if (i18n != null) {
            DefaultLineage lineage = this.lineage();
            lineage.setStatement(MetadataBuilder.append(lineage.getStatement(), i18n));
        }
    }

    public final void addSource(Metadata source) {
        ResourceLineage r;
        if (source != null && !(r = new ResourceLineage(source)).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.lineage().getSources(), r.build());
        }
    }

    public final void addSource(CharSequence description, ScopeCode level, CharSequence feature) {
        InternationalString i18n = MetadataBuilder.trim(description);
        if (i18n != null) {
            DefaultSource source = new DefaultSource(description);
            if (level != null || feature != null) {
                DefaultScope scope = new DefaultScope(level);
                if (feature != null) {
                    DefaultScopeDescription sd = new DefaultScopeDescription();
                    sd.getFeatures().add(new LegacyFeatureType(feature));
                    scope.getLevelDescription().add(sd);
                }
            }
            MetadataBuilder.addIfNotPresent(this.lineage().getSources(), source);
        }
    }

    public final void addSource(Metadata metadata, ScopeCode level, CharSequence ... features) {
        if (metadata != null) {
            DefaultSource source = new DefaultSource();
            DefaultScope scope = new DefaultScope(level);
            source.setSourceReferenceSystem((ReferenceSystem)Containers.peekFirst((Iterable)metadata.getReferenceSystemInfo()));
            for (Identification id : metadata.getIdentificationInfo()) {
                source.setSourceCitation(id.getCitation());
                if (id instanceof AbstractIdentification) {
                    AbstractIdentification aid = (AbstractIdentification)id;
                    source.setSourceSpatialResolution((Resolution)Containers.peekFirst((Iterable)aid.getSpatialResolutions()));
                    scope.setExtents(aid.getExtents());
                }
                if (features != null && features.length != 0) {
                    DefaultScopeDescription sd = new DefaultScopeDescription();
                    sd.setLevelDescription(level, new LinkedHashSet<CharSequence>(Arrays.asList(features)));
                    scope.getLevelDescription().add((ScopeDescription)this.shared(DefaultScopeDescription.class, sd));
                }
                source.setScope((org.opengis.metadata.quality.Scope)(scope.isEmpty() ? null : scope));
                if (source.isEmpty()) continue;
                MetadataBuilder.addIfNotPresent(this.lineage().getSources(), source);
                break;
            }
        }
    }

    public final void addProcessing(CharSequence authority, String identifier) {
        if ((identifier = Strings.trimOrNull((String)identifier)) != null) {
            Identifier current;
            if (this.processing != null && (current = this.processing.getIdentifier()) != null) {
                if (identifier.equals(current.getCode())) {
                    return;
                }
                this.processStep().setProcessingInformation((Processing)this.processing);
                MetadataBuilder.addIfNotPresent(this.lineage().getProcessSteps(), this.processStep);
                this.processing = null;
                this.processStep = null;
            }
            this.processing().setIdentifier(this.sharedIdentifier(authority, identifier));
        }
    }

    public final void addSoftwareReference(CharSequence title) {
        InternationalString i18n = MetadataBuilder.trim(title);
        if (i18n != null) {
            MetadataBuilder.addIfNotPresent(this.processing().getSoftwareReferences(), this.sharedCitation(i18n));
        }
    }

    public final void addHostComputer(CharSequence platform) {
        InternationalString i18n = MetadataBuilder.trim(platform);
        if (i18n != null) {
            i18n = Resources.formatInternational((short)12, i18n);
            DefaultProcessing p = this.processing();
            p.setProcedureDescription(MetadataBuilder.append(p.getProcedureDescription(), i18n));
        }
    }

    public final void addProcessDescription(CharSequence description) {
        InternationalString i18n = MetadataBuilder.trim(description);
        if (i18n != null) {
            DefaultProcessStep ps = this.processStep();
            ps.setDescription(MetadataBuilder.append(ps.getDescription(), i18n));
        }
    }

    public final void addFormatName(CharSequence value) {
        this.addFormatName(value, true);
    }

    private void addFormatName(CharSequence value, boolean more) {
        InternationalString i18n = MetadataBuilder.trim(value);
        if (i18n != null) {
            DefaultFormat format = this.format();
            DefaultCitation c = DefaultCitation.castOrCopy((Citation)format.getFormatSpecificationCitation());
            if (c == null) {
                c = new DefaultCitation((CharSequence)i18n);
            } else if (more) {
                MetadataBuilder.addIfNotPresent(c.getAlternateTitles(), i18n);
            }
            format.setFormatSpecificationCitation((Citation)c);
        }
    }

    private DefaultCitation getFormatCitation() {
        DefaultFormat format = this.format();
        DefaultCitation c = DefaultCitation.castOrCopy((Citation)format.getFormatSpecificationCitation());
        if (c == null) {
            c = new DefaultCitation();
        }
        format.setFormatSpecificationCitation((Citation)c);
        return c;
    }

    public final void setFormatEdition(CharSequence value) {
        InternationalString i18n = MetadataBuilder.trim(value);
        if (i18n != null) {
            this.getFormatCitation().setEdition(i18n);
        }
    }

    public final void addFormatCitationDetails(CharSequence details) {
        InternationalString i18n = MetadataBuilder.trim(details);
        if (i18n != null) {
            DefaultCitation c = this.getFormatCitation();
            c.setOtherCitationDetails(MetadataBuilder.append(c.getOtherCitationDetails(), i18n));
        }
    }

    public final void addFormatReader(CharSequence driver, Version version) {
        if (driver != null) {
            this.addFormatCitationDetails((CharSequence)Resources.formatInternational((short)83, driver, version != null ? version : Vocabulary.formatInternational((short)209)));
        }
    }

    public void addFormatReaderSIS(String provider) {
        this.addFormatName(provider, false);
        this.addFormatReader((CharSequence)Citations.SIS.getTitle(), Version.SIS);
    }

    public final void addCompression(CharSequence value) {
        InternationalString i18n = MetadataBuilder.trim(value);
        if (i18n != null) {
            DefaultFormat format = this.format();
            format.setFileDecompressionTechnique(MetadataBuilder.append(format.getFileDecompressionTechnique(), i18n));
        }
    }

    public final void addCompleteMetadata(URI link) {
        if (link != null) {
            DefaultOnlineResource ln = new DefaultOnlineResource(link);
            ln.setFunction(OnLineFunction.valueOf((String)"COMPLETE_METADATA"));
            ln.setProtocol(link.getScheme());
            MetadataBuilder.addIfNotPresent(this.metadata().getMetadataLinkages(), ln);
        }
    }

    public final void setISOStandards(boolean part2) {
        this.standardISO = (byte)(part2 ? 2 : 1);
    }

    public final void addFromComponent(Metadata component) {
        for (Object info : component.getIdentificationInfo()) {
            DataIdentification di;
            Citation c = info.getCitation();
            if (c != null) {
                DefaultCitation citation = this.citation();
                if (citation.getTitle() == null) {
                    citation.setTitle(c.getTitle());
                }
                for (Format r : c.getCitedResponsibleParties()) {
                    MetadataBuilder.addIfNotPresent(citation.getCitedResponsibleParties(), r);
                }
                citation.getPresentationForms().addAll(c.getPresentationForms());
            }
            DefaultDataIdentification identification = this.identification();
            for (Format r : info.getResourceFormats()) {
                this.addCompression((CharSequence)r.getFileDecompressionTechnique());
            }
            for (Format r : info.getResourceConstraints()) {
                MetadataBuilder.addIfNotPresent(identification.getResourceConstraints(), r);
            }
            if (info instanceof DataIdentification) {
                di = (DataIdentification)info;
                for (Extent e : di.getExtents()) {
                    MetadataBuilder.addIfNotPresent(identification.getExtents(), e);
                }
                for (TemporalAmount r : di.getSpatialResolutions()) {
                    MetadataBuilder.addIfNotPresent(identification.getSpatialResolutions(), r);
                }
                identification.getTopicCategories().addAll(di.getTopicCategories());
                identification.getSpatialRepresentationTypes().addAll(di.getSpatialRepresentationTypes());
            }
            if (!(info instanceof AbstractIdentification)) continue;
            di = (AbstractIdentification)info;
            for (TemporalAmount r : di.getTemporalResolutions()) {
                MetadataBuilder.addIfNotPresent(identification.getTemporalResolutions(), r);
            }
        }
        DefaultMetadata metadata = this.metadata();
        for (ContentInformation info : component.getContentInfo()) {
            MetadataBuilder.addIfNotPresent(metadata.getContentInfo(), info);
        }
        for (ReferenceSystem crs : component.getReferenceSystemInfo()) {
            this.addReferenceSystem(crs);
        }
        for (ContentInformation info : component.getSpatialRepresentationInfo()) {
            MetadataBuilder.addIfNotPresent(metadata.getSpatialRepresentationInfo(), info);
        }
        for (ContentInformation info : component.getAcquisitionInformation()) {
            MetadataBuilder.addIfNotPresent(metadata.getAcquisitionInformation(), info);
        }
        Distribution di = component.getDistributionInfo();
        if (di != null) {
            for (Distributor r : di.getDistributors()) {
                MetadataBuilder.addIfNotPresent(this.distribution().getDistributors(), r);
            }
        }
    }

    public boolean mergeMetadata(Object source, Locale locale) {
        DefaultMetadata target;
        this.flush();
        if (source instanceof Metadata) {
            target = this.metadata();
        } else if (source instanceof DataIdentification) {
            target = this.identification();
        } else if (source instanceof GridSpatialRepresentation) {
            target = this.gridRepresentation();
        } else if (source instanceof CoverageDescription) {
            target = this.coverageDescription();
        } else if (source instanceof FeatureCatalogueDescription) {
            target = this.featureDescription();
        } else if (source instanceof AcquisitionInformation) {
            target = this.acquisition();
        } else if (source instanceof Lineage) {
            target = this.lineage();
        } else if (source instanceof Distribution) {
            target = this.distribution();
        } else if (source instanceof Citation) {
            target = this.citation();
        } else if (source instanceof Extent) {
            target = this.extent();
        } else if (source instanceof LegalConstraints) {
            target = this.constraints();
        } else if (source instanceof Series) {
            target = this.series();
        } else if (source instanceof DefaultResponsibleParty) {
            target = this.responsibility();
        } else if (source instanceof AbstractParty) {
            target = this.party();
        } else if (source instanceof DefaultAttributeGroup) {
            target = this.attributeGroup();
        } else if (source instanceof SampleDimension) {
            target = this.sampleDimension();
        } else if (source instanceof GCPCollection) {
            target = this.groundControlPoints();
        } else if (source instanceof Format) {
            target = this.format();
        } else if (source instanceof Platform) {
            target = this.platform();
        } else if (source instanceof ProcessStep) {
            target = this.processStep();
        } else if (source instanceof Processing) {
            target = this.processing();
        } else {
            if (source instanceof ReferenceSystem) {
                this.addReferenceSystem((ReferenceSystem)source);
                return true;
            }
            return false;
        }
        Merger merger = new Merger(locale);
        merger.copy(source, (ModifiableMetadata)target);
        this.useParentElements();
        return true;
    }

    private void useParentElements() {
        if (this.identification == null) {
            this.identification = MetadataBuilder.last(DefaultDataIdentification.class, this.metadata, DefaultMetadata::getIdentificationInfo);
        }
        if (this.gridRepresentation == null) {
            this.gridRepresentation = MetadataBuilder.last(DefaultGridSpatialRepresentation.class, this.metadata, DefaultMetadata::getSpatialRepresentationInfo);
        }
        if (this.coverageDescription == null) {
            this.coverageDescription = MetadataBuilder.last(DefaultCoverageDescription.class, this.metadata, DefaultMetadata::getContentInfo);
        }
        if (this.featureDescription == null) {
            this.featureDescription = MetadataBuilder.last(DefaultFeatureCatalogueDescription.class, this.metadata, DefaultMetadata::getContentInfo);
        }
        if (this.acquisition == null) {
            this.acquisition = MetadataBuilder.last(DefaultAcquisitionInformation.class, this.metadata, DefaultMetadata::getAcquisitionInformation);
        }
        if (this.lineage == null) {
            this.lineage = MetadataBuilder.last(DefaultLineage.class, this.metadata, DefaultMetadata::getResourceLineages);
        }
        if (this.distribution == null) {
            this.distribution = MetadataBuilder.fetch(DefaultDistribution.class, this.metadata, DefaultMetadata::getDistributionInfo);
        }
        if (this.citation == null) {
            this.citation = MetadataBuilder.fetch(DefaultCitation.class, this.identification, AbstractIdentification::getCitation);
        }
        if (this.extent == null) {
            this.extent = MetadataBuilder.last(DefaultExtent.class, this.identification, AbstractIdentification::getExtents);
        }
        if (this.constraints == null) {
            this.constraints = MetadataBuilder.last(DefaultLegalConstraints.class, this.identification, AbstractIdentification::getResourceConstraints);
        }
        if (this.responsibility == null) {
            this.responsibility = MetadataBuilder.last(DefaultResponsibleParty.class, this.citation, DefaultCitation::getCitedResponsibleParties);
        }
        if (this.party == null) {
            this.party = MetadataBuilder.last(AbstractParty.class, this.responsibility, DefaultResponsibility::getParties);
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = MetadataBuilder.last(DefaultAttributeGroup.class, this.coverageDescription, DefaultCoverageDescription::getAttributeGroups);
        }
        if (this.sampleDimension == null) {
            this.sampleDimension = MetadataBuilder.last(DefaultSampleDimension.class, this.attributeGroup, DefaultAttributeGroup::getAttributes);
        }
        if (this.format == null) {
            this.format = (Format)MetadataBuilder.last(DefaultFormat.class, this.distribution, DefaultDistribution::getDistributionFormats);
        }
        if (this.platform == null) {
            this.platform = MetadataBuilder.last(DefaultPlatform.class, this.acquisition, DefaultAcquisitionInformation::getPlatforms);
        }
        if (this.processStep == null) {
            this.processStep = MetadataBuilder.last(DefaultProcessStep.class, this.lineage, DefaultLineage::getProcessSteps);
        }
        if (this.processing == null) {
            this.processing = MetadataBuilder.fetch(DefaultProcessing.class, this.processStep, DefaultProcessStep::getProcessingInformation);
        }
    }

    private static <S extends ISOMetadata, E, T extends E> T fetch(Class<T> target, S source, Function<S, E> getter) {
        E last;
        if (source != null && target.isInstance(last = getter.apply(source))) {
            return target.cast(last);
        }
        return null;
    }

    private static <S extends ISOMetadata, E, T extends E> T last(Class<T> target, S source, Function<S, Collection<E>> getter) {
        if (source != null) {
            for (Object last : JDK21.reversed(getter.apply(source))) {
                if (!target.isInstance(last)) continue;
                return target.cast(last);
            }
        }
        return null;
    }

    private void flush() {
        this.newIdentification();
        this.newGridRepresentation(GridType.UNSPECIFIED);
        this.newFeatureTypes();
        this.newCoverage(false);
        this.newAcquisition();
        this.newDistribution();
        this.newLineage();
    }

    public final DefaultMetadata build() {
        this.flush();
        DefaultMetadata md = this.metadata();
        if (this.standardISO != 0) {
            List<Citation> c = Citations.ISO_19115;
            if (this.standardISO == 1) {
                c = Collections.singletonList((Citation)c.get(0));
            }
            md.setMetadataStandards((Collection)c);
        }
        return md;
    }

    public final DefaultMetadata buildAndFreeze() {
        DefaultMetadata md = this.build();
        md.transitionTo(ModifiableMetadata.State.FINAL);
        return md;
    }

    private <T> T shared(Class<T> type, T value) {
        T existing = type.cast(this.sharedValues.putIfAbsent(value, value));
        return existing != null ? existing : value;
    }

    protected final Double shared(double value) {
        Double n = value;
        Object existing = this.sharedValues.putIfAbsent(n, n);
        return existing != null ? (Double)existing : n;
    }

    protected final Integer shared(int value) {
        Integer n = value;
        Object existing = this.sharedValues.putIfAbsent(n, n);
        return existing != null ? (Integer)existing : n;
    }

    public static enum PartyType {
        INDIVIDUAL,
        ORGANISATION,
        UNKNOWN;

    }

    public static enum GridType {
        GEORECTIFIED,
        GEOREFERENCEABLE,
        UNSPECIFIED;

    }

    public static enum Scope {
        RESOURCE,
        METADATA,
        ALL;

    }

    private static final class Sentence
    extends AbstractInternationalString {
        private final InternationalString name;

        Sentence(GenericName name) {
            this.name = name.toInternationalString();
        }

        public String toString(Locale locale) {
            return CharSequences.camelCaseToSentence((CharSequence)this.name.toString(locale)).toString();
        }

        public int hashCode() {
            return ~this.name.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Sentence && this.name.equals((Object)((Sentence)((Object)other)).name);
        }
    }
}

