/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.BinaryFunctionWidening;
import org.apache.sis.filter.base.Node;
import org.apache.sis.math.Fraction;
import org.apache.sis.pending.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.pending.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.pending.geoapi.filter.MatchAction;
import org.apache.sis.temporal.TimeMethods;

abstract class ComparisonFilter<R>
extends BinaryFunctionWidening<R, Object, Object>
implements BinaryComparisonOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 1228683039737814926L;
    protected final boolean isMatchingCase;
    protected final MatchAction matchAction;

    ComparisonFilter(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        super(expression1, expression2);
        this.isMatchingCase = isMatchingCase;
        this.matchAction = Objects.requireNonNull(matchAction);
    }

    @Override
    public final Expression<R, ?> getOperand1() {
        return this.expression1;
    }

    @Override
    public final Expression<R, ?> getOperand2() {
        return this.expression2;
    }

    @Override
    public final boolean isMatchingCase() {
        return this.isMatchingCase;
    }

    @Override
    public final MatchAction getMatchAction() {
        return this.matchAction;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.isMatchingCase) + 61 * this.matchAction.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (super.equals(obj)) {
            ComparisonFilter other = (ComparisonFilter)obj;
            return other.isMatchingCase == this.isMatchingCase && this.matchAction.equals((Object)other.matchAction);
        }
        return false;
    }

    @Override
    public final boolean allowLiteralConversions() {
        return true;
    }

    @Override
    public final Filter<R> optimize(Optimization optimization) {
        Filter result = Optimization.OnFilter.super.optimize(optimization);
        if (result instanceof ComparisonFilter) {
            Class t2;
            ComparisonFilter optimized = (ComparisonFilter)result;
            Class t1 = ComparisonFilter.getResultClass(this.expression1);
            if (ComparisonFilter.isSpecialized(t1) && ComparisonFilter.isSpecialized(t2 = ComparisonFilter.getResultClass(this.expression2))) {
                Numeric numeric = optimized.new Numeric();
                if (numeric.evaluator != null) {
                    return numeric;
                }
                Time temporal = new Time(TimeMethods.forTypes(t1, t2), t2);
                if (temporal.evaluator != null) {
                    return temporal;
                }
            }
        }
        return result;
    }

    private static boolean isSpecialized(Class<?> type) {
        return type != null && type != Object.class;
    }

    @Override
    public final boolean test(R candidate) {
        Object right;
        Object left = this.expression1.apply(candidate);
        if (left != null && (right = this.expression2.apply(candidate)) != null) {
            Iterable collection;
            boolean collectionFirst = left instanceof Iterable;
            if (collectionFirst) {
                if (right instanceof Iterable) {
                    return false;
                }
                collection = (Iterable)left;
            } else if (right instanceof Iterable) {
                collection = (Iterable)right;
            } else {
                return this.evaluate(left, right);
            }
            boolean match = false;
            block5: for (Object element : collection) {
                if (element == null) continue;
                boolean pass = collectionFirst ? this.evaluate(element, right) : this.evaluate(left, element);
                switch (this.matchAction) {
                    default: {
                        return false;
                    }
                    case ALL: {
                        if (!pass) {
                            return false;
                        }
                        match = true;
                        continue block5;
                    }
                    case ANY: {
                        if (!pass) continue block5;
                        return true;
                    }
                    case ONE: 
                }
                if (!pass) continue;
                if (match) {
                    return false;
                }
                match = true;
            }
            return match;
        }
        return false;
    }

    private boolean evaluate(Object left, Object right) {
        Number r;
        if (left instanceof Number && right instanceof Number && (r = this.apply((Number)left, (Number)right)) != null) {
            return r.intValue() != 0;
        }
        try {
            Boolean c = TimeMethods.compareIfTemporal((TimeMethods.Test)this.temporalTest(), (Object)left, (Object)right);
            if (c != null) {
                return c;
            }
        }
        catch (DateTimeException e) {
            this.warning(e);
            return false;
        }
        if (left instanceof CharSequence || right instanceof CharSequence) {
            String s1 = left.toString();
            String s2 = right.toString();
            int result = this.isMatchingCase ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
            return this.fromCompareTo(result);
        }
        if (left.getClass() == right.getClass() && left instanceof Comparable) {
            int result = ((Comparable)left).compareTo(right);
            return this.fromCompareTo(result);
        }
        return false;
    }

    private static Number number(boolean result) {
        return result ? 1 : 0;
    }

    protected abstract boolean fromCompareTo(int var1);

    protected abstract TimeMethods.Test temporalTest();

    @Override
    protected final Number applyAsDecimal(BigDecimal left, BigDecimal right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    @Override
    protected final Number applyAsInteger(BigInteger left, BigInteger right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    @Override
    protected final Number applyAsFraction(Fraction left, Fraction right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    private final class Numeric
    extends Node
    implements Filter<R> {
        private static final long serialVersionUID = 4969425622445580192L;
        final Expression<R, ? extends Number> evaluator;

        Numeric() {
            this.evaluator = ComparisonFilter.this.specialize();
        }

        @Override
        public Enum<?> getOperatorType() {
            return ComparisonFilter.this.getOperatorType();
        }

        @Override
        public Class<? super R> getResourceClass() {
            return ComparisonFilter.this.getResourceClass();
        }

        @Override
        public List<Expression<R, ?>> getExpressions() {
            return ComparisonFilter.this.getExpressions();
        }

        @Override
        protected Collection<?> getChildren() {
            return ComparisonFilter.this.getChildren();
        }

        @Override
        public boolean test(R candidate) {
            return (Integer)this.evaluator.apply(candidate) != 0;
        }
    }

    private final class Time<T, S>
    extends Node
    implements Filter<R> {
        private static final long serialVersionUID = -5132906457258846016L;
        final BiPredicate<T, S> evaluator;

        Time(TimeMethods<T> methods, Class<S> otherType) {
            this.evaluator = methods != null ? methods.predicate(ComparisonFilter.this.temporalTest(), otherType) : null;
        }

        @Override
        public Enum<?> getOperatorType() {
            return ComparisonFilter.this.getOperatorType();
        }

        @Override
        public Class<? super R> getResourceClass() {
            return ComparisonFilter.this.getResourceClass();
        }

        @Override
        public List<Expression<R, ?>> getExpressions() {
            return ComparisonFilter.this.getExpressions();
        }

        @Override
        protected Collection<?> getChildren() {
            return ComparisonFilter.this.getChildren();
        }

        @Override
        public boolean test(R candidate) {
            Object right;
            Object left = ComparisonFilter.this.expression1.apply(candidate);
            if (left != null && (right = ComparisonFilter.this.expression2.apply(candidate)) != null) {
                return this.evaluator.test(left, right);
            }
            return false;
        }
    }

    static final class Between<R>
    extends Node
    implements BetweenComparisonOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -2434954008425799595L;
        private final GreaterThanOrEqualTo<R> lower;
        private final LessThanOrEqualTo<R> upper;

        Between(Expression<R, ?> expression, Expression<R, ?> lower, Expression<R, ?> upper) {
            this.lower = new GreaterThanOrEqualTo<R>(expression, lower, true, MatchAction.ANY);
            this.upper = new LessThanOrEqualTo<R>(expression, upper, true, MatchAction.ANY);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_BETWEEN;
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new Between<R>(effective[0], effective[1], effective[2]);
        }

        @Override
        public final Class<? super R> getResourceClass() {
            return Between.specializedClass(this.lower.getResourceClass(), this.upper.getResourceClass());
        }

        @Override
        protected Collection<?> getChildren() {
            return this.getExpressions();
        }

        @Override
        public List<Expression<R, ?>> getExpressions() {
            return List.of(this.getExpression(), this.getLowerBoundary(), this.getUpperBoundary());
        }

        @Override
        public Expression<R, ?> getExpression() {
            return ((ComparisonFilter)this.lower).expression1;
        }

        @Override
        public Expression<R, ?> getLowerBoundary() {
            return ((ComparisonFilter)this.lower).expression2;
        }

        @Override
        public Expression<R, ?> getUpperBoundary() {
            return ((ComparisonFilter)this.upper).expression2;
        }

        @Override
        public boolean test(R object) {
            return this.lower.test(object) && this.upper.test(object);
        }
    }

    static final class NotEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = -3295957142249035362L;

        NotEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new NotEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2260';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result != 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left != right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left != right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.NOT_EQUAL;
        }
    }

    static final class EqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8502612221498749667L;

        EqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new EqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result == 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left == right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left == right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.EQUAL;
        }
    }

    static final class GreaterThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 1514185657159141882L;

        GreaterThanOrEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new GreaterThanOrEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2265';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result >= 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left >= right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left >= right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.NOT_BEFORE;
        }
    }

    static final class GreaterThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8605517892232632586L;

        GreaterThan(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new GreaterThan<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result > 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left > right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left > right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.AFTER;
        }
    }

    static final class LessThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6357459227911760871L;

        LessThanOrEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new LessThanOrEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2264';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result <= 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left <= right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left <= right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.NOT_AFTER;
        }
    }

    static final class LessThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6126039112844823196L;

        LessThan(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new LessThan<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result < 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left < right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left < right);
        }

        @Override
        protected TimeMethods.Test temporalTest() {
            return TimeMethods.Test.BEFORE;
        }
    }
}

