/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.UnaryFunction;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

public final class ConvertFunction<R, S, V>
extends UnaryFunction<R, S>
implements FeatureExpression<R, V>,
Optimization.OnExpression<R, V> {
    private static final long serialVersionUID = 4686604324414717316L;
    private static final ScopedName NAME = ConvertFunction.createName("Convert");
    private final ObjectConverter<? super S, ? extends V> converter;

    public ConvertFunction(Expression<R, ? extends S> expression, Class<? extends S> source, Class<V> target) {
        super(expression);
        this.converter = ObjectConverters.find(source, target);
    }

    private ConvertFunction(ConvertFunction<R, S, V> original, Expression<R, ? extends S> expression) {
        super(expression);
        this.converter = original.converter;
    }

    @Override
    public Expression<R, V> recreate(Expression<R, ?>[] effective) {
        Expression<R, ?> e = effective[0];
        Class<?> result = ConvertFunction.getResultClass(e);
        if (result != null) {
            Class<V> target = this.getResultClass();
            if (target.isAssignableFrom(result)) {
                return e;
            }
            if (result != Object.class) {
                return new ConvertFunction(e, result, target);
            }
        }
        Class source = this.converter.getSourceClass();
        return new ConvertFunction(this, e.toValueType(source));
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return FunctionProperty.concatenate(ConvertFunction.properties(this.expression), (Set)this.converter.properties());
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(this.expression, this.converter.getSourceClass(), this.getResultClass());
    }

    @Override
    public V apply(R feature) {
        Object value = this.expression.apply(feature);
        try {
            return (V)this.converter.apply(value);
        }
        catch (UnconvertibleObjectException e) {
            this.warning((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public final Class<? extends V> getResultClass() {
        return this.converter.getTargetClass();
    }

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        FeatureExpression fex = FeatureExpression.castOrCopy(this.expression);
        if (fex == null) {
            return null;
        }
        FeatureProjectionBuilder.Item item = addTo.addTemplateProperty(fex);
        if (item != null) {
            item.replaceValueClass(c -> this.getResultClass());
        }
        return item;
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.getResultClass())) {
            return this;
        }
        Class source = this.converter.getSourceClass();
        if (target.isAssignableFrom(source)) {
            return this.expression;
        }
        try {
            return new ConvertFunction<R, S, N>(this.expression, source, target);
        }
        catch (UnconvertibleObjectException e) {
            throw (ClassCastException)new ClassCastException(Errors.format((short)12, (Object)this.expression.getFunctionName(), target)).initCause(e);
        }
    }
}

