/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.observation;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.observation.ClientObservationContext;
import com.linecorp.armeria.client.observation.HttpClientObservationDocumentation;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import java.net.InetSocketAddress;

class DefaultHttpClientObservationConvention
implements ObservationConvention<ClientObservationContext> {
    static final DefaultHttpClientObservationConvention INSTANCE = new DefaultHttpClientObservationConvention();

    DefaultHttpClientObservationConvention() {
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ClientObservationContext context) {
        ClientRequestContext ctx = context.requestContext();
        int expectedSize = 1;
        RequestLog log = (RequestLog)context.getResponse();
        KeyValue protocol = null;
        KeyValue serializationFormat = null;
        KeyValue statusCode = null;
        if (log != null) {
            protocol = HttpClientObservationDocumentation.LowCardinalityKeys.HTTP_PROTOCOL.withValue(DefaultHttpClientObservationConvention.protocol(log));
            statusCode = HttpClientObservationDocumentation.LowCardinalityKeys.STATUS_CODE.withValue(log.responseStatus().codeAsText());
            expectedSize = 3;
            String serFmt = DefaultHttpClientObservationConvention.serializationFormat(log);
            if (serFmt != null) {
                expectedSize = 4;
                serializationFormat = HttpClientObservationDocumentation.LowCardinalityKeys.HTTP_SERIALIZATION_FORMAT.withValue(serFmt);
            }
        }
        ImmutableList.Builder<KeyValue> builder = ImmutableList.builderWithExpectedSize(expectedSize);
        builder.add((Object)HttpClientObservationDocumentation.LowCardinalityKeys.HTTP_METHOD.withValue(ctx.method().name()));
        DefaultHttpClientObservationConvention.addIfNotNull(protocol, builder);
        DefaultHttpClientObservationConvention.addIfNotNull(statusCode, builder);
        DefaultHttpClientObservationConvention.addIfNotNull(serializationFormat, builder);
        return KeyValues.of(builder.build());
    }

    private static void addIfNotNull(@Nullable KeyValue keyValue, ImmutableList.Builder<KeyValue> builder) {
        if (keyValue != null) {
            builder.add((Object)keyValue);
        }
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(ClientObservationContext context) {
        ClientRequestContext ctx = context.requestContext();
        int expectedSize = 3;
        KeyValue addressRemote = null;
        KeyValue addressLocal = null;
        KeyValue error = null;
        if (context.getResponse() != null) {
            Throwable responseCause;
            InetSocketAddress laddr;
            RequestLog log = ctx.log().ensureComplete();
            InetSocketAddress raddr = ctx.remoteAddress();
            if (raddr != null) {
                ++expectedSize;
                addressRemote = HttpClientObservationDocumentation.HighCardinalityKeys.ADDRESS_REMOTE.withValue(raddr.toString());
            }
            if ((laddr = ctx.localAddress()) != null) {
                ++expectedSize;
                addressLocal = HttpClientObservationDocumentation.HighCardinalityKeys.ADDRESS_LOCAL.withValue(laddr.toString());
            }
            if ((responseCause = log.responseCause()) != null) {
                ++expectedSize;
                error = HttpClientObservationDocumentation.HighCardinalityKeys.ERROR.withValue(responseCause.toString());
            } else if (log.responseStatus().isError()) {
                ++expectedSize;
                error = HttpClientObservationDocumentation.HighCardinalityKeys.ERROR.withValue(log.responseStatus().codeAsText());
            }
        }
        ImmutableList.Builder<KeyValue> builder = ImmutableList.builderWithExpectedSize(expectedSize);
        builder.add(new KeyValue[]{HttpClientObservationDocumentation.HighCardinalityKeys.HTTP_PATH.withValue(ctx.path()), HttpClientObservationDocumentation.HighCardinalityKeys.HTTP_HOST.withValue(MoreObjects.firstNonNull(ctx.authority(), "UNKNOWN")), HttpClientObservationDocumentation.HighCardinalityKeys.HTTP_URL.withValue(ctx.uri().toString())});
        DefaultHttpClientObservationConvention.addIfNotNull(addressRemote, builder);
        DefaultHttpClientObservationConvention.addIfNotNull(addressLocal, builder);
        DefaultHttpClientObservationConvention.addIfNotNull(error, builder);
        return KeyValues.of(builder.build());
    }

    private static String protocol(RequestLog requestLog) {
        return requestLog.sessionProtocol().uriText();
    }

    @Nullable
    private static String serializationFormat(RequestLog requestLog) {
        SerializationFormat serFmt = requestLog.serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    @Override
    public String getName() {
        return "http.client.requests";
    }

    @Override
    public String getContextualName(ClientObservationContext context) {
        RequestLogAccess logAccess = context.requestContext().log();
        if (logAccess.isAvailable(RequestLogProperty.NAME)) {
            return logAccess.partial().fullName();
        }
        return context.getName();
    }

    @Override
    public boolean supportsContext(Observation.Context context) {
        return context instanceof ClientObservationContext;
    }
}

