/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.JFRProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IJFRDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBJFRDataQueryDAO
extends AbstractBanyanDBDAO
implements IJFRDataQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"task_id", (Object)"instance_id", (Object)"event_type", (Object)"upload_time", (Object)"data_binary");

    public BanyanDBJFRDataQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<JFRProfilingDataRecord> getByTaskIdAndInstancesAndEvent(final String taskId, final List<String> instanceIds, final String eventType) throws IOException {
        if (StringUtil.isBlank((String)taskId) || StringUtil.isBlank((String)eventType)) {
            return new ArrayList<JFRProfilingDataRecord>();
        }
        StreamQueryResponse resp = this.query(false, "jfr_profiling_data", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("task_id", taskId));
                query.and(this.eq("event_type", eventType));
                if (CollectionUtils.isNotEmpty((List)instanceIds)) {
                    query.and(this.in("instance_id", instanceIds));
                }
            }
        });
        ArrayList<JFRProfilingDataRecord> records = new ArrayList<JFRProfilingDataRecord>(resp.size());
        for (RowEntity entity : resp.getElements()) {
            records.add(this.buildProfilingDataRecord(entity));
        }
        return records;
    }

    private JFRProfilingDataRecord buildProfilingDataRecord(RowEntity entity) {
        JFRProfilingDataRecord.Builder builder = new JFRProfilingDataRecord.Builder();
        BanyanDBConverter.StorageToStream storageToStream = new BanyanDBConverter.StorageToStream("jfr_profiling_data", entity);
        return builder.storage2Entity((Convert2Entity)storageToStream);
    }
}

