/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class LatentDirichletAllocationExample$ {
    public static LatentDirichletAllocationExample$ MODULE$;

    static {
        new LatentDirichletAllocationExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LatentDirichletAllocationExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_lda_data.txt", sc.textFile$default$2());
        RDD parsedData = data.map((Function1 & Serializable & scala.Serializable)s -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(s.trim())).split(' '))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LatentDirichletAllocationExample$.$anonfun$main$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), ClassTag$.MODULE$.apply(Vector.class));
        RDD corpus = parsedData.zipWithIndex().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        LDAModel ldaModel = new LDA().setK(3).run(corpus);
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("Learned topics (as distributions over vocab of ").append(ldaModel.vocabSize()).append(" words):").toString());
        Matrix topics = ldaModel.topicsMatrix();
        package$.MODULE$.Range().apply(0, 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)topic -> {
            Predef$.MODULE$.print((Object)new StringBuilder(8).append("Topic ").append(topic).append(" :").toString());
            package$.MODULE$.Range().apply(0, ldaModel.vocabSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)word -> Predef$.MODULE$.print((Object)String.valueOf(BoxesRunTime.boxToDouble((double)topics.apply(word, topic)))));
            Predef$.MODULE$.println();
        });
        ldaModel.save(sc, "target/org/apache/spark/LatentDirichletAllocationExample/LDAModel");
        DistributedLDAModel sameModel = DistributedLDAModel$.MODULE$.load(sc, "target/org/apache/spark/LatentDirichletAllocationExample/LDAModel");
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$main$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    private LatentDirichletAllocationExample$() {
        MODULE$ = this;
    }
}

