/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnBetween;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterVarCharColumnBetweenDynamicValue
extends FilterVarCharColumnBetween {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilterVarCharColumnBetweenDynamicValue.class);
    protected DynamicValue leftDynamicValue;
    protected DynamicValue rightDynamicValue;
    protected transient boolean initialized = false;
    protected transient boolean isLeftOrRightNull = false;

    public FilterVarCharColumnBetweenDynamicValue(int colNum, DynamicValue leftValue, DynamicValue rightValue) {
        super(colNum, new HiveVarchar("", 1), new HiveVarchar("", 1));
        this.leftDynamicValue = leftValue;
        this.rightDynamicValue = rightValue;
    }

    public FilterVarCharColumnBetweenDynamicValue() {
    }

    public DynamicValue getLeftDynamicValue() {
        return this.leftDynamicValue;
    }

    public void setLeftDynamicValue(DynamicValue leftValue) {
        this.leftDynamicValue = leftValue;
    }

    public DynamicValue getRightDynamicValue() {
        return this.rightDynamicValue;
    }

    public void getRightDynamicValue(DynamicValue rightValue) {
        this.rightDynamicValue = rightValue;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.leftDynamicValue.setConf(conf);
        this.rightDynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (!this.initialized) {
            Object lVal = this.leftDynamicValue.getValue();
            Object rVal = this.rightDynamicValue.getValue();
            if (lVal == null || rVal == null) {
                this.isLeftOrRightNull = true;
            } else {
                byte[] min = PrimitiveObjectInspectorUtils.getHiveVarchar((Object)lVal, (PrimitiveObjectInspector)this.leftDynamicValue.getObjectInspector()).getValue().getBytes();
                this.setLeftValue(min);
                byte[] max = PrimitiveObjectInspectorUtils.getHiveVarchar((Object)rVal, (PrimitiveObjectInspector)this.rightDynamicValue.getObjectInspector()).getValue().getBytes();
                this.setRightValue(max);
            }
            this.initialized = true;
        }
        if (this.isLeftOrRightNull) {
            batch.size = 0;
        }
        super.evaluate(batch);
    }
}

