/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatsUtils.class.getName());

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, TableScanOperator tableScanOperator) throws HiveException {
        ArrayList<ColumnInfo> schema = tableScanOperator.getSchema().getSignature();
        List<String> neededColumns = tableScanOperator.getNeededColumns();
        List<String> referencedColumns = tableScanOperator.getReferencedColumns();
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, referencedColumns);
    }

    private static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns) throws HiveException {
        boolean fetchColStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean fetchPartStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_PARTITION_STATS);
        return StatsUtils.collectStatistics(conf, partList, table, schema, neededColumns, referencedColumns, fetchColStats, fetchPartStats);
    }

    private static long getDataSize(HiveConf conf, Table table) {
        long ds = StatsUtils.getRawDataSize(table);
        if (ds <= 0L) {
            ds = StatsUtils.getTotalSize(table);
            if (ds <= 0L) {
                ds = StatsUtils.getFileSizeForTable(conf, table);
            }
            float deserFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
            ds = (long)((float)ds * deserFactor);
        }
        return ds;
    }

    private static long getNumRows(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns, Table table, long ds) {
        int avgRowSize;
        long nr = StatsUtils.getNumRows(table);
        if (nr <= 0L && (avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns)) > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Estimated average row size: " + avgRowSize);
            }
            nr = ds / (long)avgRowSize;
        }
        return nr == 0L ? 1L : nr;
    }

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, List<ColumnInfo> schema, List<String> neededColumns, List<String> referencedColumns, boolean fetchColStats, boolean fetchPartStats) throws HiveException {
        Statistics stats = new Statistics();
        float deserFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        if (!table.isPartitioned()) {
            long ds = StatsUtils.getDataSize(conf, table);
            long nr = StatsUtils.getNumRows(conf, schema, neededColumns, table, ds);
            stats.setNumRows(nr);
            List<Object> colStats = Lists.newArrayList();
            if (fetchColStats) {
                colStats = StatsUtils.getTableColumnStats(table, schema, neededColumns);
                long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, (List<ColStatistics>)colStats);
                ds = betterDS < 1L || colStats.isEmpty() ? ds : betterDS;
            }
            stats.setDataSize(ds);
            StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), (List<ColStatistics>)colStats);
            stats.setColumnStatsState(StatsUtils.deriveStatType((List<ColStatistics>)colStats, neededColumns));
            stats.addToColumnStats(colStats);
        } else if (partList != null) {
            long nr = 0L;
            long ds = 0L;
            List<Object> rowCounts = Lists.newArrayList();
            List<Object> dataSizes = Lists.newArrayList();
            if (fetchPartStats) {
                rowCounts = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "numRows");
                dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "rawDataSize");
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (ds <= 0L) {
                    dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "totalSize");
                    ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                }
            }
            if (ds <= 0L) {
                dataSizes = StatsUtils.getFileSizeForPartitions(conf, partList.getNotDeniedPartns());
            }
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            ds = (long)((float)ds * deserFactor);
            int avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns);
            if (avgRowSize > 0) {
                StatsUtils.setUnknownRcDsToAverage(rowCounts, dataSizes, avgRowSize);
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (nr <= 0L) {
                    nr = ds / (long)avgRowSize;
                }
            }
            if (nr == 0L) {
                nr = 1L;
            }
            stats.addToNumRows(nr);
            stats.addToDataSize(ds);
            if (StatsUtils.containsNonPositives(rowCounts) && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE)) {
                stats.setBasicStatsState(Statistics.State.PARTIAL);
            }
            if (fetchColStats) {
                ArrayList<String> partNames = new ArrayList<String>(partList.getNotDeniedPartns().size());
                for (Partition part : partList.getNotDeniedPartns()) {
                    partNames.add(part.getName());
                }
                neededColumns = StatsUtils.processNeededColumns(schema, neededColumns);
                AggrStats aggrStats = null;
                if (neededColumns.size() > 0 && partNames.size() > 0) {
                    aggrStats = Hive.get().getAggrColStatsFor(table.getDbName(), table.getTableName(), neededColumns, partNames);
                }
                if (null == aggrStats || null == aggrStats.getColStats() || aggrStats.getColStatsSize() == 0) {
                    ArrayList emptyStats = Lists.newArrayList();
                    StatsUtils.addParitionColumnStats(conf, neededColumns, referencedColumns, schema, table, partList, emptyStats);
                    stats.addToColumnStats(emptyStats);
                    stats.addToDataSize(StatsUtils.getDataSizeFromColumnStats(nr, emptyStats));
                    stats.updateColumnStatsState(StatsUtils.deriveStatType(emptyStats, referencedColumns));
                } else {
                    List colStats = aggrStats.getColStats();
                    if (colStats.size() != neededColumns.size()) {
                        LOG.debug("Column stats requested for : " + neededColumns.size() + " columns. Able to retrieve for " + colStats.size() + " columns");
                    }
                    List<ColStatistics> columnStats = StatsUtils.convertColStats(colStats, table.getTableName());
                    StatsUtils.addParitionColumnStats(conf, neededColumns, referencedColumns, schema, table, partList, columnStats);
                    long betterDS = StatsUtils.getDataSizeFromColumnStats(nr, columnStats);
                    stats.setDataSize(betterDS < 1L || columnStats.isEmpty() ? ds : betterDS);
                    StatsUtils.inferAndSetPrimaryKey(stats.getNumRows(), columnStats);
                    stats.addToColumnStats(columnStats);
                    Statistics.State colState = StatsUtils.deriveStatType(columnStats, referencedColumns);
                    if (aggrStats.getPartsFound() != (long)partNames.size() && colState != Statistics.State.NONE) {
                        LOG.debug("Column stats requested for : " + partNames.size() + " partitions. Able to retrieve for " + aggrStats.getPartsFound() + " partitions");
                        colState = Statistics.State.PARTIAL;
                    }
                    stats.setColumnStatsState(colState);
                }
            }
        }
        return stats;
    }

    public static void inferAndSetPrimaryKey(long numRows, List<ColStatistics> colStats) {
        if (colStats != null) {
            for (ColStatistics cs : colStats) {
                if (cs != null && cs.getCountDistint() >= numRows) {
                    cs.setPrimaryKey(true);
                    continue;
                }
                if (cs == null || cs.getRange() == null || cs.getRange().minValue == null || cs.getRange().maxValue == null || numRows != cs.getRange().maxValue.longValue() - cs.getRange().minValue.longValue() + 1L) continue;
                cs.setPrimaryKey(true);
            }
        }
    }

    public static boolean inferForeignKey(ColStatistics csPK, ColStatistics csFK) {
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            ColStatistics.Range pkRange = csPK.getRange();
            ColStatistics.Range fkRange = csFK.getRange();
            return StatsUtils.isWithin(fkRange, pkRange);
        }
        return false;
    }

    public static float getScaledSelectivity(ColStatistics csPK, ColStatistics csFK) {
        float scaledSelectivity = 1.0f;
        if (csPK != null && csFK != null && csPK.isPrimaryKey() && csPK.getRange() != null && csFK.getRange() != null) {
            long pkRangeDelta = StatsUtils.getRangeDelta(csPK.getRange());
            long fkRangeDelta = StatsUtils.getRangeDelta(csFK.getRange());
            if (fkRangeDelta > 0L && pkRangeDelta > 0L && fkRangeDelta < pkRangeDelta) {
                scaledSelectivity = (float)pkRangeDelta / (float)fkRangeDelta;
            }
        }
        return scaledSelectivity;
    }

    public static long getRangeDelta(ColStatistics.Range range) {
        if (range.minValue != null && range.maxValue != null) {
            return range.maxValue.longValue() - range.minValue.longValue();
        }
        return 0L;
    }

    private static boolean isWithin(ColStatistics.Range range1, ColStatistics.Range range2) {
        return range1.minValue != null && range2.minValue != null && range1.maxValue != null && range2.maxValue != null && range1.minValue.longValue() >= range2.minValue.longValue() && range1.maxValue.longValue() <= range2.maxValue.longValue();
    }

    private static void addParitionColumnStats(HiveConf conf, List<String> neededColumns, List<String> referencedColumns, List<ColumnInfo> schema, Table table, PrunedPartitionList partList, List<ColStatistics> colStats) throws HiveException {
        ArrayList extraCols = Lists.newArrayList(referencedColumns);
        if (referencedColumns.size() > neededColumns.size()) {
            extraCols.removeAll(neededColumns);
            for (String col : extraCols) {
                for (ColumnInfo ci : schema) {
                    if (!col.equals(ci.getInternalName()) || !ci.getIsVirtualCol() || ci.isHiddenVirtualCol()) continue;
                    colStats.add(StatsUtils.getColStatsForPartCol(ci, new PartitionIterable(partList.getPartitions()), conf));
                }
            }
        }
    }

    public static ColStatistics getColStatsForPartCol(ColumnInfo ci, PartitionIterable partList, HiveConf conf) {
        ColStatistics partCS = new ColStatistics(ci.getInternalName(), ci.getType().getTypeName());
        long numPartitions = StatsUtils.getNDVPartitionColumn(partList, ci.getInternalName());
        partCS.setCountDistint(numPartitions);
        partCS.setAvgColLen(StatsUtils.getAvgColLenOf(conf, ci.getObjectInspector(), partCS.getColumnType()));
        partCS.setRange(StatsUtils.getRangePartitionColumn(partList, ci.getInternalName(), ci.getType().getTypeName(), conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME)));
        return partCS;
    }

    public static int getNDVPartitionColumn(PartitionIterable partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>();
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    private static ColStatistics.Range getRangePartitionColumn(PartitionIterable partitions, String partColName, String colType, String defaultPartName) {
        ColStatistics.Range range = null;
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint")) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                long value = Long.parseLong(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else if (colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                double value = Double.parseDouble(partVal);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else if (colTypeLowerCase.startsWith("decimal")) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Partition partition : partitions) {
                String partVal = partition.getSpec().get(partColName);
                if (partVal.equals(defaultPartName)) continue;
                double value = new BigDecimal(partVal).doubleValue();
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            range = new ColStatistics.Range(min, max);
        } else {
            return null;
        }
        return range;
    }

    private static void setUnknownRcDsToAverage(List<Long> rowCounts, List<Long> dataSizes, int avgRowSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Estimated average row size: " + avgRowSize);
        }
        for (int i = 0; i < rowCounts.size(); ++i) {
            long rc = rowCounts.get(i);
            long s = dataSizes.get(i);
            if (rc <= 0L && s > 0L) {
                rc = s / (long)avgRowSize;
                rowCounts.set(i, rc);
            }
            if (s > 0L || rc <= 0L) continue;
            s = StatsUtils.safeMult(rc, avgRowSize);
            dataSizes.set(i, s);
        }
    }

    public static int estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns) {
        int avgRowSize = 0;
        for (String neededCol : neededColumns) {
            ColumnInfo ci = StatsUtils.getColumnInfoForColumn(neededCol, schema);
            if (ci == null) continue;
            ObjectInspector oi = ci.getObjectInspector();
            String colTypeLowerCase = ci.getTypeName().toLowerCase();
            if (colTypeLowerCase.equals("string") || colTypeLowerCase.equals("binary") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("array") || colTypeLowerCase.startsWith("map") || colTypeLowerCase.startsWith("struct") || colTypeLowerCase.startsWith("uniontype")) {
                avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase));
                continue;
            }
            avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase));
        }
        return avgRowSize;
    }

    private static ColumnInfo getColumnInfoForColumn(String neededCol, List<ColumnInfo> schema) {
        for (ColumnInfo ci : schema) {
            if (!ci.getInternalName().equalsIgnoreCase(neededCol)) continue;
            return ci;
        }
        return null;
    }

    public static long getFileSizeForTable(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = fs.getContentSummary(path).getLength();
        }
        catch (Exception e) {
            size = 0L;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getFileSizeForPartitions(final HiveConf conf, List<Partition> parts) {
        LOG.info("Number of partitions : " + parts.size());
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        int threads = Math.max(1, conf.getIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT));
        ExecutorService pool = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Partitions-Size-%d").build());
        ArrayList<Long> sizes = new ArrayList<Long>(parts.size());
        for (Partition part : parts) {
            final Path path = part.getDataLocation();
            futures.add(pool.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    try {
                        LOG.debug("Partition path : " + path);
                        FileSystem fs = path.getFileSystem((Configuration)conf);
                        return fs.getContentSummary(path).getLength();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }
            }));
        }
        try {
            for (int i = 0; i < futures.size(); ++i) {
                sizes.add(i, (Long)((Future)futures.get(i)).get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Exception in processing files ", (Throwable)e);
        }
        finally {
            pool.shutdownNow();
        }
        return sizes;
    }

    private static boolean containsNonPositives(List<Long> vals) {
        for (Long val : vals) {
            if (val > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getSumIgnoreNegatives(List<Long> vals) {
        long result = 0L;
        for (Long l : vals) {
            if (l <= 0L) continue;
            result = StatsUtils.safeAdd(result, l);
        }
        return result;
    }

    private static Statistics.State deriveStatType(List<ColStatistics> colStats, List<String> neededColumns) {
        boolean hasNull;
        boolean hasStats = false;
        boolean bl = hasNull = colStats == null || colStats.size() < neededColumns.size();
        if (colStats != null) {
            ColStatistics cs;
            boolean isNull;
            Iterator<ColStatistics> iterator = colStats.iterator();
            while (!(!iterator.hasNext() || (hasNull |= (isNull = (cs = iterator.next()) == null)) && (hasStats |= !isNull))) {
            }
        }
        Statistics.State result = hasStats ? (hasNull ? Statistics.State.PARTIAL : Statistics.State.COMPLETE) : (neededColumns.isEmpty() ? Statistics.State.COMPLETE : Statistics.State.NONE);
        return result;
    }

    public static ColStatistics getColStatistics(ColumnStatisticsObj cso, String tabName, String colName) {
        String colTypeLowerCase = cso.getColType().toLowerCase();
        ColStatistics cs = new ColStatistics(colName, colTypeLowerCase);
        ColumnStatisticsData csd = cso.getStatsData();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("bigint")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getLongStats().getLowValue(), csd.getLongStats().getHighValue());
        } else if (colTypeLowerCase.equals("float")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("double")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
            cs.setRange(csd.getDoubleStats().getLowValue(), csd.getDoubleStats().getHighValue());
        } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("char") || colTypeLowerCase.startsWith("varchar")) {
            cs.setCountDistint(csd.getStringStats().getNumDVs());
            cs.setNumNulls(csd.getStringStats().getNumNulls());
            cs.setAvgColLen(csd.getStringStats().getAvgColLen());
        } else if (colTypeLowerCase.equals("boolean")) {
            if (csd.getBooleanStats().getNumFalses() > 0L && csd.getBooleanStats().getNumTrues() > 0L) {
                cs.setCountDistint(2L);
            } else {
                cs.setCountDistint(1L);
            }
            cs.setNumTrues(csd.getBooleanStats().getNumTrues());
            cs.setNumFalses(csd.getBooleanStats().getNumFalses());
            cs.setNumNulls(csd.getBooleanStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colTypeLowerCase.equals("binary")) {
            cs.setAvgColLen(csd.getBinaryStats().getAvgColLen());
            cs.setNumNulls(csd.getBinaryStats().getNumNulls());
        } else if (colTypeLowerCase.equals("timestamp")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colTypeLowerCase.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
            cs.setCountDistint(csd.getDecimalStats().getNumDVs());
            cs.setNumNulls(csd.getDecimalStats().getNumNulls());
            Decimal highValue = csd.getDecimalStats().getHighValue();
            Decimal lowValue = csd.getDecimalStats().getLowValue();
            if (highValue != null && highValue.getUnscaled() != null && lowValue != null && lowValue.getUnscaled() != null) {
                BigDecimal minVal;
                HiveDecimal maxHiveDec = HiveDecimal.create((BigInteger)new BigInteger(highValue.getUnscaled()), (int)highValue.getScale());
                BigDecimal maxVal = maxHiveDec == null ? null : maxHiveDec.bigDecimalValue();
                HiveDecimal minHiveDec = HiveDecimal.create((BigInteger)new BigInteger(lowValue.getUnscaled()), (int)lowValue.getScale());
                BigDecimal bigDecimal = minVal = minHiveDec == null ? null : minHiveDec.bigDecimalValue();
                if (minVal != null && maxVal != null) {
                    cs.setRange(minVal, maxVal);
                }
            }
        } else if (colTypeLowerCase.equals("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
            cs.setNumNulls(csd.getDateStats().getNumNulls());
            Long lowVal = csd.getDateStats().getLowValue() != null ? Long.valueOf(csd.getDateStats().getLowValue().getDaysSinceEpoch()) : null;
            Long highVal = csd.getDateStats().getHighValue() != null ? Long.valueOf(csd.getDateStats().getHighValue().getDaysSinceEpoch()) : null;
            cs.setRange(lowVal, highVal);
        } else {
            return null;
        }
        return cs;
    }

    public static List<ColStatistics> getTableColumnStats(Table table, List<ColumnInfo> schema, List<String> neededColumns) {
        if (table.isMaterializedTable()) {
            LOG.debug("Materialized table does not contain table statistics");
            return null;
        }
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        List<String> neededColsInTable = StatsUtils.processNeededColumns(schema, neededColumns);
        List<ColStatistics> stats = null;
        try {
            List<ColumnStatisticsObj> colStat = Hive.get().getTableColumnStatistics(dbName, tabName, neededColsInTable);
            stats = StatsUtils.convertColStats(colStat, tabName);
        }
        catch (HiveException e) {
            LOG.error("Failed to retrieve table statistics: ", (Throwable)e);
            stats = null;
        }
        return stats;
    }

    private static List<ColStatistics> convertColStats(List<ColumnStatisticsObj> colStats, String tabName) {
        if (colStats == null) {
            return new ArrayList<ColStatistics>();
        }
        ArrayList<ColStatistics> stats = new ArrayList<ColStatistics>(colStats.size());
        for (ColumnStatisticsObj statObj : colStats) {
            ColStatistics cs = StatsUtils.getColStatistics(statObj, tabName, statObj.getColName());
            if (cs == null) continue;
            stats.add(cs);
        }
        return stats;
    }

    private static List<String> processNeededColumns(List<ColumnInfo> schema, List<String> neededColumns) {
        List neededColsInTable = null;
        int limit = neededColumns.size();
        for (int i = 0; i < limit; --limit, ++i) {
            if (neededColsInTable == null) {
                neededColsInTable = Lists.newArrayList(neededColumns);
            }
            neededColsInTable.remove(i--);
        }
        return neededColsInTable == null || neededColsInTable.size() == 0 ? neededColumns : neededColsInTable;
    }

    public static long getAvgColLenOf(HiveConf conf, ObjectInspector oi, String colType) {
        long configVarLen = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
        String colTypeLowCase = colType.toLowerCase();
        if (colTypeLowCase.equals("string")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof StringObjectInspector) {
                return configVarLen;
            }
        } else if (colTypeLowCase.startsWith("varchar")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveVarcharObjectInspector) {
                VarcharTypeInfo type = (VarcharTypeInfo)((HiveVarcharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.startsWith("char")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                Object constantValue = coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.toString().length();
            }
            if (oi instanceof HiveCharObjectInspector) {
                CharTypeInfo type = (CharTypeInfo)((HiveCharObjectInspector)oi).getTypeInfo();
                return type.getLength();
            }
        } else if (colTypeLowCase.equals("binary")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                BytesWritable constantValue = (BytesWritable)coi.getWritableConstantValue();
                return constantValue == null ? 0L : (long)constantValue.getLength();
            }
            if (oi instanceof BinaryObjectInspector) {
                return configVarLen;
            }
        } else {
            return StatsUtils.getSizeOfComplexTypes(conf, oi);
        }
        throw new IllegalArgumentException("Size requested for unknown type: " + colType + " OI: " + oi.getTypeName());
    }

    public static long getSizeOfComplexTypes(HiveConf conf, ObjectInspector oi) {
        long result = 0L;
        int length = 0;
        int listEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_LIST_NUM_ENTRIES);
        int mapEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAP_NUM_ENTRIES);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String colTypeLowerCase = oi.getTypeName().toLowerCase();
                if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForStringOfLength(avgColLen);
                    break;
                }
                if (colTypeLowerCase.equals("binary")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOf(conf, oi, colTypeLowerCase);
                    result += (long)JavaDataModel.get().lengthForByteArrayOfSize(avgColLen);
                    break;
                }
                result += StatsUtils.getAvgColLenOfFixedLengthTypes(colTypeLowerCase);
                break;
            }
            case LIST: {
                if (oi instanceof StandardConstantListObjectInspector) {
                    StandardConstantListObjectInspector scloi = (StandardConstantListObjectInspector)oi;
                    length = scloi.getWritableConstantValue().size();
                    ObjectInspector leoi = scloi.getListElementObjectInspector();
                    if (leoi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
                        result += StatsUtils.getSizeOfPrimitiveTypeArraysFromType(leoi.getTypeName(), length);
                        break;
                    }
                    result += (long)JavaDataModel.get().lengthForObjectArrayOfSize(length);
                    break;
                }
                StandardListObjectInspector sloi = (StandardListObjectInspector)oi;
                long elemSize = StatsUtils.getSizeOfComplexTypes(conf, sloi.getListElementObjectInspector());
                result += (long)JavaDataModel.get().arrayList() + (long)listEntries * elemSize;
                break;
            }
            case MAP: {
                if (oi instanceof StandardConstantMapObjectInspector) {
                    StandardConstantMapObjectInspector scmoi = (StandardConstantMapObjectInspector)oi;
                    result += StatsUtils.getSizeOfMap(scmoi);
                    break;
                }
                StandardMapObjectInspector smoi = (StandardMapObjectInspector)oi;
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapKeyObjectInspector());
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapValueObjectInspector());
                result += (long)JavaDataModel.get().hashMap(mapEntries);
                break;
            }
            case STRUCT: {
                if (oi instanceof StandardConstantStructObjectInspector) {
                    StandardConstantStructObjectInspector scsoi = (StandardConstantStructObjectInspector)oi;
                    result += StatsUtils.getSizeOfStruct(scsoi);
                    break;
                }
                StructObjectInspector soi = (StructObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
                for (StructField field : soi.getAllStructFieldRefs()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, field.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(uoi.getObjectInspectors().size() * JavaDataModel.get().primitive1());
                for (ObjectInspector foi : uoi.getObjectInspectors()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, foi);
                }
                break;
            }
        }
        return result;
    }

    public static long getAvgColLenOfFixedLengthTypes(String colType) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("void") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().primitive1();
        }
        if (colTypeLowerCase.equals("double") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("interval_year_month") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().primitive2();
        }
        if (colTypeLowerCase.equals("timestamp")) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (colTypeLowerCase.equals("interval_day_time")) {
            return 12L;
        }
        throw new IllegalArgumentException("Size requested for unknown type: " + colType);
    }

    public static long getSizeOfPrimitiveTypeArraysFromType(String colType, int length) {
        String colTypeLowerCase = colType.toLowerCase();
        if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("float")) {
            return JavaDataModel.get().lengthForIntArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("double")) {
            return JavaDataModel.get().lengthForDoubleArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("long")) {
            return JavaDataModel.get().lengthForLongArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("binary")) {
            return JavaDataModel.get().lengthForByteArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("boolean")) {
            return JavaDataModel.get().lengthForBooleanArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("timestamp")) {
            return JavaDataModel.get().lengthForTimestampArrayOfSize(length);
        }
        if (colTypeLowerCase.equals("date")) {
            return JavaDataModel.get().lengthForDateArrayOfSize(length);
        }
        if (colTypeLowerCase.startsWith("decimal")) {
            return JavaDataModel.get().lengthForDecimalArrayOfSize(length);
        }
        return 0L;
    }

    public static long getSizeOfMap(StandardConstantMapObjectInspector scmoi) {
        Map map = scmoi.getWritableConstantValue();
        ObjectInspector koi = scmoi.getMapKeyObjectInspector();
        ObjectInspector voi = scmoi.getMapValueObjectInspector();
        long result = 0L;
        for (Map.Entry entry : map.entrySet()) {
            result += StatsUtils.getWritableSize(koi, entry.getKey());
            result += StatsUtils.getWritableSize(voi, entry.getValue());
        }
        return result += (long)JavaDataModel.get().hashMap(map.entrySet().size());
    }

    public static long getSizeOfStruct(StandardConstantStructObjectInspector soi) {
        long result = 0L;
        result += (long)JavaDataModel.get().object();
        result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
        List value = soi.getWritableConstantValue();
        List fields = soi.getAllStructFieldRefs();
        if (value == null || value.size() != fields.size()) {
            return result;
        }
        for (int i = 0; i < fields.size(); ++i) {
            result += StatsUtils.getWritableSize(((StructField)fields.get(i)).getFieldObjectInspector(), value.get(i));
        }
        return result;
    }

    public static long getWritableSize(ObjectInspector oi, Object value) {
        if (oi instanceof WritableStringObjectInspector) {
            WritableStringObjectInspector woi = (WritableStringObjectInspector)oi;
            return JavaDataModel.get().lengthForStringOfLength(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBinaryObjectInspector) {
            WritableBinaryObjectInspector woi = (WritableBinaryObjectInspector)oi;
            return JavaDataModel.get().lengthForByteArrayOfSize(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBooleanObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableByteObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableDateObjectInspector) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (oi instanceof WritableDoubleObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableFloatObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableHiveDecimalObjectInspector) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (oi instanceof WritableIntObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableLongObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableShortObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableTimestampObjectInspector) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        return 0L;
    }

    public static List<ColStatistics> getColStatisticsFromExprMap(HiveConf conf, Statistics parentStats, Map<String, ExprNodeDesc> colExprMap, RowSchema rowSchema) {
        ArrayList cs = Lists.newArrayList();
        if (colExprMap != null && rowSchema != null) {
            for (ColumnInfo columnInfo : rowSchema.getSignature()) {
                String outColName = columnInfo.getInternalName();
                ExprNodeDesc end = colExprMap.get(outColName);
                ColStatistics colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end);
                if (colStat == null) continue;
                colStat.setColumnName(outColName);
                cs.add(colStat);
            }
            for (Map.Entry entry : colExprMap.entrySet()) {
                ColStatistics colStat;
                if (rowSchema.getColumnInfo((String)entry.getKey()) != null || (colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, (ExprNodeDesc)entry.getValue())) == null) continue;
                colStat.setColumnName((String)entry.getKey());
                cs.add(colStat);
            }
            return cs;
        }
        if ((colExprMap == null || rowSchema == null) && parentStats.getColumnStats() != null) {
            cs.addAll(parentStats.getColumnStats());
        }
        return cs;
    }

    public static List<ColStatistics> getColStatisticsUpdatingTableAlias(Statistics parentStats, RowSchema rowSchema) {
        ArrayList cs = Lists.newArrayList();
        for (ColStatistics parentColStat : parentStats.getColumnStats()) {
            ColStatistics colStat;
            try {
                colStat = parentColStat.clone();
            }
            catch (CloneNotSupportedException e) {
                colStat = null;
            }
            if (colStat == null) continue;
            cs.add(colStat);
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColStatistics getColStatisticsFromExpression(HiveConf conf, Statistics parentStats, ExprNodeDesc end) {
        ObjectInspector oi;
        long numNulls;
        long countDistincts;
        double avgColSize;
        String colType;
        String colName;
        block22: {
            ExprNodeDesc encd;
            if (end == null) {
                return null;
            }
            colName = null;
            colType = null;
            avgColSize = 0.0;
            countDistincts = 0L;
            numNulls = 0L;
            oi = end.getWritableObjectInspector();
            long numRows = parentStats.getNumRows();
            if (end instanceof ExprNodeColumnDesc) {
                encd = (ExprNodeColumnDesc)end;
                colName = ((ExprNodeColumnDesc)encd).getColumn();
                if (((ExprNodeColumnDesc)encd).getIsPartitionColOrVirtualCol()) {
                    ColStatistics colStats = parentStats.getColumnStatisticsFromColName(colName);
                    if (colStats != null) {
                        try {
                            return colStats.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            return null;
                        }
                    }
                    colType = encd.getTypeInfo().getTypeName();
                    countDistincts = numRows;
                    break block22;
                } else {
                    ColStatistics result = parentStats.getColumnStatisticsFromColName(colName);
                    if (result == null) {
                        return null;
                    }
                    try {
                        return result.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        return null;
                    }
                }
            }
            if (end instanceof ExprNodeConstantDesc) {
                encd = (ExprNodeConstantDesc)end;
                colName = encd.getName();
                colType = encd.getTypeString();
                if (((ExprNodeConstantDesc)encd).getValue() == null) {
                    numNulls = numRows;
                } else {
                    countDistincts = 1L;
                }
            } else if (end instanceof ExprNodeGenericFuncDesc) {
                ColStatistics stats;
                ExprNodeGenericFuncDesc engfd = (ExprNodeGenericFuncDesc)end;
                colName = engfd.getName();
                colType = engfd.getTypeString();
                if (StatsUtils.isWideningCast(engfd) && engfd.getChildren().get(0) instanceof ExprNodeColumnDesc && (stats = parentStats.getColumnStatisticsFromColName(engfd.getCols().get(0))) != null) {
                    ColStatistics newStats;
                    try {
                        newStats = stats.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        LOG.warn("error cloning stats, this should not happen");
                        return null;
                    }
                    newStats.setColumnName(colName);
                    colType = colType.toLowerCase();
                    newStats.setColumnType(colType);
                    newStats.setAvgColLen(StatsUtils.getAvgColLenOf(conf, oi, colType));
                    return newStats;
                }
                countDistincts = StatsUtils.getNDVFor(engfd, numRows, parentStats);
            } else if (end instanceof ExprNodeColumnListDesc) {
                encd = (ExprNodeColumnListDesc)end;
                colName = Joiner.on((String)",").join(((ExprNodeColumnListDesc)encd).getCols());
                colType = "array";
                countDistincts = numRows;
            } else {
                if (!(end instanceof ExprNodeFieldDesc)) {
                    throw new IllegalArgumentException("not supported expr type " + end.getClass());
                }
                ExprNodeFieldDesc enfd = (ExprNodeFieldDesc)end;
                colName = enfd.getFieldName();
                colType = enfd.getTypeString();
                countDistincts = numRows;
            }
        }
        colType = colType.toLowerCase();
        avgColSize = StatsUtils.getAvgColLenOf(conf, oi, colType);
        ColStatistics colStats = new ColStatistics(colName, colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        return colStats;
    }

    private static boolean isWideningCast(ExprNodeGenericFuncDesc engfd) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isOpCast(udf)) {
            return false;
        }
        return TypeInfoUtils.implicitConvertible((TypeInfo)engfd.getChildren().get(0).getTypeInfo(), (TypeInfo)engfd.getTypeInfo());
    }

    public static Long addWithExpDecay(List<Long> distinctVals) {
        Collections.sort(distinctVals, Collections.reverseOrder());
        long denom = distinctVals.get(0);
        for (int i = 1; i < distinctVals.size(); ++i) {
            denom = (long)((double)denom * Math.pow(distinctVals.get(i).longValue(), 1.0 / (double)(1 << i)));
        }
        return denom;
    }

    private static long getNDVFor(ExprNodeGenericFuncDesc engfd, long numRows, Statistics parentStats) {
        GenericUDF udf = engfd.getGenericUDF();
        if (!FunctionRegistry.isDeterministic(udf)) {
            return numRows;
        }
        ArrayList ndvs = Lists.newArrayList();
        Class<Object> udfClass = udf instanceof GenericUDFBridge ? ((GenericUDFBridge)udf).getUdfClass() : udf.getClass();
        NDV ndv = (NDV)AnnotationUtils.getAnnotation(udfClass, NDV.class);
        long udfNDV = Long.MAX_VALUE;
        if (ndv != null) {
            udfNDV = ndv.maxNdv();
        } else {
            for (String col : engfd.getCols()) {
                ColStatistics stats = parentStats.getColumnStatisticsFromColName(col);
                if (stats == null) continue;
                ndvs.add(stats.getCountDistint());
            }
        }
        long countDistincts = ndvs.isEmpty() ? numRows : StatsUtils.addWithExpDecay(ndvs);
        return (Long)Collections.min(Lists.newArrayList((Object[])new Long[]{countDistincts, udfNDV, numRows}));
    }

    public static long getNumRows(Table table) {
        return StatsUtils.getBasicStatForTable(table, "numRows");
    }

    public static long getRawDataSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "rawDataSize");
    }

    public static long getTotalSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "totalSize");
    }

    public static long getBasicStatForTable(Table table, String statType) {
        Map<String, String> params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }

    public static List<Long> getBasicStatForPartitions(Table table, List<Partition> parts, String statType) {
        ArrayList stats = Lists.newArrayList();
        for (Partition part : parts) {
            Map<String, String> params = part.getParameters();
            long result = 0L;
            if (params == null) continue;
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
            stats.add(result);
        }
        return stats;
    }

    public static long getDataSizeFromColumnStats(long numRows, List<ColStatistics> colStats) {
        long result = 0L;
        if (numRows <= 0L || colStats == null) {
            return result;
        }
        if (colStats.isEmpty()) {
            return numRows * 8L;
        }
        for (ColStatistics cs : colStats) {
            int acl;
            if (cs == null) continue;
            String colTypeLowerCase = cs.getColumnType().toLowerCase();
            long nonNullCount = cs.getNumNulls() > 0L ? numRows - cs.getNumNulls() + 1L : numRows;
            double sizeOf = 0.0;
            if (colTypeLowerCase.equals("tinyint") || colTypeLowerCase.equals("smallint") || colTypeLowerCase.equals("int") || colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("boolean") || colTypeLowerCase.equals("float") || colTypeLowerCase.equals("double")) {
                sizeOf = cs.getAvgColLen();
            } else if (colTypeLowerCase.equals("string") || colTypeLowerCase.startsWith("varchar") || colTypeLowerCase.startsWith("char")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForStringOfLength(acl);
            } else if (colTypeLowerCase.equals("binary")) {
                acl = (int)Math.round(cs.getAvgColLen());
                sizeOf = JavaDataModel.get().lengthForByteArrayOfSize(acl);
            } else {
                sizeOf = colTypeLowerCase.equals("timestamp") ? (double)JavaDataModel.get().lengthOfTimestamp() : (colTypeLowerCase.startsWith("decimal") ? (double)JavaDataModel.get().lengthOfDecimal() : (colTypeLowerCase.equals("date") ? (double)JavaDataModel.get().lengthOfDate() : cs.getAvgColLen()));
            }
            result = StatsUtils.safeAdd(result, StatsUtils.safeMult(nonNullCount, sizeOf));
        }
        return result;
    }

    public static String getFullyQualifiedTableName(String dbName, String tabName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName);
    }

    private static String getFullyQualifiedName(String ... names) {
        ArrayList nonNullAndEmptyNames = Lists.newArrayList();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            nonNullAndEmptyNames.add(name);
        }
        return Joiner.on((String)".").join((Iterable)nonNullAndEmptyNames);
    }

    public static List<String> getQualifedReducerKeyNames(List<String> keyExprs) {
        ArrayList result = Lists.newArrayList();
        if (keyExprs != null) {
            for (String key : keyExprs) {
                result.add(Utilities.ReduceField.KEY.toString() + "." + key);
            }
        }
        return result;
    }

    public static long getAvailableMemory(Configuration conf) {
        int memory = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE);
        if (memory <= 0 && (memory = conf.getInt("mapreduce.map.memory.mb", 1024)) <= 0) {
            memory = 1024;
        }
        return memory;
    }

    public static long getMaxIfOverflow(long val) {
        return val < 0L ? Long.MAX_VALUE : val;
    }

    public static long safeMult(long a, double b) {
        double result = (double)a * b;
        return result > 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    public static long safeAdd(long a, long b) {
        try {
            return LongMath.checkedAdd((long)a, (long)b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static long safeMult(long a, long b) {
        try {
            return LongMath.checkedMultiply((long)a, (long)b);
        }
        catch (ArithmeticException ex) {
            return Long.MAX_VALUE;
        }
    }

    public static int getNumBitVectorsForNDVEstimation(HiveConf conf) throws SemanticException {
        int numBitVectors;
        float percentageError = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_NDV_ERROR);
        if ((double)percentageError < 0.0) {
            throw new SemanticException("hive.stats.ndv.error can't be negative");
        }
        if ((double)percentageError <= 2.4) {
            numBitVectors = 1024;
            LOG.info("Lowest error achievable is 2.4% but error requested is " + percentageError + "%");
            LOG.info("Choosing 1024 bit vectors..");
        } else if ((double)percentageError <= 3.4) {
            numBitVectors = 1024;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 1024 bit vectors..");
        } else if ((double)percentageError <= 4.8) {
            numBitVectors = 512;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 512 bit vectors..");
        } else if ((double)percentageError <= 6.8) {
            numBitVectors = 256;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 256 bit vectors..");
        } else if ((double)percentageError <= 9.7) {
            numBitVectors = 128;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 128 bit vectors..");
        } else if ((double)percentageError <= 13.8) {
            numBitVectors = 64;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 64 bit vectors..");
        } else if ((double)percentageError <= 19.6) {
            numBitVectors = 32;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 32 bit vectors..");
        } else if ((double)percentageError <= 28.2) {
            numBitVectors = 16;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 16 bit vectors..");
        } else if ((double)percentageError <= 40.9) {
            numBitVectors = 8;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 8 bit vectors..");
        } else if ((double)percentageError <= 61.0) {
            numBitVectors = 4;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 4 bit vectors..");
        } else {
            numBitVectors = 2;
            LOG.info("Error requested is " + percentageError + "%");
            LOG.info("Choosing 2 bit vectors..");
        }
        return numBitVectors;
    }

    public static boolean hasDiscreteRange(ColStatistics colStat) {
        TypeInfo colType;
        if (colStat.getRange() != null && (colType = TypeInfoUtils.getTypeInfoFromTypeString((String)colStat.getColumnType())).getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveTypeInfo pti = (PrimitiveTypeInfo)colType;
            switch (pti.getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
        }
        return false;
    }

    public static ColStatistics.Range combineRange(ColStatistics.Range range1, ColStatistics.Range range2) {
        if (range1.minValue != null && range1.maxValue != null && range2.minValue != null && range2.maxValue != null) {
            long min1 = range1.minValue.longValue();
            long max1 = range1.maxValue.longValue();
            long min2 = range2.minValue.longValue();
            long max2 = range2.maxValue.longValue();
            if (min1 < min2 && max1 < max2 || min1 > min2 && max1 > max2) {
                return null;
            }
            return new ColStatistics.Range(Math.min(min1, min2), Math.max(max1, max2));
        }
        return null;
    }
}

