/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.BatchTableWrite;
import org.apache.spark.sql.pipelines.graph.CompleteFlow;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowExecution;
import org.apache.spark.sql.pipelines.graph.FlowSystemMetadata;
import org.apache.spark.sql.pipelines.graph.Output;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.SinkWrite;
import org.apache.spark.sql.pipelines.graph.StreamingFlow;
import org.apache.spark.sql.pipelines.graph.StreamingTableWrite;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.streaming.Trigger;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00013AAB\u0004\u0001)!A\u0001\u0002\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002\u001c\u0001\t\u00039$a\u0003$m_^\u0004F.\u00198oKJT!\u0001C\u0005\u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u0005)Y\u0011!\u00039ja\u0016d\u0017N\\3t\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011aB\u0005\u0003=\u001d\u0011Q\u0002R1uC\u001adwn^$sCBD\u0017!D;qI\u0006$XmQ8oi\u0016DH\u000f\u0005\u0002\u001dC%\u0011!e\u0002\u0002\u0016!&\u0004X\r\\5oKV\u0003H-\u0019;f\u0007>tG/\u001a=u\u0003)!(/[4hKJ4uN\u001d\t\u0005-\u0015:#&\u0003\u0002'/\tIa)\u001e8di&|g.\r\t\u00039!J!!K\u0004\u0003\t\u0019cwn\u001e\t\u0003W9j\u0011\u0001\f\u0006\u0003[-\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005=b#a\u0002+sS\u001e<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\u001aD'\u000e\t\u00039\u0001AQ\u0001\u0003\u0003A\u0002mAQa\b\u0003A\u0002\u0001BQa\t\u0003A\u0002\u0011\nA\u0001\u001d7b]R\u0011\u0001h\u000f\t\u00039eJ!AO\u0004\u0003\u001b\u0019cwn^#yK\u000e,H/[8o\u0011\u0015aT\u00011\u0001>\u0003\u00111Gn\\<\u0011\u0005qq\u0014BA \b\u00051\u0011Vm]8mm\u0016$g\t\\8x\u0001")
public class FlowPlanner {
    private final DataflowGraph graph;
    private final PipelineUpdateContext updateContext;
    private final Function1<Flow, Trigger> triggerFor;

    public FlowExecution plan(ResolvedFlow flow) {
        Output output = (Output)this.graph.output().apply((Object)flow.destinationIdentifier());
        ResolvedFlow resolvedFlow = flow;
        if (resolvedFlow instanceof CompleteFlow) {
            CompleteFlow completeFlow = (CompleteFlow)resolvedFlow;
            DataflowGraph x$1 = this.graph;
            ResolvedFlow x$2 = flow;
            TableIdentifier x$3 = completeFlow.identifier();
            Map<String, String> x$4 = completeFlow.sqlConf();
            Table x$5 = (Table)output;
            PipelineUpdateContext x$6 = this.updateContext;
            return new BatchTableWrite(x$3, x$2, x$1, x$5, x$6, x$4);
        }
        if (resolvedFlow instanceof StreamingFlow) {
            StreamingFlow streamingFlow = (StreamingFlow)resolvedFlow;
            FlowSystemMetadata flowMetadata = new FlowSystemMetadata(this.updateContext, streamingFlow, this.graph);
            Output output2 = output;
            if (output2 instanceof Table) {
                Table table = (Table)output2;
                DataflowGraph x$7 = this.graph;
                ResolvedFlow x$8 = flow;
                TableIdentifier x$9 = streamingFlow.identifier();
                Table x$10 = table;
                PipelineUpdateContext x$11 = this.updateContext;
                Map<String, String> x$12 = streamingFlow.sqlConf();
                Trigger x$13 = (Trigger)this.triggerFor.apply((Object)streamingFlow);
                String x$14 = flowMetadata.latestCheckpointLocation();
                return new StreamingTableWrite(x$9, x$8, x$7, x$11, x$14, x$13, x$10, x$12);
            }
            if (output2 instanceof Sink) {
                Sink sink = (Sink)output2;
                DataflowGraph x$15 = this.graph;
                ResolvedFlow x$16 = flow;
                TableIdentifier x$17 = streamingFlow.identifier();
                Sink x$18 = sink;
                PipelineUpdateContext x$19 = this.updateContext;
                Map<String, String> x$20 = streamingFlow.sqlConf();
                Trigger x$21 = (Trigger)this.triggerFor.apply((Object)streamingFlow);
                String x$22 = flowMetadata.latestCheckpointLocation();
                return new SinkWrite(x$17, x$16, x$15, x$19, x$22, x$21, x$18, x$20);
            }
            throw new UnsupportedOperationException("Unsupported destination type: " + output.getClass().getSimpleName() + " for streaming flow " + streamingFlow.identifier() + " (" + flow.destinationIdentifier() + ")");
        }
        throw new UnsupportedOperationException("Unable to plan flow of type " + flow.getClass().getSimpleName());
    }

    public FlowPlanner(DataflowGraph graph, PipelineUpdateContext updateContext, Function1<Flow, Trigger> triggerFor) {
        this.graph = graph;
        this.updateContext = updateContext;
        this.triggerFor = triggerFor;
    }
}

