/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.io.IOException;
import org.apache.spark.sql.connect.client.arrow.AbstractMessageIterator;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.vector.ipc.ArrowReader;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowMessage;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Schema;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u4Aa\u0004\t\u0001?!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u0002%\u0001\t\u0003I\u0005B\u0002(\u0001A\u0003&q\nC\u0005S\u0001\u0001\u0007\t\u0011)Q\u0005\u007f!)1\u000b\u0001C))\")Q\f\u0001C\u0005=\")Q\r\u0001C!M\")q\r\u0001C\u0005Q\")q\r\u0001C\u0005]\")1\u000f\u0001C\u0005i\")a\u000f\u0001C!o\")\u0001\u0010\u0001C!s\nq2i\u001c8dCR,g.\u0019;j]\u001e\f%O]8x'R\u0014X-Y7SK\u0006$WM\u001d\u0006\u0003#I\tQ!\u0019:s_^T!a\u0005\u000b\u0002\r\rd\u0017.\u001a8u\u0015\t)b#A\u0004d_:tWm\u0019;\u000b\u0005]A\u0012aA:rY*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011(\u001b\u0005\u0011#BA\u0012%\u0003\rI\u0007o\u0019\u0006\u0003K\u0019\naA^3di>\u0014(BA\t\u001b\u0013\tA#EA\u0006BeJ|wOU3bI\u0016\u0014\u0018!C1mY>\u001c\u0017\r^8s!\tYc&D\u0001-\u0015\tic%\u0001\u0004nK6|'/_\u0005\u0003_1\u0012qBQ;gM\u0016\u0014\u0018\t\u001c7pG\u0006$xN]\u0001\u0006S:\u0004X\u000f\u001e\t\u0004eqzdBA\u001a:\u001d\t!t'D\u00016\u0015\t1d$\u0001\u0004=e>|GOP\u0005\u0002q\u0005)1oY1mC&\u0011!hO\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0014BA\u001f?\u0005!IE/\u001a:bi>\u0014(B\u0001\u001e<!\t\u0001\u0015)D\u0001\u0011\u0013\t\u0011\u0005CA\fBEN$(/Y2u\u001b\u0016\u001c8/Y4f\u0013R,'/\u0019;pe\u0006YA-Z:ueV\u001cG/\u001b<f!\t)e)D\u0001<\u0013\t95HA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011Q5\nT'\u0011\u0005\u0001\u0003\u0001\"B\u0015\u0005\u0001\u0004Q\u0003\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B\"\u0005\u0001\u0004!\u0015A\u0004;pi\u0006d')\u001f;fgJ+\u0017\r\u001a\t\u0003\u000bBK!!U\u001e\u0003\t1{gnZ\u0001\bGV\u0014(/\u001a8u\u0003)\u0011X-\u00193TG\",W.\u0019\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005a>TwN\u0003\u0002[I\u0005)A/\u001f9fg&\u0011Al\u0016\u0002\u0007'\u000eDW-\\1\u0002\u00179,\u0007\u0010^'fgN\fw-\u001a\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!MI\u0001\b[\u0016\u001c8/Y4f\u0013\t!\u0017M\u0001\u0007BeJ|w/T3tg\u0006<W-A\u0007m_\u0006$g*\u001a=u\u0005\u0006$8\r\u001b\u000b\u0002\t\u0006)2\r\\8oK&3gj\u001c8EKN$(/^2uSZ,GCA5m!\t\u0001'.\u0003\u0002lC\n\u0001\u0012I\u001d:poJ+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\u0006[*\u0001\r![\u0001\u0006E\u0006$8\r\u001b\u000b\u0003_J\u0004\"\u0001\u00199\n\u0005E\f'\u0001F!se><H)[2uS>t\u0017M]=CCR\u001c\u0007\u000eC\u0003n\u0017\u0001\u0007q.\u0001\tdY>tWMU3d_J$')\u0019;dQR\u0011\u0011.\u001e\u0005\u0006[2\u0001\r![\u0001\nEf$Xm\u001d*fC\u0012$\u0012aT\u0001\u0010G2|7/\u001a*fC\u0012\u001cv.\u001e:dKR\t!\u0010\u0005\u0002Fw&\u0011Ap\u000f\u0002\u0005+:LG\u000f")
public class ConcatenatingArrowStreamReader
extends ArrowReader {
    private final Iterator<AbstractMessageIterator> input;
    private final boolean destructive;
    private long totalBytesRead;
    private AbstractMessageIterator current;

    @Override
    public Schema readSchema() {
        Predef$.MODULE$.assert(this.current == null);
        if (!this.input.hasNext()) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        this.current = (AbstractMessageIterator)this.input.next();
        return this.current.schema();
    }

    private ArrowMessage nextMessage() {
        Predef$.MODULE$.assert(this.current != null);
        while (!this.current.hasNext() && this.input.hasNext()) {
            this.totalBytesRead += this.current.bytesRead();
            this.current = (AbstractMessageIterator)this.input.next();
            Schema schema = this.current.schema();
            Schema schema2 = this.getVectorSchemaRoot().getSchema();
            if (!(schema == null ? schema2 != null : !((Object)schema).equals(schema2))) continue;
            throw new IllegalStateException();
        }
        if (this.current.hasNext()) {
            return (ArrowMessage)this.current.next();
        }
        return null;
    }

    @Override
    public boolean loadNextBatch() {
        ArrowMessage message = this.nextMessage();
        while (message != null) {
            ArrowMessage arrowMessage = message;
            if (arrowMessage instanceof ArrowRecordBatch) {
                ArrowRecordBatch arrowRecordBatch = (ArrowRecordBatch)arrowMessage;
                this.loadRecordBatch(this.cloneIfNonDestructive(arrowRecordBatch));
                if (this.getVectorSchemaRoot().getRowCount() > 0) {
                    return true;
                }
            } else if (arrowMessage instanceof ArrowDictionaryBatch) {
                ArrowDictionaryBatch arrowDictionaryBatch = (ArrowDictionaryBatch)arrowMessage;
                this.loadDictionary(this.cloneIfNonDestructive(arrowDictionaryBatch));
            } else {
                throw new MatchError((Object)arrowMessage);
            }
            message = this.nextMessage();
        }
        return false;
    }

    private ArrowRecordBatch cloneIfNonDestructive(ArrowRecordBatch batch) {
        if (this.destructive) {
            return batch;
        }
        return this.cloneRecordBatch(batch);
    }

    private ArrowDictionaryBatch cloneIfNonDestructive(ArrowDictionaryBatch batch) {
        if (this.destructive) {
            return batch;
        }
        return new ArrowDictionaryBatch(batch.getDictionaryId(), this.cloneRecordBatch(batch.getDictionary()), batch.isDelta());
    }

    private ArrowRecordBatch cloneRecordBatch(ArrowRecordBatch batch) {
        return new ArrowRecordBatch(batch.getLength(), batch.getNodes(), batch.getBuffers(), batch.getBodyCompression(), true, true);
    }

    @Override
    public long bytesRead() {
        if (this.current != null) {
            return this.totalBytesRead + this.current.bytesRead();
        }
        return 0L;
    }

    @Override
    public void closeReadSource() {
    }

    public ConcatenatingArrowStreamReader(BufferAllocator allocator, Iterator<AbstractMessageIterator> input, boolean destructive) {
        this.input = input;
        this.destructive = destructive;
        super(allocator);
        this.totalBytesRead = 0L;
    }
}

