/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.FMClassificationModel$;
import org.apache.spark.ml.classification.FMClassificationModel$FMClassificationModelReader$;
import org.apache.spark.ml.classification.FMClassificationModel$FMClassificationModelWriter$;
import org.apache.spark.ml.classification.FMClassificationSummary;
import org.apache.spark.ml.classification.FMClassificationSummaryImpl;
import org.apache.spark.ml.classification.FMClassificationTrainingSummary;
import org.apache.spark.ml.classification.FMClassificationTrainingSummaryImpl;
import org.apache.spark.ml.classification.FMClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUe\u0001B$I\u0001MC\u0001B\u001c\u0001\u0003\u0006\u0004%\te\u001c\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\nAD!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\n\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003G\u0001!Q1A\u0005\u0002\u0005\u0015\u0002\"CA\u0015\u0001\t\u0005\t\u0015!\u0003Y\u0011)\ti\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003s\u0001!\u0011!Q\u0001\n\u0005E\u0002\u0002CA\u001f\u0001\u0011\u0005\u0001*a\u0010\t\u0011\u0005u\u0002\u0001\"\u0001K\u0003#B\u0011\"a\u0015\u0001\u0005\u0004%\t%!\u0016\t\u0011\u0005}\u0003\u0001)A\u0005\u0003/B\u0011\"a\u0019\u0001\u0005\u0004%\t%!\u0016\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003/Bq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u00111\u0017\u0001\u0005R\u0005U\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\t\u0003#\u0004A\u0011\t'\u0002T\"9\u00111\u001c\u0001\u0005B\u0005u\u0007bBAt\u0001\u0011\u0005\u0013\u0011\u001e\u0005\t\u0003W\u0004A\u0011\u0001'\u0002n\"A!1\u0002\u0001\u0005B1\u0013i\u0001\u0003\u0005\u0003\u0014\u0001!\t\u0005\u0014B\u000b\u000f\u001d\u0011Y\u0004\u0013E\u0001\u0005{1aa\u0012%\t\u0002\t}\u0002bBA\u001f7\u0011\u0005!Q\f\u0004\b\u0005?Z\u0002I\u0013B1\u0011)\t\t\"\bBK\u0002\u0013\u0005\u00111\u0003\u0005\u000b\u0003?i\"\u0011#Q\u0001\n\u0005U\u0001BCA\u0012;\tU\r\u0011\"\u0001\u0002&!I\u0011\u0011F\u000f\u0003\u0012\u0003\u0006I\u0001\u0017\u0005\u000b\u0003[i\"Q3A\u0005\u0002\u0005=\u0002BCA\u001d;\tE\t\u0015!\u0003\u00022!9\u0011QH\u000f\u0005\u0002\t]\u0004\"CA^;\u0005\u0005I\u0011\u0001BB\u0011%\u0011Y)HI\u0001\n\u0003\u0011i\tC\u0005\u0003\"v\t\n\u0011\"\u0001\u0003$\"I!qU\u000f\u0012\u0002\u0013\u0005!\u0011\u0016\u0005\n\u0005[k\u0012\u0011!C!\u0005_C\u0011Ba/\u001e\u0003\u0003%\t!!\u0016\t\u0013\tuV$!A\u0005\u0002\t}\u0006\"\u0003Bc;\u0005\u0005I\u0011\tBd\u0011%\u0011).HA\u0001\n\u0003\u00119\u000eC\u0005\u0003bv\t\t\u0011\"\u0011\u0003d\"I!q]\u000f\u0002\u0002\u0013\u0005#\u0011\u001e\u0005\n\u0003Ol\u0012\u0011!C!\u0005WD\u0011B!<\u001e\u0003\u0003%\tEa<\b\u0015\tM8$!A\t\u0002)\u0013)P\u0002\u0006\u0003`m\t\t\u0011#\u0001K\u0005oDq!!\u00104\t\u0003\u0019)\u0001C\u0005\u0002hN\n\t\u0011\"\u0012\u0003l\"I1qA\u001a\u0002\u0002\u0013\u00055\u0011\u0002\u0005\n\u0007#\u0019\u0014\u0011!CA\u0007'A\u0011b!\n4\u0003\u0003%Iaa\n\t\u0011\r=2\u0004\"\u0001K\u0007cA\u0001b!\u0011\u001c\t\u0003Q51\t\u0005\b\u0007\u001fZB\u0011IB)\u0011\u001d\u0019Yf\u0007C!\u0007;2qaa\u0019\u001c\u0001m\u0019)\u0007C\u0005\u0004tu\u0012\t\u0011)A\u0005=\"9\u0011QH\u001f\u0005\u0002\rU\u0004bBB>{\u0011E3Q\u0010\u0004\u0007\u0007\u0003[Baa!\t\u000f\u0005u\u0012\t\"\u0001\u0004\u0006\"I1\u0011R!C\u0002\u0013%!q\u0016\u0005\t\u0007\u0017\u000b\u0005\u0015!\u0003\u00032\"911L!\u0005B\r5\u0005\"CB\u00137\u0005\u0005I\u0011BB\u0014\u0005U1Uj\u00117bgNLg-[2bi&|g.T8eK2T!!\u0013&\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u00111\nT\u0001\u0003[2T!!\u0014(\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0002\u0001'\u0015\u0001Ak\u00182i!\u0011)f\u000b\u00170\u000e\u0003!K!a\u0016%\u0003AA\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u00033rk\u0011A\u0017\u0006\u00037*\u000ba\u0001\\5oC2<\u0017BA/[\u0005\u00191Vm\u0019;peB\u0011Q\u000b\u0001\t\u0003+\u0002L!!\u0019%\u0003%\u0019k5\t\\1tg&4\u0017.\u001a:QCJ\fWn\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K*\u000bA!\u001e;jY&\u0011q\r\u001a\u0002\u000b\u001b2;&/\u001b;bE2,\u0007cA2jW&\u0011!\u000e\u001a\u0002\u0013\u0011\u0006\u001cHK]1j]&twmU;n[\u0006\u0014\u0018\u0010\u0005\u0002VY&\u0011Q\u000e\u0013\u0002 \r6\u001bE.Y:tS\u001aL7-\u0019;j_:$&/Y5oS:<7+^7nCJL\u0018aA;jIV\t\u0001\u000f\u0005\u0002ru:\u0011!\u000f\u001f\t\u0003gZl\u0011\u0001\u001e\u0006\u0003kJ\u000ba\u0001\u0010:p_Rt$\"A<\u0002\u000bM\u001c\u0017\r\\1\n\u0005e4\u0018A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f<)\t\u0005q\u0018\u0011\u0002\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0004\u0003\u0003\u0011QaU5oG\u0016\f#!a\u0003\u0002\u000bMr\u0003G\f\u0019\u0002\tULG\r\t\u0015\u0005\u0005y\fI!A\u0005j]R,'oY3qiV\u0011\u0011Q\u0003\t\u0005\u0003/\tI\"D\u0001w\u0013\r\tYB\u001e\u0002\u0007\t>,(\r\\3)\t\rq\u0018\u0011B\u0001\u000bS:$XM]2faR\u0004\u0003\u0006\u0002\u0003\u007f\u0003\u0013\ta\u0001\\5oK\u0006\u0014X#\u0001-)\t\u0015q\u0018\u0011B\u0001\bY&tW-\u0019:!Q\u00111a0!\u0003\u0002\u000f\u0019\f7\r^8sgV\u0011\u0011\u0011\u0007\t\u00043\u0006M\u0012bAA\u001b5\n1Q*\u0019;sSbDCa\u0002@\u0002\n\u0005Aa-Y2u_J\u001c\b\u0005\u000b\u0003\t}\u0006%\u0011A\u0002\u001fj]&$h\bF\u0005_\u0003\u0003\n)%!\u0013\u0002N!)a.\u0003a\u0001a\"*\u0011\u0011\t@\u0002\n!9\u0011\u0011C\u0005A\u0002\u0005U\u0001&BA#}\u0006%\u0001BBA\u0012\u0013\u0001\u0007\u0001\fK\u0003\u0002Jy\fI\u0001C\u0004\u0002.%\u0001\r!!\r)\u000b\u00055c0!\u0003\u0015\u0003y\u000b!B\\;n\u00072\f7o]3t+\t\t9\u0006\u0005\u0003\u0002\u0018\u0005e\u0013bAA.m\n\u0019\u0011J\u001c;)\t-q\u0018\u0011B\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005\u000b\u0003\r}\u0006%\u0011a\u00038v[\u001a+\u0017\r^;sKNDC!\u0004@\u0002\n\u0005aa.^7GK\u0006$XO]3tA!\"aB`A\u0005\u0003\u001d\u0019X/\\7bef,\u0012a\u001b\u0015\u0005\u001fy\f\t(\t\u0002\u0002t\u0005)1GL\u0019/a\u0005AQM^1mk\u0006$X\r\u0006\u0003\u0002z\u0005}\u0004cA+\u0002|%\u0019\u0011Q\u0010%\u0003/\u0019k5\t\\1tg&4\u0017nY1uS>t7+^7nCJL\bbBAA!\u0001\u0007\u00111Q\u0001\bI\u0006$\u0018m]3ua\u0011\t))!&\u0011\r\u0005\u001d\u0015QRAI\u001b\t\tIIC\u0002\u0002\f2\u000b1a]9m\u0013\u0011\ty)!#\u0003\u000f\u0011\u000bG/Y:fiB!\u00111SAK\u0019\u0001!A\"a&\u0002\u0000\u0005\u0005\t\u0011!B\u0001\u00033\u00131a\u0018\u00135#\u0011\tY*!)\u0011\t\u0005]\u0011QT\u0005\u0004\u0003?3(a\u0002(pi\"Lgn\u001a\t\u0005\u0003/\t\u0019+C\u0002\u0002&Z\u00141!\u00118zQ\u0011\u0001b0!\u001d\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002Y\u0003[Ca!a,\u0012\u0001\u0004A\u0016\u0001\u00034fCR,(/Z:)\tEq\u0018\u0011B\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0019\u0001,a.\t\r\u0005e&\u00031\u0001Y\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006!1m\u001c9z)\rq\u0016q\u0018\u0005\b\u0003\u0003\u001c\u0002\u0019AAb\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAe\u0015\u0006)\u0001/\u0019:b[&!\u0011QZAd\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006B\n\u007f\u0003\u0013\tQ\"Z:uS6\fG/\u001a3TSj,WCAAk!\u0011\t9\"a6\n\u0007\u0005egO\u0001\u0003M_:<\u0017!B<sSR,WCAAp!\r\u0019\u0017\u0011]\u0005\u0004\u0003G$'\u0001C'M/JLG/\u001a:)\tUq\u0018\u0011B\u0001\ti>\u001cFO]5oOR\t\u0001/A\u0007de\u0016\fG/Z*v[6\f'/\u001f\u000b\u0007\u0003_\f)P!\u0001\u0011\t\u0005]\u0011\u0011_\u0005\u0004\u0003g4(\u0001B+oSRDq!!!\u0018\u0001\u0004\t9\u0010\r\u0003\u0002z\u0006u\bCBAD\u0003\u001b\u000bY\u0010\u0005\u0003\u0002\u0014\u0006uH\u0001DA\u0000\u0003k\f\t\u0011!A\u0003\u0002\u0005e%aA0%k!9!1A\fA\u0002\t\u0015\u0011\u0001E8cU\u0016\u001cG/\u001b<f\u0011&\u001cHo\u001c:z!\u0019\t9Ba\u0002\u0002\u0016%\u0019!\u0011\u0002<\u0003\u000b\u0005\u0013(/Y=\u0002\u0017M\fg/Z*v[6\f'/\u001f\u000b\u0005\u0003_\u0014y\u0001\u0003\u0004\u0003\u0012a\u0001\r\u0001]\u0001\u0005a\u0006$\b.A\u0006m_\u0006$7+^7nCJLHCBAx\u0005/\u0011I\u0002\u0003\u0004\u0003\u0012e\u0001\r\u0001\u001d\u0005\b\u0003\u0003K\u0002\u0019\u0001B\u000e!\u0011\u0011iBa\r\u000f\t\t}!q\u0006\b\u0005\u0005C\u0011iC\u0004\u0003\u0003$\t-b\u0002\u0002B\u0013\u0005Sq1a\u001dB\u0014\u0013\u0005\t\u0016BA(Q\u0013\tie*C\u0002\u0002\f2KAA!\r\u0002\n\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u001b\u0005o\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\tE\u0012\u0011\u0012\u0015\u0005\u0001y\fI!A\u000bG\u001b\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005U[2cB\u000e\u0003B\t\u001d#Q\n\t\u0005\u0003/\u0011\u0019%C\u0002\u0003FY\u0014a!\u00118z%\u00164\u0007\u0003B2\u0003JyK1Aa\u0013e\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0005\u001f\u0012I&\u0004\u0002\u0003R)!!1\u000bB+\u0003\tIwN\u0003\u0002\u0003X\u0005!!.\u0019<b\u0013\u0011\u0011YF!\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\tu\"\u0001\u0002#bi\u0006\u001cr!\bB!\u0005G\u0012I\u0007\u0005\u0003\u0002\u0018\t\u0015\u0014b\u0001B4m\n9\u0001K]8ek\u000e$\b\u0003\u0002B6\u0005grAA!\u001c\u0003r9\u00191Oa\u001c\n\u0003]L1A!\rw\u0013\u0011\u0011YF!\u001e\u000b\u0007\tEb\u000f\u0006\u0005\u0003z\tu$q\u0010BA!\r\u0011Y(H\u0007\u00027!9\u0011\u0011\u0003\u0013A\u0002\u0005U\u0001BBA\u0012I\u0001\u0007\u0001\fC\u0004\u0002.\u0011\u0002\r!!\r\u0015\u0011\te$Q\u0011BD\u0005\u0013C\u0011\"!\u0005&!\u0003\u0005\r!!\u0006\t\u0011\u0005\rR\u0005%AA\u0002aC\u0011\"!\f&!\u0003\u0005\r!!\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u0012\u0016\u0005\u0003+\u0011\tj\u000b\u0002\u0003\u0014B!!Q\u0013BO\u001b\t\u00119J\u0003\u0003\u0003\u001a\nm\u0015!C;oG\",7m[3e\u0015\r\t\u0019A^\u0005\u0005\u0005?\u00139JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003&*\u001a\u0001L!%\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0016\u0016\u0005\u0003c\u0011\t*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005c\u0003BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u0013)&\u0001\u0003mC:<\u0017bA>\u00036\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAQ\u0005\u0003D\u0011Ba1,\u0003\u0003\u0005\r!a\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\r\u0005\u0004\u0003L\nE\u0017\u0011U\u0007\u0003\u0005\u001bT1Aa4w\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005'\u0014iM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Bm\u0005?\u0004B!a\u0006\u0003\\&\u0019!Q\u001c<\u0003\u000f\t{w\u000e\\3b]\"I!1Y\u0017\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00032\n\u0015\b\"\u0003Bb]\u0005\u0005\t\u0019AA,\u0003!A\u0017m\u001d5D_\u0012,GCAA,)\t\u0011\t,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00053\u0014\t\u0010C\u0005\u0003DF\n\t\u00111\u0001\u0002\"\u0006!A)\u0019;b!\r\u0011YhM\n\u0006g\te(Q\n\t\f\u0005w\u001c\t!!\u0006Y\u0003c\u0011I(\u0004\u0002\u0003~*\u0019!q <\u0002\u000fI,h\u000e^5nK&!11\u0001B\u007f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005k\fQ!\u00199qYf$\u0002B!\u001f\u0004\f\r51q\u0002\u0005\b\u0003#1\u0004\u0019AA\u000b\u0011\u0019\t\u0019C\u000ea\u00011\"9\u0011Q\u0006\u001cA\u0002\u0005E\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0007+\u0019\t\u0003\u0005\u0004\u0002\u0018\r]11D\u0005\u0004\u000731(AB(qi&|g\u000eE\u0005\u0002\u0018\ru\u0011Q\u0003-\u00022%\u00191q\u0004<\u0003\rQ+\b\u000f\\34\u0011%\u0019\u0019cNA\u0001\u0002\u0004\u0011I(A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u000b\u0011\t\tM61F\u0005\u0005\u0007[\u0011)L\u0001\u0004PE*,7\r^\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016$\u0015\r^1\u0015\r\u0005=81GB\u001c\u0011\u001d\u0019)$\u000fa\u0001\u0005s\nA\u0001Z1uC\"91\u0011H\u001dA\u0002\rm\u0012a\u00013pgB!!qJB\u001f\u0013\u0011\u0019yD!\u0015\u0003!\u0011\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0017a\u00043fg\u0016\u0014\u0018.\u00197ju\u0016$\u0015\r^1\u0015\t\te4Q\t\u0005\b\u0007\u000fR\u0004\u0019AB%\u0003\r!\u0017n\u001d\t\u0005\u0005\u001f\u001aY%\u0003\u0003\u0004N\tE#a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002\tI,\u0017\rZ\u000b\u0003\u0007'\u0002BaYB+=&\u00191q\u000b3\u0003\u00115c%+Z1eKJDCa\u000f@\u0002\n\u0005!An\\1e)\rq6q\f\u0005\u0007\u0005#a\u0004\u0019\u00019)\tqr\u0018\u0011\u0002\u0002\u001c\r6\u001bE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m/JLG/\u001a:\u0014\u000bu\nyna\u001a\u0011\t\r%4qN\u0007\u0003\u0007WR1a!\u001cM\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BB9\u0007W\u0012q\u0001T8hO&tw-\u0001\u0005j]N$\u0018M\\2f)\u0011\u00199h!\u001f\u0011\u0007\tmT\b\u0003\u0004\u0004t}\u0002\rAX\u0001\tg\u00064X-S7qYR!\u0011q^B@\u0011\u0019\u0011\t\u0002\u0011a\u0001a\nYb)T\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2!QB*)\t\u00199\tE\u0002\u0003|\u0005\u000b\u0011b\u00197bgNt\u0015-\\3\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005F\u0002_\u0007\u001fCaA!\u0005F\u0001\u0004\u0001\b\u0006B\u000e\u007f\u0003\u0013ACA\u0007@\u0002\n\u0001")
public class FMClassificationModel
extends ProbabilisticClassificationModel<Vector, FMClassificationModel>
implements FMClassifierParams,
MLWritable,
HasTrainingSummary<FMClassificationTrainingSummary> {
    private final String uid;
    private final double intercept;
    private final Vector linear;
    private final Matrix factors;
    private final int numClasses;
    private final int numFeatures;
    private Option<FMClassificationTrainingSummary> trainingSummary;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMClassificationModel load(String path) {
        return FMClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<FMClassificationModel> read() {
        return FMClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<FMClassificationTrainingSummary> setSummary(Option<FMClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<FMClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<FMClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double intercept() {
        return this.intercept;
    }

    public Vector linear() {
        return this.linear;
    }

    public Matrix factors() {
        return this.factors;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public FMClassificationTrainingSummary summary() {
        return (FMClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public FMClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probability = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probability, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probability2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        return new FMClassificationSummaryImpl(summaryModel2.transform(dataset), probability2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double rawPrediction = FactorizationMachines$.MODULE$.getRawPrediction(features, this.intercept(), this.linear(), this.factors());
        return Vectors$.MODULE$.dense(new double[]{-rawPrediction, rawPrediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[1] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector.values()[1]));
            denseVector.values()[0] = 1.0 - denseVector.values()[1];
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in FMClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public FMClassificationModel copy(ParamMap extra) {
        return this.copyValues(new FMClassificationModel(this.uid(), this.intercept(), this.linear(), this.factors()), extra);
    }

    @Override
    public long estimatedSize() {
        long size;
        block1: {
            size = this.estimateMatadataSize();
            if (this.linear() != null) {
                size += this.linear().getSizeInBytes();
            }
            if (this.factors() == null) break block1;
            size += this.factors().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new FMClassificationModelWriter(this);
    }

    @Override
    public String toString() {
        return "FMClassificationModel: uid=" + Identifiable.toString$(this) + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures() + ", factorSize=" + this.$(this.factorSize()) + ", fitLinear=" + this.$(this.fitLinear()) + ", fitIntercept=" + this.$(this.fitIntercept());
    }

    public void createSummary(Dataset<?> dataset, double[] objectiveHistory) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        FMClassificationTrainingSummaryImpl summary = new FMClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName, objectiveHistory);
        this.setSummary((Option<FMClassificationTrainingSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1(FMClassificationModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple1((Object)this.summary().objectiveHistory()), (Function2 & Serializable)(data, dos) -> {
            ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._1(), dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double[] objectiveHistory;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModel.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2(FMClassificationModel $outer) {
            }
        }
        Tuple1 tuple1 = (Tuple1)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> new Tuple1((Object)ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis)), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2(null)));
        if (tuple1 == null || (objectiveHistory = (double[])tuple1._1()) == null) {
            throw new MatchError((Object)tuple1);
        }
        double[] dArray = objectiveHistory;
        double[] objectiveHistory2 = dArray;
        this.createSummary(dataset, objectiveHistory2);
    }

    public FMClassificationModel(String uid, double intercept, Vector linear, Matrix factors) {
        this.uid = uid;
        this.intercept = intercept;
        this.linear = linear;
        this.factors = factors;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numClasses = 2;
        this.numFeatures = linear.size();
        Statics.releaseFence();
    }

    public FMClassificationModel() {
        this("", Double.NaN, (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    public static class Data
    implements Product,
    Serializable {
        private final double intercept;
        private final Vector linear;
        private final Matrix factors;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double intercept() {
            return this.intercept;
        }

        public Vector linear() {
            return this.linear;
        }

        public Matrix factors() {
            return this.factors;
        }

        public Data copy(double intercept, Vector linear, Matrix factors) {
            return new Data(intercept, linear, factors);
        }

        public double copy$default$1() {
            return this.intercept();
        }

        public Vector copy$default$2() {
            return this.linear();
        }

        public Matrix copy$default$3() {
            return this.factors();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
                case 1: {
                    return this.linear();
                }
                case 2: {
                    return this.factors();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "intercept";
                }
                case 1: {
                    return "linear";
                }
                case 2: {
                    return "factors";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.linear()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.factors()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            Vector vector = this.linear();
            Vector vector2 = data.linear();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Matrix matrix = this.factors();
            Matrix matrix2 = data.factors();
            if (matrix == null) {
                if (matrix2 != null) {
                    return false;
                }
            } else if (!matrix.equals(matrix2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double intercept, Vector linear, Matrix factors) {
            this.intercept = intercept;
            this.linear = linear;
            this.factors = factors;
            Product.$init$((Product)this);
        }
    }

    private static class FMClassificationModelReader
    extends MLReader<FMClassificationModel> {
        private final String className = FMClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public FMClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.FMClassificationModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4(FMClassificationModelReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> FMClassificationModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4(null)));
            FMClassificationModel model = new FMClassificationModel(metadata.uid(), data.intercept(), data.linear(), data.factors());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class FMClassificationModelWriter
    extends MLWriter {
        private final FMClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.FMClassificationModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3(FMClassificationModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.intercept(), this.instance.linear(), this.instance.factors());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                FMClassificationModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3(null)));
        }

        public FMClassificationModelWriter(FMClassificationModel instance) {
            this.instance = instance;
        }
    }
}

