/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class ResolveTableConstraints$ {
    public static final ResolveTableConstraints$ MODULE$ = new ResolveTableConstraints$();

    public void validateCatalogForTableConstraint(Seq<Constraint> constraints, TableCatalog catalog, Identifier ident) {
        if (constraints.nonEmpty() && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_TABLE_CONSTRAINT)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "table constraint");
        }
    }

    public void validateCatalogForTableChange(Seq<TableChange> tableChanges, TableCatalog catalog, Identifier ident) {
        boolean hasTableConstraint = tableChanges.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveTableConstraints$.$anonfun$validateCatalogForTableChange$1(x0$1)));
        if (hasTableConstraint && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_TABLE_CONSTRAINT)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "table constraint");
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateCatalogForTableChange$1(TableChange x0$1) {
        TableChange tableChange = x0$1;
        if (tableChange instanceof TableChange.AddConstraint) {
            return true;
        }
        return tableChange instanceof TableChange.DropConstraint;
    }

    private ResolveTableConstraints$() {
    }
}

