/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.binaryfile;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.binaryfile.BinaryFileFormat$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateHelper;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.sparkproject.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u0013&\u0001RBQA\u0017\u0001\u0005\u0002mCQA\u0018\u0001\u0005B}Cq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011\u0011\u000b\u0001\u0005B\u0005=\u0003bBA*\u0001\u0011E\u0013Q\u000b\u0005\t\u0003?\u0003\u0011\u0011!C\u00017\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00131\u0015\u0005\n\u0003g\u0003\u0011\u0011!C\u0001\u0003kC\u0011\"!0\u0001\u0003\u0003%\t!a0\t\u0013\u0005-\u0007!!A\u0005B\u00055\u0007\"CAm\u0001\u0005\u0005I\u0011AAn\u0011%\ty\u000eAA\u0001\n\u0003\n\t\u000fC\u0005\u0002f\u0002\t\t\u0011\"\u0011\u0002h\"I\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005\u00131^\u0004\b\u0003_,\u0003\u0012AAy\r\u0019!S\u0005#\u0001\u0002t\"1!L\u0005C\u0001\u0003\u007fD!B!\u0001\u0013\u0005\u0004%\t!JAR\u0011!\u0011\u0019A\u0005Q\u0001\n\u0005\u0015\u0006B\u0003B\u0003%\t\u0007I\u0011A\u0013\u0002$\"A!q\u0001\n!\u0002\u0013\t)\u000b\u0003\u0006\u0003\nI\u0011\r\u0011\"\u0001&\u0003GC\u0001Ba\u0003\u0013A\u0003%\u0011Q\u0015\u0005\u000b\u0005\u001b\u0011\"\u0019!C\u0001K\u0005\r\u0006\u0002\u0003B\b%\u0001\u0006I!!*\t\u0015\tE!C1A\u0005\u0002\u0015\n\u0019\u000b\u0003\u0005\u0003\u0014I\u0001\u000b\u0011BAS\u0011%\u0011)B\u0005b\u0001\n\u0003\u00119\u0002C\u0004\u0003\u001aI\u0001\u000b\u0011B2\t\u0011\tm!\u0003\"\u0001&\u0005;A\u0001Ba\n\u0013\u0003\u0003%\ti\u0017\u0005\n\u0005S\u0011\u0012\u0011!CA\u0005WA\u0011B!\r\u0013\u0003\u0003%IAa\r\u0003!\tKg.\u0019:z\r&dWMR8s[\u0006$(B\u0001\u0014(\u0003)\u0011\u0017N\\1ss\u001aLG.\u001a\u0006\u0003Q%\n1\u0002Z1uCN|WO]2fg*\u0011!fK\u0001\nKb,7-\u001e;j_:T!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001b<\u007f\u0015[e\n\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003yuj\u0011aJ\u0005\u0003}\u001d\u0012!BR5mK\u001a{'/\\1u!\t\u00015)D\u0001B\u0015\t\u00115&A\u0004t_V\u00148-Z:\n\u0005\u0011\u000b%A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u0016\u0002\u0011%tG/\u001a:oC2L!AS$\u0003%M+7o]5p]N#\u0018\r^3IK2\u0004XM\u001d\t\u0003m1K!!T\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011qj\u0016\b\u0003!Vs!!\u0015+\u000e\u0003IS!aU\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014B\u0001,8\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005Y;\u0014A\u0002\u001fj]&$h\bF\u0001]!\ti\u0006!D\u0001&\u0003-IgNZ3s'\u000eDW-\\1\u0015\t\u0001Lw\u000e \t\u0004m\u0005\u001c\u0017B\u000128\u0005\u0019y\u0005\u000f^5p]B\u0011AmZ\u0007\u0002K*\u0011amK\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0016\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015Q'\u00011\u0001l\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\taW.D\u0001,\u0013\tq7F\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003q\u0005\u0001\u0007\u0011/A\u0004paRLwN\\:\u0011\tI4\u00180\u001f\b\u0003gR\u0004\"!U\u001c\n\u0005U<\u0014A\u0002)sK\u0012,g-\u0003\u0002xq\n\u0019Q*\u00199\u000b\u0005U<\u0004C\u0001:{\u0013\tY\bP\u0001\u0004TiJLgn\u001a\u0005\u0006{\n\u0001\rA`\u0001\u0006M&dWm\u001d\t\u0005\u001f~\f\u0019!C\u0002\u0002\u0002e\u00131aU3r!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t!AZ:\u000b\u0007\u00055q&\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003#\t9A\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$\"\"a\u0006\u0002\u001e\u0005}\u0011qFA\u0019!\ra\u0014\u0011D\u0005\u0004\u000379#aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u00026\u0004\u0001\u0004Y\u0007bBA\u0011\u0007\u0001\u0007\u00111E\u0001\u0004U>\u0014\u0007\u0003BA\u0013\u0003Wi!!a\n\u000b\t\u0005%\u00121B\u0001\n[\u0006\u0004(/\u001a3vG\u0016LA!!\f\u0002(\t\u0019!j\u001c2\t\u000bA\u001c\u0001\u0019A9\t\r\u0005M2\u00011\u0001d\u0003)!\u0017\r^1TG\",W.Y\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\r\u0006\u0005\u0002:\u0005}\u0012\u0011IA\"!\r1\u00141H\u0005\u0004\u0003{9$a\u0002\"p_2,\u0017M\u001c\u0005\u0006U\u0012\u0001\ra\u001b\u0005\u0006a\u0012\u0001\r!\u001d\u0005\b\u0003\u000b\"\u0001\u0019AA$\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005\u0015\u0011\u0011J\u0005\u0005\u0003\u0017\n9A\u0001\u0003QCRD\u0017!C:i_J$h*Y7f)\u0005I\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003/\n)(a\u001e\u0002z\u0005u\u0014\u0011QAG\u0003\u001f\u0003rANA-\u0003;\n\u0019'C\u0002\u0002\\]\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007q\ny&C\u0002\u0002b\u001d\u0012q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006\u001f\u0006\u0015\u0014\u0011N\u0005\u0004\u0003OJ&\u0001C%uKJ\fGo\u001c:\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001c,\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA:\u0003[\u00121\"\u00138uKJt\u0017\r\u001c*po\")!n\u0002a\u0001W\"1\u00111G\u0004A\u0002\rDa!a\u001f\b\u0001\u0004\u0019\u0017a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005}t\u00011\u0001d\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a!\b\u0001\u0004\t))A\u0004gS2$XM]:\u0011\t={\u0018q\u0011\t\u0004\u0001\u0006%\u0015bAAF\u0003\n1a)\u001b7uKJDQ\u0001]\u0004A\u0002EDq!!%\b\u0001\u0004\t\u0019*\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY!\u0001\u0003d_:4\u0017\u0002BAO\u0003/\u0013QbQ8oM&<WO]1uS>t\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bA\u0001\\1oO*\u0011\u0011qV\u0001\u0005U\u00064\u0018-C\u0002|\u0003S\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a.\u0011\u0007Y\nI,C\u0002\u0002<^\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!1\u0002HB\u0019a'a1\n\u0007\u0005\u0015wGA\u0002B]fD\u0011\"!3\f\u0003\u0003\u0005\r!a.\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\r\u0005\u0004\u0002R\u0006]\u0017\u0011Y\u0007\u0003\u0003'T1!!68\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\n\u0019.\u0001\u0005dC:,\u0015/^1m)\u0011\tI$!8\t\u0013\u0005%W\"!AA\u0002\u0005\u0005\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!*\u0002d\"I\u0011\u0011\u001a\b\u0002\u0002\u0003\u0007\u0011qW\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qW\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0012Q\u001e\u0005\n\u0003\u0013\u0004\u0012\u0011!a\u0001\u0003\u0003\f\u0001CQ5oCJLh)\u001b7f\r>\u0014X.\u0019;\u0011\u0005u\u00132\u0003\u0002\n6\u0003k\u0004B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0005\u0003w\fi+\u0001\u0002j_&\u0019\u0001,!?\u0015\u0005\u0005E\u0018\u0001\u0002)B)\"\u000bQ\u0001U!U\u0011\u0002\n\u0011#T(E\u0013\u001aK5)\u0011+J\u001f:{F+S'F\u0003Iiu\nR%G\u0013\u000e\u000bE+S(O?RKU*\u0012\u0011\u0002\r1+ej\u0012+I\u0003\u001daUIT$U\u0011\u0002\nqaQ(O)\u0016sE+\u0001\u0005D\u001f:#VI\u0014+!\u0003-\u0011\u0015JT!S3~3\u0015\nT#\u0002\u0019\tKe*\u0011*Z?\u001aKE*\u0012\u0011\u0002\rM\u001c\u0007.Z7b+\u0005\u0019\u0017aB:dQ\u0016l\u0017\rI\u0001\u0015GJ,\u0017\r^3GS2$XM\u001d$v]\u000e$\u0018n\u001c8\u0015\t\t}!1\u0005\t\u0005m\u0005\u0014\t\u0003E\u00047\u00033\n\u0019!!\u000f\t\u000f\t\u0015\u0002\u00051\u0001\u0002\b\u00061a-\u001b7uKJ\fQ!\u00199qYf\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002:\t5\u0002\u0002\u0003B\u0018E\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00036A!\u0011q\u0015B\u001c\u0013\u0011\u0011I$!+\u0003\r=\u0013'.Z2u\u0001")
public class BinaryFileFormat
implements FileFormat,
DataSourceRegister,
SessionStateHelper,
Product,
Serializable {
    public static boolean unapply(BinaryFileFormat x$0) {
        return BinaryFileFormat$.MODULE$.unapply(x$0);
    }

    public static BinaryFileFormat apply() {
        return BinaryFileFormat$.MODULE$.apply();
    }

    public static StructType schema() {
        return BinaryFileFormat$.MODULE$.schema();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public SessionState sessionState(SparkSession sparkSession) {
        return SessionStateHelper.sessionState$(this, sparkSession);
    }

    @Override
    public SparkConf getSparkConf(SparkSession sparkSession) {
        return SessionStateHelper.getSparkConf$(this, sparkSession);
    }

    @Override
    public SQLConf getSqlConf(SparkSession sparkSession) {
        return SessionStateHelper.getSqlConf$(this, sparkSession);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession, Map<String, String> options) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession, options);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$(this, sparkSession, dataSchema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$(this, dataType);
    }

    @Override
    public boolean supportReadDataType(DataType dataType) {
        return FileFormat.supportReadDataType$(this, dataType);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return FileFormat.metadataSchemaFields$(this);
    }

    @Override
    public Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)BinaryFileFormat$.MODULE$.schema());
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw QueryExecutionErrors$.MODULE$.writeUnsupportedForBinaryFileDataSourceError();
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return false;
    }

    @Override
    public String shortName() {
        return BinaryFileFormat$.MODULE$.BINARY_FILE();
    }

    public String toString() {
        return "BINARYFILE";
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.require(DataTypeUtils$.MODULE$.sameType((DataType)dataSchema, (DataType)BinaryFileFormat$.MODULE$.schema()), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Binary file data source expects dataSchema: " + BinaryFileFormat$.MODULE$.schema() + ",\n         |but got: " + dataSchema + ".\n        ")));
        Broadcast broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        Seq filterFuncs = (Seq)filters.flatMap((Function1 & Serializable)filter -> BinaryFileFormat$.MODULE$.createFilterFunction((Filter)filter));
        int maxLength = BoxesRunTime.unboxToInt((Object)this.getSqlConf(sparkSession).getConf(SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH()));
        return (Function1 & Serializable)file -> {
            Path path = file.toPath();
            FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
            FileStatus status = fs.getFileStatus(path);
            if (filterFuncs.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinaryFileFormat.$anonfun$buildReader$4(status, x$1)))) {
                UnsafeRowWriter writer = new UnsafeRowWriter(requiredSchema.length());
                writer.resetRowWriter();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()))), (Function1 & Serializable)x0$1 -> {
                    BinaryFileFormat.$anonfun$buildReader$5(writer, status, maxLength, fs, x0$1);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().single((Object)writer.getRow());
            }
            return package$.MODULE$.Iterator().empty();
        };
    }

    public BinaryFileFormat copy() {
        return new BinaryFileFormat();
    }

    public String productPrefix() {
        return "BinaryFileFormat";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BinaryFileFormat;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return 142584724;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof BinaryFileFormat && ((BinaryFileFormat)x$1).canEqual(this);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(FileStatus status$1, Function1 x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.apply((Object)status$1));
    }

    public static final /* synthetic */ void $anonfun$buildReader$5(UnsafeRowWriter writer$1, FileStatus status$1, int maxLength$1, FileSystem fs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string2 = BinaryFileFormat$.MODULE$.PATH();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                writer$1.write(i, UTF8String.fromString((String)status$1.getPath().toString()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string4 = BinaryFileFormat$.MODULE$.LENGTH();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                writer$1.write(i, status$1.getLen());
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string6 = BinaryFileFormat$.MODULE$.MODIFICATION_TIME();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                writer$1.write(i, DateTimeUtils$.MODULE$.millisToMicros(status$1.getModificationTime()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string8 = BinaryFileFormat$.MODULE$.CONTENT();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                if (status$1.getLen() > (long)maxLength$1) {
                    throw QueryExecutionErrors$.MODULE$.fileLengthExceedsMaxLengthError(status$1, maxLength$1);
                }
                FSDataInputStream stream = fs$1.open(status$1.getPath());
                try {
                    writer$1.write(i, stream.readAllBytes());
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                return;
            }
        }
        if (tuple2 != null) {
            String other = (String)tuple2._1();
            throw QueryExecutionErrors$.MODULE$.unsupportedFieldNameError(other);
        }
        throw new MatchError((Object)tuple2);
    }

    public BinaryFileFormat() {
        FileFormat.$init$(this);
        SessionStateHelper.$init$(this);
        Product.$init$((Product)this);
    }
}

