/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.memory.UnmanagedMemoryConsumer;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%g!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\r\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003S\u0001\u0011\u00051\u000bC\u0004Z\u0001\t\u0007I\u0011B#\t\ri\u0003\u0001\u0015!\u0003G\u0011\u0015Y\u0006\u0001\"\u0003]\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u00159\u0007\u0001\"\u0011F\u0011\u0015A\u0007\u0001\"\u0011F\u0011\u0019I\u0007\u0001\"\u0011,U\")\u0001\u000f\u0001C!c\"1q\u0010\u0001C!\u0003\u00039q!!\u0003,\u0011\u0003\tYA\u0002\u0004+W!\u0005\u0011Q\u0002\u0005\u0007%F!\t!!\u0006\t\u0013\u0005]\u0011C1A\u0005\n\u0005e\u0001bBA\u000e#\u0001\u0006Ia\u0014\u0005\n\u0003;\t\"\u0019!C\u0005\u0003?A\u0001\"!\u0011\u0012A\u0003%\u0011\u0011\u0005\u0005\n\u0003\u0007\n\"\u0019!C\u0005\u0003\u000bB\u0001\"a\u0015\u0012A\u0003%\u0011q\t\u0005\n\u0003+\n\"\u0019!C\u0005\u0003\u000bB\u0001\"a\u0016\u0012A\u0003%\u0011q\t\u0005\n\u00033\n\"\u0019!C\u0005\u00037B\u0001\"a\u0019\u0012A\u0003%\u0011Q\f\u0005\u00077F!\t!L#\t\u000f\u0005\u0015\u0014\u0003\"\u0001\u0002h!A\u0011QN\t\u0005\u00025\ny\u0007C\u0004\u0002tE!\t!!\u001e\t\r\u0005E\u0015\u0003\"\u0001d\u0011-\t\u0019*\u0005a\u0001\u0002\u0004%I!!&\t\u0017\u0005u\u0015\u00031AA\u0002\u0013%\u0011q\u0014\u0005\f\u0003K\u000b\u0002\u0019!A!B\u0013\t9\n\u0003\u0005\u00020F!\taKAY\u0011\u0019\t9,\u0005C\u0005G\"9\u0011\u0011X\t\u0005\u00025\u001a\u0007bBA^#\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0007\fB\u0011BAc\u0005Q)f.\u001b4jK\u0012lU-\\8ss6\u000bg.Y4fe*\u0011A&L\u0001\u0007[\u0016lwN]=\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c2\u0001\u0001\u001b9!\t)d'D\u0001,\u0013\t94FA\u0007NK6|'/_'b]\u0006<WM\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w5\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003{i\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0003\nk\u0011!L\u0005\u0003\u00076\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b5\f\u0007\u0010S3ba6+Wn\u001c:z+\u00051\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001\u0002'p]\u001e\fa\"\\1y\u0011\u0016\f\u0007/T3n_JL\b%A\fp]\"+\u0017\r]*u_J\fw-\u001a*fO&|gnU5{K\u0006Aa.^7D_J,7\u000f\u0005\u0002H!&\u0011\u0011\u000b\u0013\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0003U+Z;\u0006\f\u0005\u00026\u0001!)aH\u0002a\u0001\u0001\")AI\u0002a\u0001\r\")QJ\u0002a\u0001\r\")aJ\u0002a\u0001\u001f\u0006\u0001SO\\7b]\u0006<W\rZ'f[>\u0014\u0018\u0010U8mY&tw-\u00138uKJ4\u0018\r\\'t\u0003\u0005*h.\\1oC\u001e,G-T3n_JL\bk\u001c7mS:<\u0017J\u001c;feZ\fG.T:!\u0003Y9W\r^+o[\u0006t\u0017mZ3e\u001b\u0016lwN]=Vg\u0016$GC\u0001$^\u0011\u0015q\u0016\u00021\u0001`\u0003)iW-\\8ss6{G-\u001a\t\u0003k\u0001L!!Y\u0016\u0003\u00155+Wn\u001c:z\u001b>$W-\u0001\tbgN,'\u000f^%om\u0006\u0014\u0018.\u00198ugR\tA\r\u0005\u0002HK&\u0011a\r\u0013\u0002\u0005+:LG/\u0001\fnCb|e\u000eS3baN#xN]1hK6+Wn\u001c:z\u0003]i\u0017\r_(gM\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180\u0001\fbGF,\u0018N]3Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z)\u001115.\\8\t\u000b1l\u0001\u0019\u0001$\u0002\u00119,XNQ=uKNDQA\\\u0007A\u0002\u0019\u000bQ\u0002^1tW\u0006#H/Z7qi&#\u0007\"\u00020\u000e\u0001\u0004y\u0016\u0001F1dcVL'/Z*u_J\fw-Z'f[>\u0014\u0018\u0010\u0006\u0003skvt\bCA$t\u0013\t!\bJA\u0004C_>dW-\u00198\t\u000bYt\u0001\u0019A<\u0002\u000f\tdwnY6JIB\u0011\u0001p_\u0007\u0002s*\u0011!0L\u0001\bgR|'/Y4f\u0013\ta\u0018PA\u0004CY>\u001c7.\u00133\t\u000b1t\u0001\u0019\u0001$\t\u000bys\u0001\u0019A0\u0002'\u0005\u001c\u0017/^5sKVs'o\u001c7m\u001b\u0016lwN]=\u0015\u000fI\f\u0019!!\u0002\u0002\b!)ao\u0004a\u0001o\")An\u0004a\u0001\r\")al\u0004a\u0001?\u0006!RK\\5gS\u0016$W*Z7pefl\u0015M\\1hKJ\u0004\"!N\t\u0014\tE\ty\u0001\u000f\t\u0004\u000f\u0006E\u0011bAA\n\u0011\n1\u0011I\\=SK\u001a$\"!a\u0003\u00029I+5+\u0012*W\u000b\u0012{6+W*U\u000b6{V*R'P%f{&)\u0017+F'V\tq*A\u000fS\u000bN+%KV#E?NK6\u000bV#N?6+Uj\u0014*Z?\nKF+R*!\u0003a)h.\\1oC\u001e,G-T3n_JL8i\u001c8tk6,'o]\u000b\u0003\u0003C\u0001\u0002\"a\t\u00022\u0005U\u00121H\u0007\u0003\u0003KQA!a\n\u0002*\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u0012QF\u0001\u0005kRLGN\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\n\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u00026\u0003oI1!!\u000f,\u0005e)f.\\1oC\u001e,G-T3n_JL8i\u001c8tk6,'/\u00133\u0011\u0007U\ni$C\u0002\u0002@-\u0012q#\u00168nC:\fw-\u001a3NK6|'/_\"p]N,X.\u001a:\u00023UtW.\u00198bO\u0016$W*Z7pef\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u0014k:l\u0017M\\1hK\u0012|e\u000eS3baV\u001bX\rZ\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0005\u0003\u001b\n)#\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003#\nYE\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fA#\u001e8nC:\fw-\u001a3P]\"+\u0017\r]+tK\u0012\u0004\u0013\u0001F;o[\u0006t\u0017mZ3e\u001f\u001a4\u0007*Z1q+N,G-A\u000bv]6\fg.Y4fI>3g\rS3baV\u001bX\r\u001a\u0011\u0002\u001dA|G\u000e\\5oON#\u0018M\u001d;fIV\u0011\u0011Q\f\t\u0005\u0003\u0013\ny&\u0003\u0003\u0002b\u0005-#!D!u_6L7MQ8pY\u0016\fg.A\bq_2d\u0017N\\4Ti\u0006\u0014H/\u001a3!\u0003}\u0011XmZ5ti\u0016\u0014XK\\7b]\u0006<W\rZ'f[>\u0014\u0018pQ8ogVlWM\u001d\u000b\u0004I\u0006%\u0004bBA6=\u0001\u0007\u00111H\u0001\u0018k:l\u0017M\\1hK\u0012lU-\\8ss\u000e{gn];nKJ\f\u0011%\u001e8sK\u001eL7\u000f^3s+:l\u0017M\\1hK\u0012lU-\\8ss\u000e{gn];nKJ$2\u0001ZA9\u0011\u001d\tYg\ba\u0001\u0003w\t\u0001dZ3u\u001b\u0016lwN]=Cs\u000e{W\u000e]8oK:$H+\u001f9f)\r1\u0015q\u000f\u0005\b\u0003s\u0002\u0003\u0019AA>\u00035\u0019w.\u001c9p]\u0016tG\u000fV=qKB!\u0011QPAF\u001d\u0011\ty(a\"\u0011\u0007\u0005\u0005\u0005*\u0004\u0002\u0002\u0004*\u0019\u0011QQ \u0002\rq\u0012xn\u001c;?\u0013\r\tI\tS\u0001\u0007!J,G-\u001a4\n\t\u00055\u0015q\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0005*A\rdY\u0016\f'/\u00168nC:\fw-\u001a3NK6|'/_+tKJ\u001c\u0018!F;o[\u0006t\u0017mZ3e\u001b\u0016lwN]=Q_2dWM]\u000b\u0003\u0003/\u0003B!a\t\u0002\u001a&!\u00111TA\u0013\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u001ak:l\u0017M\\1hK\u0012lU-\\8ssB{G\u000e\\3s?\u0012*\u0017\u000fF\u0002e\u0003CC\u0011\"a)$\u0003\u0003\u0005\r!a&\u0002\u0007a$\u0013'\u0001\fv]6\fg.Y4fI6+Wn\u001c:z!>dG.\u001a:!Q\r!\u0013\u0011\u0016\t\u0004\u000f\u0006-\u0016bAAW\u0011\nAao\u001c7bi&dW-\u0001\u000bti\u0006\u0014H\u000fU8mY&tw-\u00134OK\u0016$W\r\u001a\u000b\u0004I\u0006M\u0006BBA[K\u0001\u0007a)A\tq_2d\u0017N\\4J]R,'O^1m\u001bN\f\u0001\u0004]8mYVsW.\u00198bO\u0016$W*Z7pef,6/\u001a:t\u0003u\u0019\b.\u001e;e_^tWK\\7b]\u0006<W\rZ'f[>\u0014\u0018\u0010U8mY\u0016\u0014\u0018!B1qa2LH#\u0002+\u0002@\u0006\u0005\u0007\"\u0002 )\u0001\u0004\u0001\u0005\"\u0002()\u0001\u0004y\u0015\u0001D4fi6\u000b\u00070T3n_JLHc\u0001$\u0002H\")a(\u000ba\u0001\u0001\u0002")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxHeapMemory;
    private final long onHeapStorageRegionSize;
    private final long unmanagedMemoryPollingIntervalMs;

    public static UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        return UnifiedMemoryManager$.MODULE$.apply(conf, numCores);
    }

    public static void clearUnmanagedMemoryUsers() {
        UnifiedMemoryManager$.MODULE$.clearUnmanagedMemoryUsers();
    }

    public static long getMemoryByComponentType(String componentType) {
        return UnifiedMemoryManager$.MODULE$.getMemoryByComponentType(componentType);
    }

    public static void registerUnmanagedMemoryConsumer(UnmanagedMemoryConsumer unmanagedMemoryConsumer) {
        UnifiedMemoryManager$.MODULE$.registerUnmanagedMemoryConsumer(unmanagedMemoryConsumer);
    }

    public long maxHeapMemory() {
        return this.maxHeapMemory;
    }

    private long unmanagedMemoryPollingIntervalMs() {
        return this.unmanagedMemoryPollingIntervalMs;
    }

    private long getUnmanagedMemoryUsed(MemoryMode memoryMode) {
        if (this.unmanagedMemoryPollingIntervalMs() <= 0L) {
            return 0L;
        }
        MemoryMode memoryMode2 = memoryMode;
        if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
            return UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed().get();
        }
        if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
            return UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed().get();
        }
        throw new MatchError((Object)memoryMode2);
    }

    private void assertInvariants() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.onHeapStorageMemoryPool().poolSize() == this.maxHeapMemory());
        Predef$.MODULE$.assert(this.offHeapExecutionMemoryPool().poolSize() + this.offHeapStorageMemoryPool().poolSize() == this.maxOffHeapMemory());
    }

    @Override
    public synchronized long maxOnHeapStorageMemory() {
        return this.maxHeapMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long maxOffHeapStorageMemory() {
        return this.maxOffHeapMemory() - this.offHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        Tuple4 tuple4;
        this.assertInvariants();
        Predef$.MODULE$.assert(numBytes >= 0L);
        MemoryMode memoryMode2 = memoryMode;
        if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
            tuple4 = new Tuple4((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.onHeapStorageRegionSize), (Object)BoxesRunTime.boxToLong((long)this.maxHeapMemory()));
        } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
            tuple4 = new Tuple4((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.offHeapStorageMemory()), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple42._1();
        StorageMemoryPool storagePool = (StorageMemoryPool)tuple42._2();
        long storageRegionSize = BoxesRunTime.unboxToLong((Object)tuple42._3());
        long maxMemory = BoxesRunTime.unboxToLong((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)storageRegionSize), (Object)BoxesRunTime.boxToLong((long)maxMemory));
        ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple43._1();
        StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple43._2();
        long storageRegionSize2 = BoxesRunTime.unboxToLong((Object)tuple43._3());
        long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple43._4());
        return executionPool2.acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)extraMemoryNeeded -> UnifiedMemoryManager.maybeGrowExecutionPool$1(extraMemoryNeeded, storagePool2, storageRegionSize2, executionPool2), (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.computeMaxExecutionPoolSize$1(memoryMode, maxMemory2, storagePool2, storageRegionSize2));
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        StorageMemoryPool storagePool;
        block6: {
            Tuple3 tuple3;
            this.assertInvariants();
            Predef$.MODULE$.assert(numBytes >= 0L);
            MemoryMode memoryMode2 = memoryMode;
            if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
                tuple3 = new Tuple3((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOnHeapStorageMemory()));
            } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
                tuple3 = new Tuple3((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapStorageMemory()));
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple32._1();
            StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple32._2();
            long maxMemory = BoxesRunTime.unboxToLong((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)executionPool, (Object)storagePool2, (Object)BoxesRunTime.boxToLong((long)maxMemory));
            ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple33._1();
            storagePool = (StorageMemoryPool)tuple33._2();
            long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            long unmanagedMemory = this.getUnmanagedMemoryUsed(memoryMode);
            long effectiveMaxMemory = package$.MODULE$.max(0L, maxMemory2 - unmanagedMemory);
            if (numBytes > effectiveMaxMemory) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_ID, blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" (", " bytes) exceeds our"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)numBytes))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" memory limit (", " bytes)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES_MAX, BoxesRunTime.boxToLong((long)effectiveMaxMemory))}))).$plus(unmanagedMemory > 0L ? this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" (unmanaged memory usage: ", " bytes)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)unmanagedMemory))})) : this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))).log((Seq)Nil$.MODULE$))));
                return false;
            }
            if (numBytes <= storagePool.memoryFree()) break block6;
            long memoryBorrowedFromExecution = Math.min(executionPool2.memoryFree(), numBytes - storagePool.memoryFree());
            executionPool2.decrementPoolSize(memoryBorrowedFromExecution);
            storagePool.incrementPoolSize(memoryBorrowedFromExecution);
        }
        return storagePool.acquireMemory(blockId, numBytes);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        return this.acquireStorageMemory(blockId, numBytes, memoryMode);
    }

    private static final void maybeGrowExecutionPool$1(long extraMemoryNeeded, StorageMemoryPool storagePool$1, long storageRegionSize$1, ExecutionMemoryPool executionPool$1) {
        if (extraMemoryNeeded > 0L) {
            long memoryReclaimableFromStorage = package$.MODULE$.max(storagePool$1.memoryFree(), storagePool$1.poolSize() - storageRegionSize$1);
            if (memoryReclaimableFromStorage > 0L) {
                long spaceToReclaim = storagePool$1.freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
                storagePool$1.decrementPoolSize(spaceToReclaim);
                executionPool$1.incrementPoolSize(spaceToReclaim);
                return;
            }
            return;
        }
    }

    private final long computeMaxExecutionPoolSize$1(MemoryMode memoryMode$1, long maxMemory$1, StorageMemoryPool storagePool$1, long storageRegionSize$1) {
        long unmanagedMemory = this.getUnmanagedMemoryUsed(memoryMode$1);
        long availableMemory = maxMemory$1 - package$.MODULE$.min(storagePool$1.memoryUsed(), storageRegionSize$1);
        return package$.MODULE$.max(0L, availableMemory - unmanagedMemory);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxHeapMemory, long onHeapStorageRegionSize, int numCores) {
        this.maxHeapMemory = maxHeapMemory;
        this.onHeapStorageRegionSize = onHeapStorageRegionSize;
        super(conf, numCores, onHeapStorageRegionSize, maxHeapMemory - onHeapStorageRegionSize);
        this.unmanagedMemoryPollingIntervalMs = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.UNMANAGED_MEMORY_POLLING_INTERVAL()));
        if (this.unmanagedMemoryPollingIntervalMs() > 0L) {
            UnifiedMemoryManager$.MODULE$.startPollingIfNeeded(this.unmanagedMemoryPollingIntervalMs());
        }
        this.assertInvariants();
    }
}

